/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.lspcli.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.lspcli.server.LspCliLanguageServer;
import org.bsplines.lspcli.tools.FileIo;
import org.bsplines.lspcli.tools.I18n;
import org.bsplines.lspcli.tools.Logging;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00030\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0015H\u0002J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010&\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010'H\u0016J\u0012\u0010(\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001d2\b\u0010$\u001a\u0004\u0018\u00010+H\u0016J\u0012\u0010,\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u001eH\u0016R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lorg/bsplines/lspcli/client/LspCliLanguageClient;", "Lorg/eclipse/lsp4j/services/LanguageClient;", "serverCommandLine", "", "", "serverWorkingDirPath", "Ljava/nio/file/Path;", "clientConfigurationFilePath", "(Ljava/util/List;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "_diagnosticsMap", "", "Lorg/eclipse/lsp4j/Diagnostic;", "clientConfiguration", "Lcom/google/gson/JsonObject;", "getClientConfiguration", "()Lcom/google/gson/JsonObject;", "diagnosticsMap", "", "getDiagnosticsMap", "()Ljava/util/Map;", "languageServer", "Lorg/eclipse/lsp4j/services/LanguageServer;", "getLanguageServer", "()Lorg/eclipse/lsp4j/services/LanguageServer;", "languageServerProcess", "Ljava/lang/Process;", "getLanguageServerProcess", "()Ljava/lang/Process;", "configuration", "Ljava/util/concurrent/CompletableFuture;", "", "configurationParams", "Lorg/eclipse/lsp4j/ConfigurationParams;", "initializeLanguageServer", "logMessage", "", "params", "Lorg/eclipse/lsp4j/MessageParams;", "publishDiagnostics", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "showMessage", "showMessageRequest", "Lorg/eclipse/lsp4j/MessageActionItem;", "Lorg/eclipse/lsp4j/ShowMessageRequestParams;", "telemetryEvent", "Companion", "lspcli"})
public final class LspCliLanguageClient
implements LanguageClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Process languageServerProcess;
    @NotNull
    private final LanguageServer languageServer;
    @NotNull
    private final JsonObject clientConfiguration;
    @NotNull
    private final Map<String, List<Diagnostic>> _diagnosticsMap;

    public LspCliLanguageClient(@NotNull List<String> serverCommandLine, @Nullable Path serverWorkingDirPath, @Nullable Path clientConfigurationFilePath) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter(serverCommandLine, (String)"serverCommandLine");
        this.languageServerProcess = LspCliLanguageClient.Companion.startLanguageServerProcess(serverCommandLine, serverWorkingDirPath);
        this.languageServer = this.initializeLanguageServer();
        if (clientConfigurationFilePath != null) {
            JsonObject jsonObject2 = JsonParser.parseString((String)FileIo.INSTANCE.readFileWithException(clientConfigurationFilePath)).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"{\n    JsonParser.parseSt\u2026lePath)).asJsonObject\n  }");
            jsonObject = jsonObject2;
        } else {
            jsonObject = new JsonObject();
        }
        this.clientConfiguration = jsonObject;
        this._diagnosticsMap = new HashMap();
    }

    public /* synthetic */ LspCliLanguageClient(List list, Path path, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = null;
        }
        if ((n & 4) != 0) {
            path2 = null;
        }
        this(list, path, path2);
    }

    @NotNull
    public final Process getLanguageServerProcess() {
        return this.languageServerProcess;
    }

    @NotNull
    public final LanguageServer getLanguageServer() {
        return this.languageServer;
    }

    @NotNull
    public final JsonObject getClientConfiguration() {
        return this.clientConfiguration;
    }

    @NotNull
    public final Map<String, List<Diagnostic>> getDiagnosticsMap() {
        return this._diagnosticsMap;
    }

    public void telemetryEvent(@Nullable Object params) {
    }

    public void publishDiagnostics(@Nullable PublishDiagnosticsParams params) {
        PublishDiagnosticsParams publishDiagnosticsParams = params;
        String string = publishDiagnosticsParams == null ? null : publishDiagnosticsParams.getUri();
        if (string == null) {
            return;
        }
        String uri = string;
        List list = params.getDiagnostics();
        if (list == null) {
            return;
        }
        List diagnostics = list;
        this._diagnosticsMap.put(uri, diagnostics);
    }

    public void showMessage(@Nullable MessageParams params) {
    }

    @NotNull
    public CompletableFuture<MessageActionItem> showMessageRequest(@Nullable ShowMessageRequestParams params) {
        CompletableFuture<MessageActionItem> completableFuture = CompletableFuture.completedFuture(new MessageActionItem());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(MessageActionItem())");
        return completableFuture;
    }

    public void logMessage(@Nullable MessageParams params) {
    }

    @NotNull
    public CompletableFuture<List<Object>> configuration(@Nullable ConfigurationParams configurationParams) {
        if (configurationParams == null) {
            CompletableFuture<List<Object>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(emptyList())");
            return completableFuture;
        }
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        for (Object e : configurationParams.getItems()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"configurationParams.items");
            ConfigurationItem ignored = (ConfigurationItem)e;
            result.add(this.clientConfiguration);
        }
        CompletableFuture completableFuture = CompletableFuture.completedFuture(result);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"completedFuture(result)");
        return completableFuture;
    }

    private final LanguageServer initializeLanguageServer() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor()");
        ExecutorService executorService = scheduledExecutorService;
        LSPLauncher.Builder launcherBuilder = new LSPLauncher.Builder();
        launcherBuilder.setLocalService((Object)this);
        launcherBuilder.setRemoteInterface(LspCliLanguageServer.class);
        launcherBuilder.setInput(this.languageServerProcess.getInputStream());
        launcherBuilder.setOutput(this.languageServerProcess.getOutputStream());
        launcherBuilder.setExecutorService(executorService);
        Launcher launcher = launcherBuilder.create();
        Intrinsics.checkNotNullExpressionValue((Object)launcher, (String)"launcherBuilder.create()");
        Launcher launcher2 = launcher;
        Object object = launcher2.getRemoteProxy();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"launcher.remoteProxy");
        LanguageServer server = (LanguageServer)object;
        launcher2.startListening();
        executorService.shutdown();
        Logging.INSTANCE.getLogger().info(I18n.INSTANCE.format("initializingLanguageServer", new Object[0]));
        server.initialize(new InitializeParams()).get();
        return server;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/bsplines/lspcli/client/LspCliLanguageClient$Companion;", "", "()V", "startLanguageServerProcess", "Ljava/lang/Process;", "serverCommandLine", "", "", "serverWorkingDirPath", "Ljava/nio/file/Path;", "lspcli"})
    public static final class Companion {
        private Companion() {
        }

        private final Process startLanguageServerProcess(List<String> serverCommandLine, Path serverWorkingDirPath) {
            List absoluteServerCommandLine = CollectionsKt.toMutableList((Collection)serverCommandLine);
            if (serverWorkingDirPath != null) {
                absoluteServerCommandLine.set(0, ((Object)serverWorkingDirPath.resolve((String)absoluteServerCommandLine.get(0))).toString());
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = CollectionsKt.joinToString$default((Iterable)absoluteServerCommandLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            Path path = serverWorkingDirPath;
            objectArray[1] = path == null ? null : path.toFile();
            Logging.INSTANCE.getLogger().info(I18n.INSTANCE.format("startingLanguageServer", objectArray));
            Path path2 = serverWorkingDirPath;
            ProcessBuilder processBuilder = new ProcessBuilder(absoluteServerCommandLine).directory((File)(path2 == null ? null : path2.toFile()));
            Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"ProcessBuilder(absoluteS\u2026WorkingDirPath?.toFile())");
            ProcessBuilder processBuilder2 = processBuilder;
            Process process = processBuilder2.start();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"processBuilder.start()");
            Process process2 = process;
            Runtime.getRuntime().addShutdownHook(new Thread(process2::destroy));
            return process2;
        }

        static /* synthetic */ Process startLanguageServerProcess$default(Companion companion, List list, Path path, int n, Object object) {
            if ((n & 2) != 0) {
                path = null;
            }
            return companion.startLanguageServerProcess(list, path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

