/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.lspcli.tools;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bsplines.lspcli.tools.I18n;
import org.bsplines.lspcli.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lorg/bsplines/lspcli/tools/FileIo;", "", "()V", "getCodeLanguageIdFromPath", "", "path", "Ljava/nio/file/Path;", "readFile", "filePath", "readFileWithException", "writeFile", "", "text", "writeFileWithException", "lspcli"})
public final class FileIo {
    @NotNull
    public static final FileIo INSTANCE = new FileIo();

    private FileIo() {
    }

    @Nullable
    public final String readFile(@NotNull Path filePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            string = this.readFileWithException(filePath);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{((Object)filePath).toString()};
            Logging.INSTANCE.getLogger().warning(I18n.INSTANCE.format("couldNotReadFile", e, objectArray));
            string = null;
        }
        return string;
    }

    @NotNull
    public final String readFileWithException(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        byte[] byArray = Files.readAllBytes(filePath);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(filePath)");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        return new String(byArray, charset);
    }

    public final void writeFile(@NotNull Path filePath, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            this.writeFileWithException(filePath, text);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{((Object)filePath).toString()};
            Logging.INSTANCE.getLogger().warning(I18n.INSTANCE.format("couldNotWriteFile", e, objectArray));
        }
    }

    public final void writeFileWithException(@NotNull Path filePath, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = text.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC};
        Files.write(filePath, byArray, openOptionArray);
    }

    @Nullable
    public final String getCodeLanguageIdFromPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String fileName = ((Object)path.getFileName()).toString();
        return StringsKt.endsWith$default((String)fileName, (String)".bib", (boolean)false, (int)2, null) ? "bibtex" : (StringsKt.endsWith$default((String)fileName, (String)".c", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".h", (boolean)false, (int)2, null) ? "c" : (StringsKt.endsWith$default((String)fileName, (String)".clj", (boolean)false, (int)2, null) ? "clojure" : (StringsKt.endsWith$default((String)fileName, (String)".coffee", (boolean)false, (int)2, null) ? "coffeescript" : (StringsKt.endsWith$default((String)fileName, (String)".cc", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".cpp", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".cxx", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".hh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".hpp", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".inl", (boolean)false, (int)2, null) ? "cpp" : (StringsKt.endsWith$default((String)fileName, (String)".cs", (boolean)false, (int)2, null) ? "csharp" : (StringsKt.endsWith$default((String)fileName, (String)".dart", (boolean)false, (int)2, null) ? "dart" : (StringsKt.endsWith$default((String)fileName, (String)".ex", (boolean)false, (int)2, null) ? "elixir" : (StringsKt.endsWith$default((String)fileName, (String)".elm", (boolean)false, (int)2, null) ? "elm" : (StringsKt.endsWith$default((String)fileName, (String)".erl", (boolean)false, (int)2, null) ? "erlang" : (StringsKt.endsWith$default((String)fileName, (String)".f90", (boolean)false, (int)2, null) ? "fortran-modern" : (StringsKt.endsWith$default((String)fileName, (String)".fs", (boolean)false, (int)2, null) ? "fsharp" : (StringsKt.endsWith$default((String)fileName, (String)".go", (boolean)false, (int)2, null) ? "go" : (StringsKt.endsWith$default((String)fileName, (String)".groovy", (boolean)false, (int)2, null) ? "groovy" : (StringsKt.endsWith$default((String)fileName, (String)".hs", (boolean)false, (int)2, null) ? "haskell" : (StringsKt.endsWith$default((String)fileName, (String)".htm", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".html", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".xht", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".xhtml", (boolean)false, (int)2, null) ? "html" : (StringsKt.endsWith$default((String)fileName, (String)".java", (boolean)false, (int)2, null) ? "java" : (StringsKt.endsWith$default((String)fileName, (String)".js", (boolean)false, (int)2, null) ? "javascript" : (StringsKt.endsWith$default((String)fileName, (String)".jl", (boolean)false, (int)2, null) ? "julia" : (StringsKt.endsWith$default((String)fileName, (String)".kt", (boolean)false, (int)2, null) ? "kotlin" : (StringsKt.endsWith$default((String)fileName, (String)".tex", (boolean)false, (int)2, null) ? "latex" : (StringsKt.endsWith$default((String)fileName, (String)".lisp", (boolean)false, (int)2, null) ? "lisp" : (StringsKt.endsWith$default((String)fileName, (String)".lua", (boolean)false, (int)2, null) ? "lua" : (StringsKt.endsWith$default((String)fileName, (String)".md", (boolean)false, (int)2, null) ? "markdown" : (StringsKt.endsWith$default((String)fileName, (String)".m", (boolean)false, (int)2, null) ? "matlab" : (StringsKt.endsWith$default((String)fileName, (String)".org", (boolean)false, (int)2, null) ? "org" : (StringsKt.endsWith$default((String)fileName, (String)".pl", (boolean)false, (int)2, null) ? "perl" : (StringsKt.endsWith$default((String)fileName, (String)".php", (boolean)false, (int)2, null) ? "php" : (StringsKt.endsWith$default((String)fileName, (String)".txt", (boolean)false, (int)2, null) ? "plaintext" : (StringsKt.endsWith$default((String)fileName, (String)".ps1", (boolean)false, (int)2, null) ? "powershell" : (StringsKt.endsWith$default((String)fileName, (String)".pp", (boolean)false, (int)2, null) ? "puppet" : (StringsKt.endsWith$default((String)fileName, (String)".py", (boolean)false, (int)2, null) ? "python" : (StringsKt.endsWith$default((String)fileName, (String)".r", (boolean)false, (int)2, null) ? "r" : (StringsKt.endsWith$default((String)fileName, (String)".rst", (boolean)false, (int)2, null) ? "restructuredtext" : (StringsKt.endsWith$default((String)fileName, (String)".Rnw", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".rnw", (boolean)false, (int)2, null) ? "rsweave" : (StringsKt.endsWith$default((String)fileName, (String)".rb", (boolean)false, (int)2, null) ? "ruby" : (StringsKt.endsWith$default((String)fileName, (String)".rs", (boolean)false, (int)2, null) ? "rust" : (StringsKt.endsWith$default((String)fileName, (String)".scala", (boolean)false, (int)2, null) ? "scala" : (StringsKt.endsWith$default((String)fileName, (String)".sh", (boolean)false, (int)2, null) ? "shellscript" : (StringsKt.endsWith$default((String)fileName, (String)".sql", (boolean)false, (int)2, null) ? "sql" : (StringsKt.endsWith$default((String)fileName, (String)".swift", (boolean)false, (int)2, null) ? "swift" : (StringsKt.endsWith$default((String)fileName, (String)".ts", (boolean)false, (int)2, null) ? "typescript" : (StringsKt.endsWith$default((String)fileName, (String)".vb", (boolean)false, (int)2, null) ? "vb" : (StringsKt.endsWith$default((String)fileName, (String)".v", (boolean)false, (int)2, null) ? "verilog" : (String)null)))))))))))))))))))))))))))))))))))))))))));
    }
}

