/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.spec.ResourceResolverManager;
import com.vladsch.flexmark.test.util.spec.ResourceUrlResolver;

public class FlexmarkResourceUrlResolver {
    public static void registerUrlResolvers() {
        ResourceResolverManager.registerUrlResolver(new TargetTestClassUrlResolver());
        ResourceResolverManager.registerUrlResolver(new OutTestResourcesUrlResolver());
    }

    private static class OutTestResourcesUrlResolver
    implements ResourceUrlResolver {
        static final String OUT_TEST = "/out/test/";

        OutTestResourcesUrlResolver() {
        }

        @Override
        public String apply(String externalForm) {
            int pathPos;
            String noFileProtocol;
            int pos;
            if (ResourceUrlResolver.isFileProtocol(externalForm) && (pos = (noFileProtocol = ResourceUrlResolver.removeProtocol(externalForm)).indexOf(OUT_TEST)) > 0 && (pathPos = noFileProtocol.indexOf("/", pos + OUT_TEST.length())) > 0) {
                return noFileProtocol.substring(0, pos) + "/" + noFileProtocol.substring(pos + OUT_TEST.length(), pathPos) + "/src/test/resources/" + noFileProtocol.substring(pathPos + 1);
            }
            return null;
        }
    }

    private static class TargetTestClassUrlResolver
    implements ResourceUrlResolver {
        static final String TARGET_TEST_CLASSES = "/target/test-classes/";

        TargetTestClassUrlResolver() {
        }

        @Override
        public String apply(String externalForm) {
            String noFileProtocol;
            if (ResourceUrlResolver.isFileProtocol(externalForm) && (noFileProtocol = ResourceUrlResolver.removeProtocol(externalForm)).contains(TARGET_TEST_CLASSES)) {
                return noFileProtocol.replace(TARGET_TEST_CLASSES, "/src/test/resources/");
            }
            return null;
        }
    }
}

