/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.SettableExtractedInstance;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.Collection;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettableInstance<T> {
    @NotNull
    private final DataKey<Consumer<T>> myConsumerKey;
    @Nullable
    private final Collection<SettableExtractedInstance<T, ?>> myExtractedInstanceSetters;

    public SettableInstance(@NotNull DataKey<Consumer<T>> consumerKey, @NotNull Collection<SettableExtractedInstance<T, ?>> extractedInstanceSetters) {
        this.myConsumerKey = consumerKey;
        this.myExtractedInstanceSetters = extractedInstanceSetters.size() == 0 ? null : extractedInstanceSetters;
    }

    public SettableInstance(@NotNull DataKey<Consumer<T>> consumerKey) {
        this.myConsumerKey = consumerKey;
        this.myExtractedInstanceSetters = null;
    }

    @NotNull
    public T setInstanceData(@NotNull T instance, @Nullable DataHolder dataHolder) {
        if (dataHolder != null) {
            if (dataHolder.contains(this.myConsumerKey)) {
                ((Consumer)this.myConsumerKey.get(dataHolder)).accept(instance);
            }
            if (this.myExtractedInstanceSetters != null) {
                for (SettableExtractedInstance<T, ?> settableExtractedInstance : this.myExtractedInstanceSetters) {
                    settableExtractedInstance.aggregate(instance, dataHolder);
                }
            }
        }
        return instance;
    }

    public DataHolder aggregateActions(@NotNull DataHolder dataHolder, @Nullable DataHolder other, @Nullable DataHolder overrides) {
        DataHolder results = dataHolder;
        if (other != null && other.contains(this.myConsumerKey) && overrides != null && overrides.contains(this.myConsumerKey)) {
            Consumer otherSetter = (Consumer)this.myConsumerKey.get(other);
            Consumer overridesSetter = (Consumer)this.myConsumerKey.get(overrides);
            results = results.toMutable().set(this.myConsumerKey, otherSetter.andThen(overridesSetter));
        }
        if (this.myExtractedInstanceSetters != null) {
            for (SettableExtractedInstance<T, ?> settableExtractedInstance : this.myExtractedInstanceSetters) {
                results = settableExtractedInstance.aggregateActions(results, other, overrides);
            }
        }
        return results;
    }
}

