/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util.spec;

import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.ResourceLocation;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.test.util.spec.SpecReaderFactory;
import com.vladsch.flexmark.util.misc.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SpecReader {
    public static final String EXAMPLE_KEYWORD = "example";
    public static final String EXAMPLE_BREAK = "````````````````````````````````";
    public static final String EXAMPLE_START = "```````````````````````````````` example";
    public static final String EXAMPLE_START_NBSP = "````````````````````````````````\u00a0example";
    public static final String EXAMPLE_TEST_BREAK = "````````````````";
    public static final String EXAMPLE_TEST_START = "```````````````` example";
    public static final String OPTIONS_KEYWORD = "options";
    public static final String OPTIONS_STRING = " options";
    public static final Pattern OPTIONS_PATTERN = Pattern.compile(".*(?:\\s|\u00a0)\\Qoptions\\E(?:\\s|\u00a0)*\\((?:\\s|\u00a0)*(.*)(?:\\s|\u00a0)*\\)(?:\\s|\u00a0)*");
    public static final String SECTION_BREAK = ".";
    public static final String SECTION_TEST_BREAK = "\u2026";
    protected static final Pattern SECTION_PATTERN = Pattern.compile("#{1,6} +(.*)");
    @NotNull
    protected final InputStream inputStream;
    @NotNull
    protected final ResourceLocation resourceLocation;
    protected final boolean compoundSections;
    protected final List<SpecExample> examples = new ArrayList<SpecExample>();
    protected final String[] sections = new String[7];
    protected int lastSectionLevel = 1;
    protected State state = State.BEFORE;
    protected String section;
    protected String optionsSet;
    protected StringBuilder source;
    protected StringBuilder html;
    protected StringBuilder ast;
    protected StringBuilder comment;
    protected int exampleNumber = 0;
    protected int lineNumber = 0;
    protected int contentLineNumber = 0;
    protected int commentLineNumber = 0;

    public SpecReader(@NotNull InputStream stream, @NotNull ResourceLocation location, boolean compoundSections) {
        this.inputStream = stream;
        this.resourceLocation = location;
        this.compoundSections = compoundSections;
    }

    @NotNull
    public String getFileUrl() {
        return this.resourceLocation.getFileUrl();
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @NotNull
    public List<SpecExample> getExamples() {
        return this.examples;
    }

    @NotNull
    public List<String> getExamplesSourceAsString() {
        ArrayList<String> result = new ArrayList<String>();
        for (SpecExample example : this.examples) {
            result.add(example.getSource());
        }
        return result;
    }

    @NotNull
    public static SpecReader create(@NotNull ResourceLocation location, boolean compoundSections) {
        return SpecReader.create(location, (stream, location1) -> new SpecReader(stream, location1, compoundSections));
    }

    @NotNull
    public static <S extends SpecReader> S create(@NotNull ResourceLocation location, @NotNull SpecReaderFactory<S> readerFactory) {
        InputStream stream = location.getResourceInputStream();
        return readerFactory.create(stream, location);
    }

    @NotNull
    public static SpecReader createAndReadExamples(@NotNull ResourceLocation location, boolean compoundSections) {
        return SpecReader.createAndReadExamples(location, (stream, location1) -> new SpecReader(stream, location1, compoundSections));
    }

    @NotNull
    public static <S extends SpecReader> S createAndReadExamples(@NotNull ResourceLocation location, @NotNull SpecReaderFactory<S> readerFactory) {
        S reader = SpecReader.create(location, readerFactory);
        ((SpecReader)reader).readExamples();
        return reader;
    }

    public void readExamples() {
        try {
            String line;
            this.resetContents();
            this.lineNumber = 0;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                ++this.lineNumber;
                this.processLine(line);
            }
            if (this.state == State.COMMENT) {
                throw new IllegalStateException("Unterminated comment\n" + this.resourceLocation.getFileUrl(this.commentLineNumber));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addSpecLine(String line, boolean isSpecExampleOpen) {
    }

    protected void addSpecExample(@NotNull SpecExample example) {
        this.examples.add(example);
    }

    protected void processLine(String line) {
        boolean lineAbsorbed = false;
        boolean lineProcessed = false;
        switch (this.state) {
            case COMMENT: {
                String trimmed = line.trim();
                if (!line.trim().startsWith("-->")) break;
                if (trimmed.endsWith("<!--")) {
                    this.commentLineNumber = this.lineNumber - 1;
                } else {
                    this.state = State.BEFORE;
                }
                lineProcessed = true;
                break;
            }
            case BEFORE: {
                String trimmed = line.trim();
                if (trimmed.startsWith("<!--")) {
                    if (!trimmed.endsWith("-->")) {
                        this.state = State.COMMENT;
                        this.commentLineNumber = this.lineNumber - 1;
                    }
                    lineProcessed = true;
                    break;
                }
                Matcher matcher = SECTION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    if (this.compoundSections) {
                        Pair<String, Integer> pair = TestUtils.addSpecSection(matcher.group(), matcher.group(1), this.sections);
                        this.lastSectionLevel = (Integer)pair.getSecond();
                        this.section = (String)pair.getFirst();
                    } else {
                        this.section = matcher.group(1);
                    }
                    lineProcessed = true;
                    this.exampleNumber = 0;
                    break;
                }
                if (!line.startsWith(EXAMPLE_START) && !line.startsWith(EXAMPLE_START_NBSP)) break;
                Matcher option_matcher = OPTIONS_PATTERN.matcher(line.subSequence(EXAMPLE_START.length(), line.length()));
                if (option_matcher.matches()) {
                    this.optionsSet = option_matcher.group(1);
                }
                this.state = State.SOURCE;
                ++this.exampleNumber;
                this.contentLineNumber = this.lineNumber;
                break;
            }
            case SOURCE: {
                if (line.equals(SECTION_BREAK)) {
                    this.state = State.HTML;
                } else {
                    String processedLine = TestUtils.fromVisibleSpecText(line);
                    this.source.append(processedLine).append('\n');
                }
                lineAbsorbed = true;
                break;
            }
            case HTML: {
                if (line.equals(EXAMPLE_BREAK)) {
                    this.state = State.BEFORE;
                    this.addSpecExample(new SpecExample(this.resourceLocation, this.contentLineNumber, this.optionsSet, this.section, this.exampleNumber, this.source.toString(), this.html.toString(), null, this.comment == null ? null : this.comment.toString()));
                    this.resetContents();
                    lineAbsorbed = true;
                    break;
                }
                if (line.equals(SECTION_BREAK)) {
                    this.state = State.AST;
                    lineAbsorbed = true;
                    break;
                }
                String processedLine = TestUtils.fromVisibleSpecText(line);
                this.html.append(processedLine).append('\n');
                lineAbsorbed = true;
                break;
            }
            case AST: {
                if (line.equals(EXAMPLE_BREAK)) {
                    this.state = State.BEFORE;
                    this.addSpecExample(new SpecExample(this.resourceLocation, this.contentLineNumber, this.optionsSet, this.section, this.exampleNumber, this.source.toString(), this.html.toString(), this.ast.toString(), this.comment == null ? null : this.comment.toString()));
                    this.resetContents();
                } else {
                    this.ast.append(line).append('\n');
                }
                lineAbsorbed = true;
            }
        }
        if (!lineAbsorbed) {
            if (lineProcessed) {
                this.comment = null;
            } else if (this.section != null && this.state == State.BEFORE) {
                if (this.comment == null) {
                    this.comment = new StringBuilder();
                }
                this.comment.append(line).append('\n');
            }
            this.addSpecLine(line, this.state != State.BEFORE && this.state != State.COMMENT);
        }
    }

    protected void resetContents() {
        this.optionsSet = "";
        this.source = new StringBuilder();
        this.html = new StringBuilder();
        this.ast = new StringBuilder();
        this.comment = null;
        this.contentLineNumber = 0;
    }

    protected static enum State {
        BEFORE,
        SOURCE,
        HTML,
        AST,
        COMMENT;

    }
}

