/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.synthesis.BaseSynthesizer;

public class SpanishSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/es/es-ES_synth.dict";
    private static final String TAGS_FILE_NAME = "/es/es-ES_tags.txt";
    private static final Pattern pLemmaSpace = Pattern.compile("([^ ]+) (.+)");
    public static final SpanishSynthesizer INSTANCE = new SpanishSynthesizer();

    public SpanishSynthesizer(Language lang) {
        this();
    }

    private SpanishSynthesizer() {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME, "es");
    }

    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        Matcher mLemmaSpace;
        if (posTag.startsWith("_spell_number_")) {
            return super.synthesize(token, posTag);
        }
        String lemma = token.getLemma();
        String toAddAfter = "";
        if (posTag.startsWith("V") && (mLemmaSpace = pLemmaSpace.matcher(lemma)).matches()) {
            lemma = mLemmaSpace.group(1);
            toAddAfter = mLemmaSpace.group(2);
        }
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.lookup(lemma, posTag));
        return this.addWordsAfter(results, toAddAfter).toArray(new String[0]);
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTag.startsWith("_spell_number_")) {
            return this.synthesize(token, posTag);
        }
        if (posTagRegExp) {
            Pattern p;
            Matcher mLemmaSpace;
            String lemma = token.getLemma();
            String toAddAfter = "";
            if (posTag.startsWith("V") && (mLemmaSpace = pLemmaSpace.matcher(lemma)).matches()) {
                lemma = mLemmaSpace.group(1);
                toAddAfter = mLemmaSpace.group(2);
            }
            this.initPossibleTags();
            try {
                p = Pattern.compile(posTag);
            }
            catch (PatternSyntaxException e) {
                System.err.println("WARNING: Error trying to synthesize POS tag " + posTag + " from token " + token.getToken() + ": " + e.getMessage());
                return null;
            }
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches()) continue;
                results.addAll(this.lookup(lemma, tag));
            }
            return this.addWordsAfter(results, toAddAfter).toArray(new String[0]);
        }
        return this.synthesize(token, posTag);
    }

    private List<String> addWordsAfter(List<String> results, String toAddAfter) {
        if (!toAddAfter.isEmpty()) {
            ArrayList<String> output = new ArrayList<String>();
            for (String result : results) {
                output.add(result + " " + toAddAfter);
            }
            return output;
        }
        return results;
    }
}

