/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.rules.AbstractRepeatedWordsRule;
import org.languagetool.rules.SynonymsData;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class EnglishRepeatedWordsRule
extends AbstractRepeatedWordsRule {
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().csToken("need").matchInflectedForms().build(), PatternRuleBuilderHelper.token((String)"to")), Arrays.asList(new PatternTokenBuilder().tokenRegex("solve(s|d|ing)?").setSkip(3).build(), PatternRuleBuilderHelper.tokenRegex((String)"problems?")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"SENT_START|PCT"), PatternRuleBuilderHelper.token((String)"no"), PatternRuleBuilderHelper.token((String)"problem"), PatternRuleBuilderHelper.pos((String)"PCT")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"math|word"), PatternRuleBuilderHelper.tokenRegex((String)"problems?")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"as"), PatternRuleBuilderHelper.tokenRegex((String)"a"), PatternRuleBuilderHelper.tokenRegex((String)"whole")), Arrays.asList(PatternRuleBuilderHelper.token((String)"more"), PatternRuleBuilderHelper.token((String)"often"), PatternRuleBuilderHelper.token((String)"than"), PatternRuleBuilderHelper.token((String)"not")), Arrays.asList(PatternRuleBuilderHelper.token((String)"often"), PatternRuleBuilderHelper.token((String)"times")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"details?|facts?|it|journals?|questions?|research|results?|study|studies|this|these|those|which"), new PatternTokenBuilder().pos("RB").min(0).build(), new PatternTokenBuilder().csToken("suggest").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("form").matchInflectedForms().build(), PatternRuleBuilderHelper.posRegex((String)"IN|PCT|RP|TO|SENT_END")), Arrays.asList(new PatternTokenBuilder().tokenRegex("bonds?|crystals?|ions?|rocks?|.*valence").setSkip(10).build(), new PatternTokenBuilder().csToken("form").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("form(s|ed|ing)?").setSkip(10).build(), PatternRuleBuilderHelper.tokenRegex((String)"bonds?|crystals?|ions?|rocks?|.*valence")), Arrays.asList(PatternRuleBuilderHelper.token((String)"interesting"), PatternRuleBuilderHelper.tokenRegex((String)"facts?|things?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"several"), PatternRuleBuilderHelper.tokenRegex((String)"hundreds?|thousands?|millions?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"must"), PatternRuleBuilderHelper.token((String)"be"), PatternRuleBuilderHelper.token((String)"nice")), Arrays.asList(PatternRuleBuilderHelper.token((String)"nice"), PatternRuleBuilderHelper.token((String)"day")), Arrays.asList(PatternRuleBuilderHelper.token((String)"nice"), PatternRuleBuilderHelper.token((String)"to"), new PatternTokenBuilder().token("meet").min(0).build(), PatternRuleBuilderHelper.posRegex((String)"PRP_O.*")), Arrays.asList(new PatternTokenBuilder().csToken("be").matchInflectedForms().build(), PatternRuleBuilderHelper.token((String)"nice"), PatternRuleBuilderHelper.token((String)"and"), PatternRuleBuilderHelper.pos((String)"JJ"), PatternRuleBuilderHelper.posRegex((String)"PCT|SENT_END")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"P?DT|PRP$.*"), PatternRuleBuilderHelper.token((String)"proposed"), PatternRuleBuilderHelper.posRegex((String)"N.*")), Arrays.asList(new PatternTokenBuilder().csToken("propose").matchInflectedForms().build(), PatternRuleBuilderHelper.tokenRegex((String)"to|marriage")), Arrays.asList(PatternRuleBuilderHelper.token((String)"too"), PatternRuleBuilderHelper.token((String)"literally")), Arrays.asList(PatternRuleBuilderHelper.token((String)"literally"), PatternRuleBuilderHelper.token((String)"and"), PatternRuleBuilderHelper.token((String)"figuratively")), Arrays.asList(PatternRuleBuilderHelper.token((String)"literally"), PatternRuleBuilderHelper.token((String)"everything")), Arrays.asList(PatternRuleBuilderHelper.token((String)"literally"), PatternRuleBuilderHelper.posRegex((String)"PCT|SENT_END")), Arrays.asList(PatternRuleBuilderHelper.posRegex((String)"CC"), PatternRuleBuilderHelper.token((String)"maybe")));
    private static final Map<String, SynonymsData> wordsToCheck = EnglishRepeatedWordsRule.loadWords((String)"/en/synonyms.txt");

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public EnglishRepeatedWordsRule(ResourceBundle messages) {
        super(messages, (Language)new AmericanEnglish());
        this.setTags(Collections.singletonList(Tag.picky));
        this.antiPatterns = EnglishRepeatedWordsRule.cacheAntiPatterns((Language)new AmericanEnglish(), ANTI_PATTERNS);
    }

    protected String getMessage() {
        return "This word has been used in one of the immediately preceding sentences. Using a synonym could make your text more interesting to read, unless the repetition is intentional.";
    }

    public String getDescription() {
        return "Suggest synonyms for repeated words.";
    }

    protected Map<String, SynonymsData> getWordsToCheck() {
        return wordsToCheck;
    }

    protected String getShortMessage() {
        return "Style: repeated word";
    }

    protected Synthesizer getSynthesizer() {
        return EnglishSynthesizer.INSTANCE;
    }

    protected boolean isException(AnalyzedTokenReadings[] tokens, int i, boolean sentStart, boolean isCapitalized, boolean isAllUppercase) {
        if (isAllUppercase || isCapitalized && !sentStart) {
            return true;
        }
        return tokens[i].hasPosTagStartingWith("NNP");
    }
}

