/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ar;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Arabic;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class ArabicWordinessRule
extends AbstractSimpleReplaceRule2 {
    public static final String AR_WORDINESS_REPLACE = "AR_WORDINESS_REPLACE";
    private static final String FILE_NAME = "/ar/wordiness.txt";
    private static final Locale AR_LOCALE = new Locale("ar");

    public ArabicWordinessRule(ResourceBundle messages) {
        super(messages, (Language)new Arabic());
        super.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>\u0647\u0646\u0627\u0643 \u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0639\u0628\u0627\u0631\u0629</marker>"), Example.fixed((String)"<marker>\u0641\u064a \u0627\u0644\u0639\u0628\u0627\u0631\u0629 \u062e\u0637\u0623</marker>"));
    }

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public final String getId() {
        return AR_WORDINESS_REPLACE;
    }

    public String getDescription() {
        return "2. \u062d\u0634\u0648(\u062a\u0639\u0628\u064a\u0631 \u0641\u064a\u0647 \u062a\u0643\u0631\u0627\u0631)";
    }

    public String getShort() {
        return "\u062d\u0634\u0648 (\u062a\u0639\u0628\u064a\u0631 \u0641\u064a\u0647 \u062a\u0643\u0631\u0627\u0631)";
    }

    public String getMessage() {
        return "'$match' \u062a\u0639\u0628\u064a\u0631 \u0641\u064a\u0647 \u062d\u0634\u0648 \u064a\u0641\u0636\u0644 \u0623\u0646 \u064a\u0642\u0627\u0644 $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " \u0623\u0648 ";
    }

    public Locale getLocale() {
        return AR_LOCALE;
    }
}

