/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.nl.PreferredWordRuleWithSuggestion;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;

class PreferredWordData {
    private final List<PreferredWordRuleWithSuggestion> spellingRules = new ArrayList<PreferredWordRuleWithSuggestion>();

    PreferredWordData(String ruleDesc, String filePath, String ruleId) {
        Language dutch = Languages.getLanguageForShortCode((String)"nl");
        String message = "Voor dit woord is een gebruikelijker alternatief.";
        String shortMessage = "Gebruikelijker woord";
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(filePath);
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split(";");
            if (parts.length != 2) {
                throw new RuntimeException("Unexpected format in file " + filePath + ": " + line);
            }
            String oldWord = parts[0];
            String newWord = parts[1];
            List<PatternToken> patternTokens = this.getTokens(oldWord);
            PatternRule rule = new PatternRule(ruleId + "_INTERNAL", dutch, patternTokens, ruleDesc, message, shortMessage);
            this.spellingRules.add(new PreferredWordRuleWithSuggestion((Rule)rule, oldWord, newWord));
        }
    }

    @NotNull
    private List<PatternToken> getTokens(String oldWord) {
        PatternTokenBuilder builder = new PatternTokenBuilder();
        String[] newWordTokens = oldWord.split(" ");
        ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
        for (String part : newWordTokens) {
            patternTokens.add(builder.csToken(part).build());
        }
        return patternTokens;
    }

    public List<PreferredWordRuleWithSuggestion> get() {
        return this.spellingRules;
    }
}

