/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Objects;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

public class PlainTextByLineStream
implements ObjectStream<String> {
    private final Charset encoding;
    private InputStreamFactory inputStreamFactory;
    private BufferedReader in;

    public PlainTextByLineStream(InputStreamFactory inputStreamFactory, String charsetName) throws IOException {
        this(inputStreamFactory, Charset.forName(charsetName));
    }

    public PlainTextByLineStream(InputStreamFactory inputStreamFactory, Charset charset) throws IOException {
        this.inputStreamFactory = Objects.requireNonNull(inputStreamFactory, "inputStreamFactory must not be null!");
        this.encoding = charset;
        this.reset();
    }

    @Override
    public String read() throws IOException {
        return this.in.readLine();
    }

    @Override
    public void reset() throws IOException {
        this.in = new BufferedReader(new InputStreamReader(this.inputStreamFactory.createInputStream(), this.encoding));
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

