/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.languagetool;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.languagetool.LanguageToolInterface;
import org.bsplines.ltexls.languagetool.LanguageToolRuleMatch;
import org.bsplines.ltexls.parsing.AnnotatedTextFragment;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.TextPart;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0016\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/bsplines/ltexls/languagetool/LanguageToolHttpInterface;", "Lorg/bsplines/ltexls/languagetool/LanguageToolInterface;", "uriString", "", "languageShortCode", "motherTongueShortCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "enabledRules", "", "httpClient", "Ljava/net/http/HttpClient;", "uri", "Ljava/net/URI;", "activateDefaultFalseFriendRules", "", "activateLanguageModelRules", "languageModelRulesDirectory", "checkInternal", "", "Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "annotatedTextFragment", "Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "createRequestBody", "enableEasterEgg", "enableRules", "ruleIds", "", "isInitialized", "", "Companion", "ltexls"})
public final class LanguageToolHttpInterface
extends LanguageToolInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String languageShortCode;
    @NotNull
    private final String motherTongueShortCode;
    @NotNull
    private final List<String> enabledRules;
    @NotNull
    private final HttpClient httpClient;
    @Nullable
    private final URI uri;
    private static final int STATUS_CODE_SUCCESS = 200;

    /*
     * WARNING - void declaration
     */
    public LanguageToolHttpInterface(@NotNull String uriString, @NotNull String languageShortCode, @NotNull String motherTongueShortCode) {
        Object[] objectArray;
        LanguageToolHttpInterface languageToolHttpInterface;
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        Intrinsics.checkNotNullParameter((Object)languageShortCode, (String)"languageShortCode");
        Intrinsics.checkNotNullParameter((Object)motherTongueShortCode, (String)"motherTongueShortCode");
        this.languageShortCode = languageShortCode;
        this.motherTongueShortCode = motherTongueShortCode;
        this.enabledRules = new ArrayList();
        HttpClient httpClient = HttpClient.newHttpClient();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"newHttpClient()");
        this.httpClient = httpClient;
        Exception exception = null;
        LanguageToolHttpInterface languageToolHttpInterface2 = this;
        try {
            languageToolHttpInterface = languageToolHttpInterface2;
            objectArray = new URL(new URL(uriString), "v2/check").toURI();
        }
        catch (MalformedURLException malformedURLException) {
            void e;
            languageToolHttpInterface = languageToolHttpInterface2;
            exception = (Exception)e;
            objectArray = null;
        }
        catch (URISyntaxException e) {
            languageToolHttpInterface = languageToolHttpInterface2;
            exception = e;
            objectArray = null;
        }
        languageToolHttpInterface.uri = objectArray;
        if (exception != null) {
            objectArray = new Object[]{uriString};
            Logging.INSTANCE.getLOGGER().severe(I18n.INSTANCE.format("couldNotParseHttpServerUri", exception, objectArray));
        }
    }

    @Override
    public boolean isInitialized() {
        return this.uri != null;
    }

    @Override
    @NotNull
    protected List<LanguageToolRuleMatch> checkInternal(@NotNull AnnotatedTextFragment annotatedTextFragment) {
        HttpResponse<String> httpResponse;
        Intrinsics.checkNotNullParameter((Object)annotatedTextFragment, (String)"annotatedTextFragment");
        if (!this.isInitialized()) {
            return CollectionsKt.emptyList();
        }
        String string = this.createRequestBody(annotatedTextFragment);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String requestBody = string;
        HttpRequest httpRequest = HttpRequest.newBuilder(this.uri).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"newBuilder(this.uri)\n   \u2026stBody))\n        .build()");
        HttpRequest httpRequest2 = httpRequest;
        try {
            HttpResponse<String> httpResponse2 = this.httpClient.send(httpRequest2, HttpResponse.BodyHandlers.ofString());
            Intrinsics.checkNotNullExpressionValue(httpResponse2, (String)"{\n      this.httpClient.\u2026andlers.ofString())\n    }");
            httpResponse = httpResponse2;
        }
        catch (InterruptedException e) {
            Logging.INSTANCE.getLOGGER().severe(I18n.INSTANCE.format("couldNotSendHttpRequestToLanguageTool", e, new Object[0]));
            return CollectionsKt.emptyList();
        }
        catch (IOException e) {
            Logging.INSTANCE.getLOGGER().severe(I18n.INSTANCE.format("couldNotSendHttpRequestToLanguageTool", e, new Object[0]));
            return CollectionsKt.emptyList();
        }
        HttpResponse<String> httpResponse3 = httpResponse;
        int statusCode = httpResponse3.statusCode();
        if (statusCode != 200) {
            Object[] e = new Object[]{statusCode};
            Logging.INSTANCE.getLOGGER().severe(I18n.INSTANCE.format("languageToolFailedWithStatusCode", e));
            return CollectionsKt.emptyList();
        }
        String string2 = httpResponse3.body();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"httpResponse.body()");
        String responseBody = string2;
        JsonObject jsonObject = JsonParser.parseString((String)responseBody).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"parseString(responseBody).asJsonObject");
        JsonObject jsonResponse = jsonObject;
        JsonArray jsonArray = jsonResponse.get("matches").getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"jsonResponse.get(\"matches\").asJsonArray");
        JsonArray jsonMatches = jsonArray;
        ArrayList<LanguageToolRuleMatch> result = new ArrayList<LanguageToolRuleMatch>();
        for (Object e : jsonMatches) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"jsonMatches");
            JsonElement jsonElement = (JsonElement)e;
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"jsonElement.asJsonObject");
            result.add(LanguageToolRuleMatch.Companion.fromLanguageTool(jsonObject2, annotatedTextFragment));
        }
        return result;
    }

    private final String createRequestBody(AnnotatedTextFragment annotatedTextFragment) {
        JsonObject jsonData = new JsonObject();
        jsonData.add("annotation", LanguageToolHttpInterface.Companion.convertAnnotatedTextToJson(annotatedTextFragment.getAnnotatedText()));
        HashMap requestEntries = new HashMap();
        ((Map)requestEntries).put("language", this.languageShortCode);
        Map map = requestEntries;
        String string = "data";
        String string2 = jsonData.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonData.toString()");
        String object2 = string2;
        map.put(string, object2);
        if (((CharSequence)this.getLanguageToolOrgUsername()).length() > 0) {
            ((Map)requestEntries).put("username", this.getLanguageToolOrgUsername());
        }
        if (((CharSequence)this.getLanguageToolOrgApiKey()).length() > 0) {
            ((Map)requestEntries).put("apiKey", this.getLanguageToolOrgApiKey());
        }
        if (annotatedTextFragment.getCodeFragment().getSettings().getEnablePickyRules()) {
            ((Map)requestEntries).put("level", "picky");
        }
        if (((CharSequence)this.motherTongueShortCode).length() > 0) {
            ((Map)requestEntries).put("motherTongue", this.motherTongueShortCode);
        }
        if (!((Collection)this.enabledRules).isEmpty()) {
            ((Map)requestEntries).put("enabledRules", CollectionsKt.joinToString$default((Iterable)this.enabledRules, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : ((Map)requestEntries).entrySet()) {
            String requestKey = (String)entry.getKey();
            String requestValue = (String)entry.getValue();
            if (((CharSequence)builder).length() > 0) {
                builder.append("&");
            }
            try {
                builder.append(URLEncoder.encode(requestKey, "utf-8")).append("=").append(URLEncoder.encode(requestValue, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logging.INSTANCE.getLOGGER().severe(I18n.INSTANCE.format(e));
                return null;
            }
        }
        return builder.toString();
    }

    @Override
    public void activateDefaultFalseFriendRules() {
    }

    @Override
    public void activateLanguageModelRules(@NotNull String languageModelRulesDirectory) {
        Intrinsics.checkNotNullParameter((Object)languageModelRulesDirectory, (String)"languageModelRulesDirectory");
    }

    @Override
    public void enableRules(@NotNull Set<String> ruleIds) {
        Intrinsics.checkNotNullParameter(ruleIds, (String)"ruleIds");
        this.enabledRules.addAll((Collection<String>)ruleIds);
    }

    @Override
    public void enableEasterEgg() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/bsplines/ltexls/languagetool/LanguageToolHttpInterface$Companion;", "", "()V", "STATUS_CODE_SUCCESS", "", "convertAnnotatedTextToJson", "Lcom/google/gson/JsonElement;", "annotatedText", "Lorg/languagetool/markup/AnnotatedText;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        private final JsonElement convertAnnotatedTextToJson(AnnotatedText annotatedText) {
            JsonArray jsonDataAnnotation = new JsonArray();
            List list = annotatedText.getParts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotatedText.parts");
            List parts = list;
            int i = 0;
            while (i < parts.size()) {
                JsonObject jsonPart = new JsonObject();
                if (((TextPart)parts.get(i)).getType() == TextPart.Type.TEXT) {
                    jsonPart.addProperty("text", ((TextPart)parts.get(i)).getPart());
                } else if (((TextPart)parts.get(i)).getType() == TextPart.Type.MARKUP) {
                    jsonPart.addProperty("markup", ((TextPart)parts.get(i)).getPart());
                    if (i < parts.size() - 1 && ((TextPart)parts.get(i + 1)).getType() == TextPart.Type.FAKE_CONTENT) {
                        jsonPart.addProperty("interpretAs", ((TextPart)parts.get(++i)).getPart());
                    }
                } else {
                    ++i;
                    continue;
                }
                jsonDataAnnotation.add((JsonElement)jsonPart);
                ++i;
            }
            return (JsonElement)jsonDataAnnotation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

