/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.languagetool;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.text.StringEscapeUtils;
import org.bsplines.ltexls.languagetool.LanguageToolInterface;
import org.bsplines.ltexls.languagetool.LanguageToolRuleMatch;
import org.bsplines.ltexls.parsing.AnnotatedTextFragment;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.bsplines.ltexls.tools.Tools;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.ResultCache;
import org.languagetool.RuleMatchListener;
import org.languagetool.UserConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.xml.sax.SAXException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0016\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/bsplines/ltexls/languagetool/LanguageToolJavaInterface;", "Lorg/bsplines/ltexls/languagetool/LanguageToolInterface;", "languageShortCode", "", "motherTongueShortCode", "sentenceCacheSize", "", "dictionary", "", "(Ljava/lang/String;Ljava/lang/String;JLjava/util/Set;)V", "languageTool", "Lorg/languagetool/JLanguageTool;", "resultCache", "Lorg/languagetool/ResultCache;", "activateDefaultFalseFriendRules", "", "activateLanguageModelRules", "languageModelRulesDirectory", "checkInternal", "", "Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "annotatedTextFragment", "Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "enableEasterEgg", "enableRules", "ruleIds", "isInitialized", "", "logResultCache", "Companion", "ltexls"})
public final class LanguageToolJavaInterface
extends LanguageToolInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResultCache resultCache;
    @Nullable
    private final JLanguageTool languageTool;
    private static final long RESULT_CACHE_EXPIRE_AFTER_MINUTES = 60L;

    public LanguageToolJavaInterface(@NotNull String languageShortCode, @NotNull String motherTongueShortCode, long sentenceCacheSize, @NotNull Set<String> dictionary) {
        Intrinsics.checkNotNullParameter((Object)languageShortCode, (String)"languageShortCode");
        Intrinsics.checkNotNullParameter((Object)motherTongueShortCode, (String)"motherTongueShortCode");
        Intrinsics.checkNotNullParameter(dictionary, (String)"dictionary");
        this.resultCache = new ResultCache(sentenceCacheSize, 60L, TimeUnit.MINUTES);
        if (Languages.isLanguageSupported((String)languageShortCode)) {
            Language language = Languages.getLanguageForShortCode((String)languageShortCode);
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguageForShortCode(languageShortCode)");
            Language language2 = language;
            Language motherTongue = ((CharSequence)motherTongueShortCode).length() > 0 ? Languages.getLanguageForShortCode((String)motherTongueShortCode) : null;
            UserConfig userConfig = new UserConfig(CollectionsKt.toList((Iterable)dictionary));
            this.languageTool = new JLanguageTool(language2, motherTongue, this.resultCache, userConfig);
        } else {
            Object[] objectArray = new Object[]{languageShortCode};
            Logging.INSTANCE.getLOGGER().severe(I18n.INSTANCE.format("notARecognizedLanguage", objectArray));
            this.languageTool = null;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.languageTool != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected List<LanguageToolRuleMatch> checkInternal(@NotNull AnnotatedTextFragment annotatedTextFragment) {
        List list;
        Intrinsics.checkNotNullParameter((Object)annotatedTextFragment, (String)"annotatedTextFragment");
        JLanguageTool languageTool = this.languageTool;
        if (languageTool == null) {
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("skippingTextCheckAsLanguageToolHasNotBeenInitialized", new Object[0]));
            return CollectionsKt.emptyList();
        }
        this.logResultCache();
        RuleMatchListener ruleMatchListener = null;
        JLanguageTool.Level ruleLevel = annotatedTextFragment.getCodeFragment().getSettings().getEnablePickyRules() ? JLanguageTool.Level.PICKY : JLanguageTool.Level.DEFAULT;
        annotatedTextFragment.getDocument().raiseExceptionIfCanceled();
        languageTool.setCheckCancelledCallback(() -> LanguageToolJavaInterface.checkInternal$lambda$0(annotatedTextFragment));
        try {
            List list2;
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            PrintStream stdout = printStream;
            System.setOut(new PrintStream(new OutputStream(){

                public void write(int b) {
                }
            }, false, "utf-8"));
            try {
                list2 = languageTool.check(annotatedTextFragment.getAnnotatedText(), true, JLanguageTool.ParagraphHandling.NORMAL, ruleMatchListener, JLanguageTool.Mode.ALL, ruleLevel);
            }
            finally {
                System.setOut(stdout);
            }
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"{\n      // workaround bu\u2026Out(stdout)\n      }\n    }");
        }
        catch (IOException e) {
            Tools.INSTANCE.rethrowCancellationException(e);
            Logging.INSTANCE.getLOGGER().severe(I18n.INSTANCE.format("languageToolFailed", e, new Object[0]));
            return CollectionsKt.emptyList();
        }
        List matches2 = list;
        annotatedTextFragment.getDocument().raiseExceptionIfCanceled();
        ArrayList<LanguageToolRuleMatch> result = new ArrayList<LanguageToolRuleMatch>();
        for (RuleMatch match : matches2) {
            result.add(LanguageToolRuleMatch.Companion.fromLanguageTool(match, annotatedTextFragment));
        }
        return result;
    }

    private final void logResultCache() {
        if (Logging.INSTANCE.getLOGGER().isLoggable(Level.FINER)) {
            Logging.INSTANCE.getLOGGER().finer("matchesCache.size() = " + this.resultCache.getMatchesCache().size());
            Logging.INSTANCE.getLOGGER().finer("remoteMatchesCache.size() = " + this.resultCache.getRemoteMatchesCache().size());
            Logging.INSTANCE.getLOGGER().finer("sentenceCache.size() = " + this.resultCache.getSentenceCache().size());
            if (Logging.INSTANCE.getLOGGER().isLoggable(Level.FINEST)) {
                Logging.INSTANCE.getLOGGER().finest("matchesCache = " + Companion.mapToString(this.resultCache.getMatchesCache().asMap()));
                Logging.INSTANCE.getLOGGER().finest("remoteMatchesCache = " + Companion.mapToString(this.resultCache.getRemoteMatchesCache().asMap()));
                Logging.INSTANCE.getLOGGER().finest("sentenceCache = " + Companion.mapToString(this.resultCache.getSentenceCache().asMap()));
            }
        }
    }

    @Override
    public void activateDefaultFalseFriendRules() {
        JLanguageTool jLanguageTool = this.languageTool;
        if (jLanguageTool == null) {
            return;
        }
        JLanguageTool languageTool = jLanguageTool;
        String falseFriendRulePath = JLanguageTool.getDataBroker().getRulesDir() + "/false-friends.xml";
        Exception exception = null;
        try {
            List list = languageTool.loadFalseFriendRules(falseFriendRulePath);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"languageTool.loadFalseFr\u2026ules(falseFriendRulePath)");
            List falseFriendRules = list;
            for (Rule rule : falseFriendRules) {
                languageTool.addRule(rule);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        catch (ParserConfigurationException e) {
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        if (exception != null) {
            Object[] objectArray = new Object[]{falseFriendRulePath};
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotLoadFalseFriendRules", exception, objectArray));
        }
    }

    @Override
    public void activateLanguageModelRules(@NotNull String languageModelRulesDirectory) {
        Intrinsics.checkNotNullParameter((Object)languageModelRulesDirectory, (String)"languageModelRulesDirectory");
        JLanguageTool jLanguageTool = this.languageTool;
        if (jLanguageTool == null) {
            return;
        }
        JLanguageTool languageTool = jLanguageTool;
        try {
            languageTool.activateLanguageModelRules(new File(languageModelRulesDirectory));
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{languageModelRulesDirectory};
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotLoadLanguageModel", e, objectArray));
        }
    }

    @Override
    public void enableRules(@NotNull Set<String> ruleIds) {
        Intrinsics.checkNotNullParameter(ruleIds, (String)"ruleIds");
        JLanguageTool jLanguageTool = this.languageTool;
        if (jLanguageTool == null) {
            return;
        }
        JLanguageTool languageTool = jLanguageTool;
        for (String ruleId : ruleIds) {
            languageTool.enableRule(ruleId);
        }
    }

    @Override
    public void enableEasterEgg() {
        JLanguageTool jLanguageTool = this.languageTool;
        if (jLanguageTool == null) {
            return;
        }
        JLanguageTool languageTool = jLanguageTool;
        languageTool.addRule(new Rule(){

            @NotNull
            public String getId() {
                return "bspline";
            }

            @NotNull
            public String getDescription() {
                return "Unknown basis function";
            }

            @NotNull
            public RuleMatch[] match(@NotNull AnalyzedSentence sentence) {
                Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
                ArrayList<RuleMatch> matches2 = new ArrayList<RuleMatch>();
                AnalyzedTokenReadings[] analyzedTokenReadingsArray = sentence.getTokens();
                Intrinsics.checkNotNullExpressionValue((Object)analyzedTokenReadingsArray, (String)"sentence.tokens");
                AnalyzedTokenReadings[] analyzedTokenReadingsArray2 = analyzedTokenReadingsArray;
                int n = analyzedTokenReadingsArray2.length;
                for (int i = 0; i < n; ++i) {
                    AnalyzedTokenReadings token;
                    Intrinsics.checkNotNullExpressionValue((Object)analyzedTokenReadingsArray2[i], (String)"sentence.tokens");
                    if (!StringsKt.equals((String)token.getToken(), (String)"hat", (boolean)true)) continue;
                    matches2.add(new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), "Unknown basis function. Did you mean <suggestion>B-spline</suggestion>?"));
                }
                Collection $this$toTypedArray$iv = matches2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new RuleMatch[0]);
            }
        });
        languageTool.addRule(new Rule(){

            @NotNull
            public String getId() {
                return "ungendered";
            }

            @NotNull
            public String getDescription() {
                return "Ungendered variant";
            }

            @NotNull
            public RuleMatch[] match(@NotNull AnalyzedSentence sentence) {
                Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
                ArrayList<RuleMatch> matches2 = new ArrayList<RuleMatch>();
                AnalyzedTokenReadings[] analyzedTokenReadingsArray = sentence.getTokens();
                Intrinsics.checkNotNullExpressionValue((Object)analyzedTokenReadingsArray, (String)"sentence.tokens");
                AnalyzedTokenReadings[] analyzedTokenReadingsArray2 = analyzedTokenReadingsArray;
                int n = analyzedTokenReadingsArray2.length;
                for (int i = 0; i < n; ++i) {
                    String tokenString;
                    AnalyzedTokenReadings token;
                    Intrinsics.checkNotNullExpressionValue((Object)analyzedTokenReadingsArray2[i], (String)"sentence.tokens");
                    Intrinsics.checkNotNullExpressionValue((Object)token.getToken(), (String)"token.token");
                    if (tokenString.length() < 2) continue;
                    String string = tokenString.substring(tokenString.length() - 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    if (!StringsKt.equals((String)string, (String)"er", (boolean)true)) continue;
                    matches2.add(new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), "Ungendered variant detected. Did you mean <suggestion>" + tokenString + "*in</suggestion>?"));
                }
                Collection $this$toTypedArray$iv = matches2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new RuleMatch[0]);
            }
        });
    }

    private static final boolean checkInternal$lambda$0(AnnotatedTextFragment $annotatedTextFragment) {
        Intrinsics.checkNotNullParameter((Object)$annotatedTextFragment, (String)"$annotatedTextFragment");
        $annotatedTextFragment.getDocument().raiseExceptionIfCanceled();
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/bsplines/ltexls/languagetool/LanguageToolJavaInterface$Companion;", "", "()V", "RESULT_CACHE_EXPIRE_AFTER_MINUTES", "", "appendObjectToBuilder", "", "obj", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mapToString", "", "map", "", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String mapToString(@Nullable Map<?, ?> map) {
            if (map == null) {
                return "null";
            }
            StringBuilder builder = new StringBuilder("{");
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (builder.length() > 1) {
                    builder.append(", ");
                }
                this.appendObjectToBuilder(key, builder);
                builder.append(": ");
                this.appendObjectToBuilder(value, builder);
            }
            builder.append("}");
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        private final void appendObjectToBuilder(Object obj, StringBuilder builder) {
            if (obj != null) {
                builder.append("\"");
                builder.append(StringEscapeUtils.escapeJava((String)obj.toString()));
                builder.append("\"");
            } else {
                builder.append("null");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

