/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.markup.TextPart;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "", "annotatedText", "Lorg/languagetool/markup/AnnotatedText;", "codeFragment", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "document", "Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "(Lorg/languagetool/markup/AnnotatedText;Lorg/bsplines/ltexls/parsing/CodeFragment;Lorg/bsplines/ltexls/server/LtexTextDocumentItem;)V", "getAnnotatedText", "()Lorg/languagetool/markup/AnnotatedText;", "getCodeFragment", "()Lorg/bsplines/ltexls/parsing/CodeFragment;", "getDocument", "()Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "inverseAnnotatedText", "plainText", "", "getSubstringOfPlainText", "fromPos", "", "toPos", "Companion", "ltexls"})
public final class AnnotatedTextFragment {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AnnotatedText annotatedText;
    @NotNull
    private final CodeFragment codeFragment;
    @NotNull
    private final LtexTextDocumentItem document;
    @Nullable
    private String plainText;
    @Nullable
    private AnnotatedText inverseAnnotatedText;
    @NotNull
    private static final Field ANNOTATED_TEXT_MAPPING_FIELD;
    @NotNull
    private static final Method MAPPING_VALUE_GET_TOTAL_POSITION_METHOD;

    public AnnotatedTextFragment(@NotNull AnnotatedText annotatedText, @NotNull CodeFragment codeFragment, @NotNull LtexTextDocumentItem document) {
        Intrinsics.checkNotNullParameter((Object)annotatedText, (String)"annotatedText");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)((Object)document), (String)"document");
        this.annotatedText = annotatedText;
        this.codeFragment = codeFragment;
        this.document = document;
    }

    @NotNull
    public final AnnotatedText getAnnotatedText() {
        return this.annotatedText;
    }

    @NotNull
    public final CodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final LtexTextDocumentItem getDocument() {
        return this.document;
    }

    @NotNull
    public final String getSubstringOfPlainText(int fromPos, int toPos) {
        String string;
        int plainTextToPos;
        AnnotatedText inverseAnnotatedText;
        int plainTextFromPos;
        String string2 = this.plainText;
        if (string2 == null) {
            String plainText;
            AnnotatedTextFragment $this$getSubstringOfPlainText_u24lambda_u240 = this;
            boolean bl = false;
            $this$getSubstringOfPlainText_u24lambda_u240.plainText = plainText = $this$getSubstringOfPlainText_u24lambda_u240.annotatedText.getPlainText();
            String string3 = plainText;
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"run {\n      val plainTex\u2026ext\n      plainText\n    }");
        }
        String plainText = string2;
        AnnotatedText annotatedText = this.inverseAnnotatedText;
        if (annotatedText == null) {
            AnnotatedText inverseAnnotatedText2;
            AnnotatedTextFragment $this$getSubstringOfPlainText_u24lambda_u241 = this;
            boolean bl = false;
            $this$getSubstringOfPlainText_u24lambda_u241.inverseAnnotatedText = inverseAnnotatedText2 = Companion.invertAnnotatedText($this$getSubstringOfPlainText_u24lambda_u241.annotatedText);
            annotatedText = inverseAnnotatedText2;
        }
        if ((plainTextFromPos = Companion.getOriginalTextPosition(inverseAnnotatedText = annotatedText, fromPos, false)) <= (plainTextToPos = Companion.getOriginalTextPosition(inverseAnnotatedText, toPos, true))) {
            String string4 = plainText.substring(plainTextFromPos, plainTextToPos);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            Object[] objectArray = new Object[]{fromPos, toPos, plainTextFromPos, plainTextToPos};
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotDeterminePlainTextPositions", objectArray));
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Companion $this$ANNOTATED_TEXT_MAPPING_FIELD_u24lambda_u242 = Companion = new Companion(null);
        boolean bl = false;
        Field field = AnnotatedText.class.getDeclaredField("mapping");
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"AnnotatedText::class.jav\u2026tDeclaredField(\"mapping\")");
        Field annotatedTextMappingField = field;
        annotatedTextMappingField.setAccessible(true);
        ANNOTATED_TEXT_MAPPING_FIELD = annotatedTextMappingField;
        Companion $this$MAPPING_VALUE_GET_TOTAL_POSITION_METHOD_u24lambda_u243 = Companion;
        boolean bl2 = false;
        Class<?> clazz = Class.forName("org.languagetool.markup.MappingValue");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(\"org.languagetool.markup.MappingValue\")");
        Class<?> mappingValueClass = clazz;
        Method method = mappingValueClass.getDeclaredMethod("getTotalPosition", new Class[0]);
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"mappingValueClass.getDec\u2026ethod(\"getTotalPosition\")");
        Method mappingValueGetTotalPositionMethod = method;
        mappingValueGetTotalPositionMethod.setAccessible(true);
        MAPPING_VALUE_GET_TOTAL_POSITION_METHOD = var3_3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ2\u0010\u000f\u001a\u00020\b2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00120\u00112\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment$Companion;", "", "()V", "ANNOTATED_TEXT_MAPPING_FIELD", "Ljava/lang/reflect/Field;", "MAPPING_VALUE_GET_TOTAL_POSITION_METHOD", "Ljava/lang/reflect/Method;", "getOriginalTextPosition", "", "annotatedText", "Lorg/languagetool/markup/AnnotatedText;", "plainTextPos", "isToPos", "", "invertAnnotatedText", "searchPlainTextPos", "mappingList", "", "Lkotlin/Pair;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public final int getOriginalTextPosition(@NotNull AnnotatedText annotatedText, int plainTextPos, boolean isToPos) {
            Intrinsics.checkNotNullParameter((Object)annotatedText, (String)"annotatedText");
            Object object = ANNOTATED_TEXT_MAPPING_FIELD.get(annotatedText);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.Int, *>");
            Map mapping = (Map)object;
            Companion $this$getOriginalTextPosition_u24lambda_u240 = this;
            boolean bl = false;
            ArrayList<Pair> mappingList = new ArrayList<Pair>();
            mappingList.add(new Pair((Object)0, (Object)0));
            for (Map.Entry entry : mapping.entrySet()) {
                int key = ((Number)entry.getKey()).intValue();
                Object value = entry.getValue();
                Object object2 = MAPPING_VALUE_GET_TOTAL_POSITION_METHOD.invoke(value, new Object[0]);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                int totalPosition = (Integer)object2;
                if (key == plainTextPos) {
                    return totalPosition;
                }
                mappingList.add(new Pair((Object)key, (Object)totalPosition));
            }
            List mappingList2 = mappingList;
            int i = this.searchPlainTextPos(mappingList2, plainTextPos, isToPos);
            Pair lowerNeighbor = (Pair)mappingList2.get(i - 1);
            Pair upperNeighbor = (Pair)mappingList2.get(i);
            if (!isToPos) {
                if (((Number)lowerNeighbor.getFirst()).intValue() == plainTextPos) {
                    return ((Number)lowerNeighbor.getSecond()).intValue();
                }
                if (((Number)upperNeighbor.getFirst()).intValue() == plainTextPos) {
                    return ((Number)upperNeighbor.getSecond()).intValue();
                }
            } else {
                if (((Number)upperNeighbor.getFirst()).intValue() == plainTextPos) {
                    return ((Number)upperNeighbor.getSecond()).intValue();
                }
                if (((Number)lowerNeighbor.getFirst()).intValue() == plainTextPos) {
                    return ((Number)lowerNeighbor.getSecond()).intValue();
                }
            }
            float t = (float)(plainTextPos - ((Number)lowerNeighbor.getFirst()).intValue()) / (float)(((Number)upperNeighbor.getFirst()).intValue() - ((Number)lowerNeighbor.getFirst()).intValue());
            return MathKt.roundToInt((float)((1.0f - t) * ((Number)lowerNeighbor.getSecond()).floatValue() + t * ((Number)upperNeighbor.getSecond()).floatValue()));
        }

        private final int searchPlainTextPos(List<Pair<Integer, Integer>> mappingList, int plainTextPos, boolean isToPos) {
            Comparator comparator = Companion::searchPlainTextPos$lambda$1;
            CollectionsKt.sortWith(mappingList, (Comparator)comparator);
            Pair pairToFind = new Pair((Object)plainTextPos, (Object)Integer.MAX_VALUE);
            int i = -CollectionsKt.binarySearch$default(mappingList, (Object)pairToFind, (Comparator)comparator, (int)0, (int)0, (int)12, null) - 1;
            if (i <= 0) {
                i = 1;
            }
            if (i >= mappingList.size()) {
                i = mappingList.size() - 1;
            }
            if (isToPos) {
                while (i < mappingList.size() - 1 && ((Number)mappingList.get(i + 1).getFirst()).intValue() <= plainTextPos) {
                    ++i;
                }
            } else {
                while (i > 1 && ((Number)mappingList.get(i - 1).getFirst()).intValue() >= plainTextPos) {
                    --i;
                }
            }
            return i;
        }

        @NotNull
        public final AnnotatedText invertAnnotatedText(@NotNull AnnotatedText annotatedText) {
            Intrinsics.checkNotNullParameter((Object)annotatedText, (String)"annotatedText");
            AnnotatedTextBuilder inverseAnnotatedTextBuilder = new AnnotatedTextBuilder();
            List list = annotatedText.getParts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotatedText.parts");
            List textParts = list;
            block5: for (int i = 0; i < textParts.size(); ++i) {
                TextPart textPart = (TextPart)textParts.get(i);
                TextPart.Type type = textPart.getType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        inverseAnnotatedTextBuilder.addText(textPart.getPart());
                        continue block5;
                    }
                    case 2: {
                        inverseAnnotatedTextBuilder.addMarkup(textPart.getPart());
                        continue block5;
                    }
                    case 3: {
                        String string;
                        if (i < textParts.size() - 1 && ((TextPart)textParts.get(i + 1)).getType() == TextPart.Type.FAKE_CONTENT) {
                            String string2 = ((TextPart)textParts.get(++i)).getPart();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n              i++\n    \u2026rts[i].part\n            }");
                            string = string2;
                        } else {
                            string = "";
                        }
                        String markup = string;
                        inverseAnnotatedTextBuilder.addMarkup(markup, textPart.getPart());
                    }
                }
            }
            AnnotatedText annotatedText2 = inverseAnnotatedTextBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)annotatedText2, (String)"inverseAnnotatedTextBuilder.build()");
            return annotatedText2;
        }

        private static final int searchPlainTextPos$lambda$1(Pair a, Pair b) {
            return ((Number)a.getFirst()).intValue() < ((Number)b.getFirst()).intValue() ? -1 : (((Number)a.getFirst()).intValue() > ((Number)b.getFirst()).intValue() ? 1 : (((Number)a.getSecond()).intValue() < ((Number)b.getSecond()).intValue() ? -1 : (((Number)a.getSecond()).intValue() > ((Number)b.getSecond()).intValue() ? 1 : 0)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TextPart.Type.values().length];
                try {
                    nArray[TextPart.Type.TEXT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TextPart.Type.FAKE_CONTENT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TextPart.Type.MARKUP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

