/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.latex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.bsplines.ltexls.parsing.DummyGenerator;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\b\u0016\u0018\u0000 &2\u00020\u0001:\u0003$%&B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u001c\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001eJ\u0016\u0010!\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001eJ4\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001e2\u001a\u0010\"\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d\u0018\u00010#H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0013\"\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;", "", "commandPrototype", "", "action", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature$Action;", "dummyGenerator", "Lorg/bsplines/ltexls/parsing/DummyGenerator;", "escapeCommandPrefix", "", "(Ljava/lang/String;Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature$Action;Lorg/bsplines/ltexls/parsing/DummyGenerator;Z)V", "getAction", "()Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature$Action;", "argumentTypes", "", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature$ArgumentType;", "getArgumentTypes", "()Ljava/util/List;", "getCommandPrototype", "()Ljava/lang/String;", "commandRegex", "Lkotlin/text/Regex;", "getDummyGenerator", "()Lorg/bsplines/ltexls/parsing/DummyGenerator;", "prefix", "getPrefix", "setPrefix", "(Ljava/lang/String;)V", "matchArgumentsFromPosition", "Lkotlin/Pair;", "", "code", "fromPos", "matchFromPosition", "arguments", "", "Action", "ArgumentType", "Companion", "ltexls"})
public class LatexCommandSignature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String commandPrototype;
    @NotNull
    private final Action action;
    @NotNull
    private final DummyGenerator dummyGenerator;
    @NotNull
    private String prefix;
    @NotNull
    private final List<ArgumentType> argumentTypes;
    @NotNull
    private Regex commandRegex;
    @NotNull
    private static final Regex GENERIC_COMMAND_REGEX = new Regex("^(.+?)(\\{}|\\[]|\\(\\))*$");
    @NotNull
    private static final Regex ARGUMENT_REGEX = new Regex("^(?:(?<brace>\\{})|(?<bracket>\\[])|(?<parenthesis>\\(\\)))");
    @NotNull
    private static final Regex COMMENT_REGEX = new Regex("^%.*?($|(\n[ \n\r\t]*))");

    public LatexCommandSignature(@NotNull String commandPrototype, @NotNull Action action, @NotNull DummyGenerator dummyGenerator, boolean escapeCommandPrefix) {
        MatchGroup commandMatchGroup;
        Intrinsics.checkNotNullParameter((Object)commandPrototype, (String)"commandPrototype");
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Intrinsics.checkNotNullParameter((Object)dummyGenerator, (String)"dummyGenerator");
        this.commandPrototype = commandPrototype;
        this.action = action;
        this.dummyGenerator = dummyGenerator;
        this.prefix = "";
        MatchResult matchResult = Regex.find$default((Regex)GENERIC_COMMAND_REGEX, (CharSequence)this.commandPrototype, (int)0, (int)2, null);
        MatchGroup matchGroup = matchResult != null && (matchResult = matchResult.getGroups()) != null ? matchResult.get(1) : (commandMatchGroup = null);
        if (commandMatchGroup != null) {
            ArrayList<ArgumentType> argumentTypes;
            block3: {
                boolean bl;
                this.prefix = commandMatchGroup.getValue();
                argumentTypes = new ArrayList<ArgumentType>();
                int pos = commandMatchGroup.getRange().getLast() + 1;
                do {
                    MatchResult argumentMatchResult;
                    String string = this.commandPrototype.substring(pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    if (Regex.find$default((Regex)ARGUMENT_REGEX, (CharSequence)string, (int)0, (int)2, null) == null) break block3;
                    ArgumentType argumentType = RegexExtensionsJDK8Kt.get((MatchGroupCollection)argumentMatchResult.getGroups(), (String)"brace") != null ? ArgumentType.Brace : (RegexExtensionsJDK8Kt.get((MatchGroupCollection)argumentMatchResult.getGroups(), (String)"bracket") != null ? ArgumentType.Bracket : (RegexExtensionsJDK8Kt.get((MatchGroupCollection)argumentMatchResult.getGroups(), (String)"parenthesis") != null ? ArgumentType.Parenthesis : ArgumentType.Brace));
                    argumentTypes.add(argumentType);
                    pos += argumentMatchResult.getValue().length();
                    boolean bl2 = bl = ((CharSequence)argumentMatchResult.getValue()).length() > 0;
                } while (!_Assertions.ENABLED || bl);
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.argumentTypes = argumentTypes;
            String regexString = "^" + (escapeCommandPrefix ? Regex.Companion.escape(this.prefix) : this.prefix);
            this.commandRegex = new Regex(regexString);
        } else {
            Object[] objectArray = new Object[]{this.commandPrototype};
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("invalidCommandPrototype", objectArray));
            this.argumentTypes = new ArrayList();
            this.commandRegex = new Regex(" ^$");
        }
    }

    public /* synthetic */ LatexCommandSignature(String string, Action action, DummyGenerator dummyGenerator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            action = Action.Ignore;
        }
        if ((n & 4) != 0) {
            dummyGenerator = DummyGenerator.Companion.getInstance$default(DummyGenerator.Companion, false, false, 3, null);
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string, action, dummyGenerator, bl);
    }

    @NotNull
    public final String getCommandPrototype() {
        return this.commandPrototype;
    }

    @NotNull
    public final Action getAction() {
        return this.action;
    }

    @NotNull
    public final DummyGenerator getDummyGenerator() {
        return this.dummyGenerator;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.prefix = string;
    }

    @NotNull
    public final List<ArgumentType> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Nullable
    public final List<Pair<Integer, Integer>> matchArgumentsFromPosition(@NotNull String code, int fromPos) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        ArrayList arguments = new ArrayList();
        int toPos = this.matchFromPosition(code, fromPos, arguments);
        return toPos > -1 ? (List)arguments : null;
    }

    @NotNull
    public final String matchFromPosition(@NotNull String code, int fromPos) {
        String string;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        int toPos = this.matchFromPosition(code, fromPos, null);
        if (toPos > -1) {
            String string2 = code.substring(fromPos, toPos);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = "";
        }
        return string;
    }

    private final int matchFromPosition(String code, int fromPos, List<Pair<Integer, Integer>> arguments) {
        int pos = fromPos;
        String match = LatexCommandSignature.Companion.matchPatternFromPosition(code, pos, this.commandRegex);
        if (((CharSequence)match).length() == 0) {
            return -1;
        }
        pos += match.length();
        for (ArgumentType argumentType : this.argumentTypes) {
            match = LatexCommandSignature.Companion.matchPatternFromPosition(code, pos, LatexCommandSignature.COMMENT_REGEX);
            if (((CharSequence)(match = Companion.matchArgumentFromPosition(code, pos += match.length(), argumentType))).length() == 0) {
                return -1;
            }
            List<Pair<Integer, Integer>> list = arguments;
            if (list != null) {
                list.add((Pair<Integer, Integer>)new Pair((Object)pos, (Object)(pos + match.length())));
            }
            pos += match.length();
        }
        return pos;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature$Action;", "", "(Ljava/lang/String;I)V", "Default", "Ignore", "Dummy", "ltexls"})
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action Default = new Action();
        public static final /* enum */ Action Ignore = new Action();
        public static final /* enum */ Action Dummy = new Action();
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        static {
            $VALUES = actionArray = new Action[]{Action.Default, Action.Ignore, Action.Dummy};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature$ArgumentType;", "", "(Ljava/lang/String;I)V", "Brace", "Bracket", "Parenthesis", "ltexls"})
    public static final class ArgumentType
    extends Enum<ArgumentType> {
        public static final /* enum */ ArgumentType Brace = new ArgumentType();
        public static final /* enum */ ArgumentType Bracket = new ArgumentType();
        public static final /* enum */ ArgumentType Parenthesis = new ArgumentType();
        private static final /* synthetic */ ArgumentType[] $VALUES;

        public static ArgumentType[] values() {
            return (ArgumentType[])$VALUES.clone();
        }

        public static ArgumentType valueOf(String value) {
            return Enum.valueOf(ArgumentType.class, value);
        }

        static {
            $VALUES = argumentTypeArray = new ArgumentType[]{ArgumentType.Brace, ArgumentType.Bracket, ArgumentType.Parenthesis};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature$Companion;", "", "()V", "ARGUMENT_REGEX", "Lkotlin/text/Regex;", "COMMENT_REGEX", "GENERIC_COMMAND_REGEX", "matchArgumentFromPosition", "", "code", "fromPos", "", "argumentType", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature$ArgumentType;", "matchPatternFromPosition", "regex", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        private final String matchPatternFromPosition(String code, int fromPos, Regex regex) {
            if (fromPos >= code.length()) {
                return "";
            }
            String string = code.substring(fromPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
            Object object = matchResult;
            if (object == null || (object = object.getValue()) == null) {
                object = "";
            }
            return object;
        }

        @NotNull
        public final String matchArgumentFromPosition(@NotNull String code, int fromPos, @NotNull ArgumentType argumentType) {
            char c;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)((Object)argumentType), (String)"argumentType");
            if (fromPos >= code.length()) {
                return "";
            }
            int pos = fromPos;
            switch (WhenMappings.$EnumSwitchMapping$0[argumentType.ordinal()]) {
                case 1: {
                    c = '{';
                    break;
                }
                case 2: {
                    c = '[';
                    break;
                }
                case 3: {
                    c = '(';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            char openChar = c;
            if (code.charAt(pos) != openChar) {
                return "";
            }
            ++pos;
            ArrayDeque argumentTypeStack = new ArrayDeque();
            argumentTypeStack.addLast((Object)argumentType);
            while (pos < code.length()) {
                char curChar = code.charAt(pos);
                if (curChar == '\\') {
                    if (pos + 1 < code.length()) {
                        ++pos;
                    }
                } else if (curChar == '{') {
                    argumentTypeStack.addLast((Object)ArgumentType.Brace);
                } else if (curChar == '[') {
                    argumentTypeStack.addLast((Object)ArgumentType.Bracket);
                } else if (curChar == '}' ? true : curChar == ']') {
                    char c2 = curChar;
                    ArgumentType curArgumentType = c2 == '}' ? ArgumentType.Brace : (c2 == ']' ? ArgumentType.Bracket : ArgumentType.Brace);
                    if (!((Collection)argumentTypeStack).isEmpty() && argumentTypeStack.last() != curArgumentType) {
                        return "";
                    }
                    if (argumentTypeStack.size() == 1) {
                        String string = code.substring(fromPos, pos + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        return string;
                    }
                    argumentTypeStack.removeLastOrNull();
                } else if (curChar == ')' && argumentTypeStack.size() == 1 && argumentTypeStack.last() == ArgumentType.Parenthesis) {
                    String string = code.substring(fromPos, pos + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    return string;
                }
                ++pos;
            }
            return "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ArgumentType.values().length];
                try {
                    nArray[ArgumentType.Brace.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArgumentType.Bracket.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArgumentType.Parenthesis.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

