/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.latex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.parsing.CodeFragmentizer;
import org.bsplines.ltexls.parsing.RegexCodeFragmentizer;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignature;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignatureMatch;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignatureMatcher;
import org.bsplines.ltexls.parsing.latex.LatexPackageOption;
import org.bsplines.ltexls.parsing.latex.LatexPackageOptionsParser;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexFragmentizer;", "Lorg/bsplines/ltexls/parsing/CodeFragmentizer;", "codeLanguageId", "", "(Ljava/lang/String;)V", "commentFragmentizer", "Lorg/bsplines/ltexls/parsing/RegexCodeFragmentizer;", "fragmentize", "", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "code", "originalSettings", "Lorg/bsplines/ltexls/settings/Settings;", "fragmentizeBabelEnvironments", "fragments", "fragmentizeBabelInlineCommands", "fragmentizeBabelSwitchCommands", "fragmentizeBabelUsePackageCommands", "fragmentizeExtraCommands", "Companion", "ltexls"})
public final class LatexFragmentizer
extends CodeFragmentizer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final RegexCodeFragmentizer commentFragmentizer;
    @NotNull
    private static final Regex COMMENT_REGEX;
    @NotNull
    private static final LatexCommandSignatureMatcher EXTRA_COMMAND_SIGNATURE_MATCHER;
    @NotNull
    private static final Regex LANGUAGE_TAG_REPLACEMENT_REGEX;
    @NotNull
    private static final Map<String, String> BABEL_LANGUAGE_MAP;
    @NotNull
    private static final LatexCommandSignature USE_PACKAGE_COMMAND_SIGNATURE;
    @NotNull
    private static final LatexCommandSignatureMatcher USE_PACKAGE_COMMAND_SIGNATURE_MATCHER;
    @NotNull
    private static final LatexCommandSignature BABEL_SWITCH_COMMAND_SIGNATURE;
    @NotNull
    private static final LatexCommandSignatureMatcher BABEL_SWITCH_COMMAND_SIGNATURE_MATCHER;
    @NotNull
    private static final HashMap<LatexCommandSignature, String> BABEL_INLINE_COMMAND_SIGNATURE_MAP;
    @NotNull
    private static final LatexCommandSignatureMatcher BABEL_INLINE_COMMAND_SIGNATURE_MATCHER;
    @NotNull
    private static final Map<LatexCommandSignature, String> BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MAP;
    @NotNull
    private static final LatexCommandSignatureMatcher BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MATCHER;

    public LatexFragmentizer(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        this.commentFragmentizer = new RegexCodeFragmentizer(codeLanguageId, COMMENT_REGEX);
    }

    @Override
    @NotNull
    public List<CodeFragment> fragmentize(@NotNull String code, @NotNull Settings originalSettings) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)originalSettings, (String)"originalSettings");
        List<CodeFragment> fragments = CollectionsKt.listOf((Object)new CodeFragment(this.getCodeLanguageId(), code, 0, originalSettings, null, 16, null));
        fragments = this.commentFragmentizer.fragmentize(fragments);
        fragments = this.fragmentizeBabelUsePackageCommands(fragments);
        fragments = this.fragmentizeBabelSwitchCommands(fragments);
        fragments = this.fragmentizeBabelInlineCommands(fragments);
        fragments = this.fragmentizeBabelEnvironments(fragments);
        fragments = this.fragmentizeExtraCommands(fragments);
        return fragments;
    }

    private final List<CodeFragment> fragmentizeBabelUsePackageCommands(List<CodeFragment> fragments) {
        ArrayList<CodeFragment> newFragments = new ArrayList<CodeFragment>();
        for (CodeFragment codeFragment : fragments) {
            String oldFragmentCode = codeFragment.component2();
            int fromPos = codeFragment.component3();
            Settings oldFragmentSettings = codeFragment.component4();
            USE_PACKAGE_COMMAND_SIGNATURE_MATCHER.startMatching(oldFragmentCode, LatexFragmentizer.Companion.getIgnoreCommandPrototypes(oldFragmentSettings));
            int prevFromPos = 0;
            Settings prevSettings = oldFragmentSettings;
            while (USE_PACKAGE_COMMAND_SIGNATURE_MATCHER.findNextMatch() != null) {
                LatexCommandSignatureMatch match;
                String packageName = match.getArgumentContents(1);
                if (!Intrinsics.areEqual((Object)packageName, (Object)"babel")) continue;
                List<LatexPackageOption> packageOptions = LatexPackageOptionsParser.INSTANCE.parse(match.getArgumentContents(0));
                String babelLanguage = null;
                for (LatexPackageOption latexPackageOption : packageOptions) {
                    if (BABEL_LANGUAGE_MAP.containsKey(latexPackageOption.getKeyInfo().getPlainText())) {
                        babelLanguage = latexPackageOption.getKeyInfo().getPlainText();
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)latexPackageOption.getKeyInfo().getPlainText(), (Object)"main") || !BABEL_LANGUAGE_MAP.containsKey(latexPackageOption.getValueInfo().getPlainText())) continue;
                    babelLanguage = latexPackageOption.getValueInfo().getPlainText();
                    break;
                }
                if (babelLanguage == null) continue;
                String languageShortCode = BABEL_LANGUAGE_MAP.get(babelLanguage);
                if (languageShortCode == null) {
                    Object[] objectArray = new Object[]{babelLanguage};
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("unknownBabelLanguage", objectArray));
                    continue;
                }
                int n = match.getFromPos();
                Settings nextSettings = Settings.copy$default(prevSettings, null, languageShortCode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFD, null);
                String string = this.getCodeLanguageId();
                String string2 = oldFragmentCode.substring(prevFromPos, n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                newFragments.add(new CodeFragment(string, string2, fromPos + prevFromPos, prevSettings, null, 16, null));
                prevFromPos = n;
                prevSettings = nextSettings;
            }
            String string = this.getCodeLanguageId();
            String string3 = oldFragmentCode.substring(prevFromPos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            newFragments.add(new CodeFragment(string, string3, fromPos + prevFromPos, prevSettings, null, 16, null));
        }
        return newFragments;
    }

    private final List<CodeFragment> fragmentizeBabelSwitchCommands(List<CodeFragment> fragments) {
        ArrayList<CodeFragment> newFragments = new ArrayList<CodeFragment>();
        for (CodeFragment codeFragment : fragments) {
            String oldFragmentCode = codeFragment.component2();
            int fromPos = codeFragment.component3();
            Settings oldFragmentSettings = codeFragment.component4();
            BABEL_SWITCH_COMMAND_SIGNATURE_MATCHER.startMatching(oldFragmentCode, LatexFragmentizer.Companion.getIgnoreCommandPrototypes(oldFragmentSettings));
            int prevFromPos = 0;
            Settings prevSettings = oldFragmentSettings;
            while (BABEL_SWITCH_COMMAND_SIGNATURE_MATCHER.findNextMatch() != null) {
                LatexCommandSignatureMatch match;
                String babelLanguage = match.getArgumentContents(0);
                String languageShortCode = BABEL_LANGUAGE_MAP.get(babelLanguage);
                if (languageShortCode == null) {
                    Object[] objectArray = new Object[]{babelLanguage};
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("unknownBabelLanguage", objectArray));
                    continue;
                }
                int nextFromPos = match.getFromPos();
                Settings nextSettings = Settings.copy$default(prevSettings, null, languageShortCode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFD, null);
                String string = this.getCodeLanguageId();
                String string2 = oldFragmentCode.substring(prevFromPos, nextFromPos);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                newFragments.add(new CodeFragment(string, string2, fromPos + prevFromPos, prevSettings, null, 16, null));
                prevFromPos = nextFromPos;
                prevSettings = nextSettings;
            }
            String string = this.getCodeLanguageId();
            String string3 = oldFragmentCode.substring(prevFromPos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            newFragments.add(new CodeFragment(string, string3, fromPos + prevFromPos, prevSettings, null, 16, null));
        }
        return newFragments;
    }

    private final List<CodeFragment> fragmentizeBabelInlineCommands(List<CodeFragment> fragments) {
        ArrayList<CodeFragment> newFragments = new ArrayList<CodeFragment>();
        for (CodeFragment oldFragment : fragments) {
            String oldFragmentCode = oldFragment.getCode();
            Settings oldFragmentSettings = oldFragment.getSettings();
            BABEL_INLINE_COMMAND_SIGNATURE_MATCHER.startMatching(oldFragmentCode, LatexFragmentizer.Companion.getIgnoreCommandPrototypes(oldFragmentSettings));
            Settings curSettings = oldFragmentSettings;
            while (BABEL_INLINE_COMMAND_SIGNATURE_MATCHER.findNextMatch() != null) {
                Object[] commandPrototype;
                LatexCommandSignatureMatch match;
                String languageShortCode = BABEL_INLINE_COMMAND_SIGNATURE_MAP.get(match.getCommandSignature());
                String babelLanguage = "";
                if (languageShortCode == null) {
                    commandPrototype = match.getCommandSignature().getCommandPrototype();
                    Object[] objectArray = new Object[]{commandPrototype};
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("invalidBabelInlineCommand", objectArray));
                    continue;
                }
                if (((CharSequence)languageShortCode).length() == 0) {
                    babelLanguage = match.getArgumentContents(match.getArgumentsSize() - 2);
                    languageShortCode = BABEL_LANGUAGE_MAP.get(babelLanguage);
                }
                if (languageShortCode == null) {
                    commandPrototype = new Object[]{babelLanguage};
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("unknownBabelLanguage", commandPrototype));
                } else {
                    curSettings = Settings.copy$default(curSettings, null, languageShortCode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFD, null);
                }
                String contents = match.getArgumentContents(match.getArgumentsSize() - 1);
                int contentsFromPos = match.getArgumentContentsFromPos(match.getArgumentsSize() - 1);
                newFragments.add(new CodeFragment(this.getCodeLanguageId(), contents, oldFragment.getFromPos() + contentsFromPos, curSettings, null, 16, null));
            }
            newFragments.add(oldFragment);
        }
        return newFragments;
    }

    private final List<CodeFragment> fragmentizeBabelEnvironments(List<CodeFragment> fragments) {
        ArrayList<CodeFragment> newFragments = new ArrayList<CodeFragment>();
        for (CodeFragment oldFragment : fragments) {
            int stackSize;
            Settings prevSettings;
            String oldFragmentCode = oldFragment.getCode();
            Settings oldFragmentSettings = oldFragment.getSettings();
            BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MATCHER.startMatching(oldFragmentCode, LatexFragmentizer.Companion.getIgnoreCommandPrototypes(oldFragmentSettings));
            ArrayDeque settingsStack = new ArrayDeque();
            ArrayDeque fromPosStack = new ArrayDeque();
            settingsStack.addLast((Object)oldFragmentSettings);
            fromPosStack.addLast((Object)0);
            while (!((Collection)settingsStack).isEmpty() && BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MATCHER.findNextMatch() != null) {
                LatexCommandSignatureMatch match;
                String commandPrototype = match.getCommandSignature().getCommandPrototype();
                boolean isBegin = StringsKt.startsWith$default((String)commandPrototype, (String)"\\begin", (boolean)false, (int)2, null);
                if (isBegin) {
                    String languageShortCode = BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MAP.get(match.getCommandSignature());
                    String babelLanguage = "";
                    if (languageShortCode == null) {
                        Object[] objectArray = new Object[]{commandPrototype};
                        Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("invalidBabelEnvironment", objectArray));
                        continue;
                    }
                    if (((CharSequence)languageShortCode).length() == 0) {
                        babelLanguage = match.getArgumentContents(match.getArgumentsSize() - 1);
                        languageShortCode = BABEL_LANGUAGE_MAP.get(babelLanguage);
                    }
                    Settings newSettings = (Settings)settingsStack.last();
                    if (languageShortCode == null) {
                        Object[] objectArray = new Object[]{babelLanguage};
                        Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("unknownBabelLanguage", objectArray));
                    } else {
                        newSettings = Settings.copy$default(newSettings, null, languageShortCode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFD, null);
                    }
                    settingsStack.addLast((Object)newSettings);
                    fromPosStack.addLast((Object)match.getToPos());
                    continue;
                }
                if (settingsStack.size() <= 1) break;
                prevSettings = (Settings)settingsStack.removeLast();
                int prevFromPos = ((Number)fromPosStack.removeLast()).intValue();
                String string = this.getCodeLanguageId();
                String string2 = oldFragmentCode.substring(prevFromPos, match.getFromPos());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                newFragments.add(new CodeFragment(string, string2, oldFragment.getFromPos() + prevFromPos, prevSettings, null, 16, null));
            }
            if ((stackSize = settingsStack.size()) > 1) {
                int n = stackSize - 1;
                for (int i = 0; i < n; ++i) {
                    prevSettings = (Settings)settingsStack.removeLast();
                    int prevFromPos = ((Number)fromPosStack.removeLast()).intValue();
                    String string = this.getCodeLanguageId();
                    String string3 = oldFragmentCode.substring(prevFromPos);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    newFragments.add(new CodeFragment(string, string3, oldFragment.getFromPos() + prevFromPos, prevSettings, null, 16, null));
                }
            }
            newFragments.add(oldFragment);
        }
        return newFragments;
    }

    private final List<CodeFragment> fragmentizeExtraCommands(List<CodeFragment> fragments) {
        ArrayList<CodeFragment> newFragments = new ArrayList<CodeFragment>();
        for (CodeFragment oldFragment : fragments) {
            String oldFragmentCode = oldFragment.getCode();
            Settings oldFragmentSettings = oldFragment.getSettings();
            EXTRA_COMMAND_SIGNATURE_MATCHER.startMatching(oldFragmentCode, LatexFragmentizer.Companion.getIgnoreCommandPrototypes(oldFragmentSettings));
            while (EXTRA_COMMAND_SIGNATURE_MATCHER.findNextMatch() != null) {
                LatexCommandSignatureMatch match;
                String contents = match.getArgumentContents(match.getArgumentsSize() - 1);
                int contentsFromPos = match.getArgumentContentsFromPos(match.getArgumentsSize() - 1);
                newFragments.add(new CodeFragment(this.getCodeLanguageId(), contents, oldFragment.getFromPos() + contentsFromPos, oldFragmentSettings, null, 16, null));
            }
            newFragments.add(oldFragment);
        }
        return newFragments;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String value;
        Companion = new Companion(null);
        COMMENT_REGEX = new Regex("^[ \t]*%[ \t]*(?i)ltex(?-i):(.*?)$", RegexOption.MULTILINE);
        Object[] objectArray = new LatexCommandSignature[]{new LatexCommandSignature("\\footnote{}", null, null, false, 14, null), new LatexCommandSignature("\\footnote[]{}", null, null, false, 14, null), new LatexCommandSignature("\\todo{}", null, null, false, 14, null), new LatexCommandSignature("\\todo[]{}", null, null, false, 14, null)};
        EXTRA_COMMAND_SIGNATURE_MATCHER = new LatexCommandSignatureMatcher(CollectionsKt.listOf((Object[])objectArray), false, 2, null);
        LANGUAGE_TAG_REPLACEMENT_REGEX = new Regex("[^A-Za-z]+");
        Companion $this$BABEL_LANGUAGE_MAP_u24lambda_u240 = Companion;
        boolean bl = false;
        HashMap map = new HashMap();
        ((Map)map).put("ar", "ar");
        ((Map)map).put("ast", "ast-ES");
        ((Map)map).put("ast-ES", "ast-ES");
        ((Map)map).put("be", "be-BY");
        ((Map)map).put("be-BY", "be-BY");
        ((Map)map).put("br", "br-FR");
        ((Map)map).put("br-FR", "br-FR");
        ((Map)map).put("ca", "ca-ES");
        ((Map)map).put("ca-ES", "ca-ES");
        ((Map)map).put("ca-ES-valencia", "ca-ES-valencia");
        ((Map)map).put("da", "da-DK");
        ((Map)map).put("da-DK", "da-DK");
        ((Map)map).put("de", "de");
        ((Map)map).put("de-AT", "de-AT");
        ((Map)map).put("de-CH", "de-CH");
        ((Map)map).put("de-DE", "de-DE");
        ((Map)map).put("de-DE-x-simple-language", "de-DE-x-simple-language");
        ((Map)map).put("el", "el-GR");
        ((Map)map).put("el-GR", "el-GR");
        ((Map)map).put("en", "en");
        ((Map)map).put("en-AU", "en-AU");
        ((Map)map).put("en-CA", "en-CA");
        ((Map)map).put("en-GB", "en-GB");
        ((Map)map).put("en-NZ", "en-NZ");
        ((Map)map).put("en-US", "en-US");
        ((Map)map).put("en-ZA", "en-ZA");
        ((Map)map).put("eo", "eo");
        ((Map)map).put("es", "es");
        ((Map)map).put("fa", "fa");
        ((Map)map).put("fr", "fr");
        ((Map)map).put("ga", "ga-IE");
        ((Map)map).put("ga-IE", "ga-IE");
        ((Map)map).put("gl", "gl-ES");
        ((Map)map).put("gl-ES", "gl-ES");
        ((Map)map).put("ja", "ja-JP");
        ((Map)map).put("ja-JP", "ja-JP");
        ((Map)map).put("km", "km-KH");
        ((Map)map).put("km-KH", "km-KH");
        ((Map)map).put("nl", "nl");
        ((Map)map).put("pl", "pl-PL");
        ((Map)map).put("pl-PL", "pl-PL");
        ((Map)map).put("pt", "pt");
        ((Map)map).put("pt-AO", "pt-AO");
        ((Map)map).put("pt-BR", "pt-BR");
        ((Map)map).put("pt-MZ", "pt-MZ");
        ((Map)map).put("pt-PT", "pt-PT");
        ((Map)map).put("ro", "ro-RO");
        ((Map)map).put("ro-RO", "ro-RO");
        ((Map)map).put("ru", "ru-RU");
        ((Map)map).put("ru-RU", "ru-RU");
        ((Map)map).put("sk", "sk-SK");
        ((Map)map).put("sk-SK", "sk-SK");
        ((Map)map).put("sl-SI", "sl-SI");
        ((Map)map).put("sv", "sv");
        ((Map)map).put("ta", "ta-IN");
        ((Map)map).put("ta-IN", "ta-IN");
        ((Map)map).put("tl", "tl-PH");
        ((Map)map).put("tl-PH", "tl-PH");
        ((Map)map).put("uk", "uk-UA");
        ((Map)map).put("uk-UA", "uk-UA");
        ((Map)map).put("zh", "zh-CN");
        ((Map)map).put("zh-CN", "zh-CN");
        ((Map)map).put("arabic", "ar");
        ((Map)map).put("asturian", "ast-ES");
        ((Map)map).put("belarusian", "be-BY");
        ((Map)map).put("brazil", "pt-BR");
        ((Map)map).put("brazilian", "pt-BR");
        ((Map)map).put("catalan", "ca-ES");
        ((Map)map).put("danish", "da-DK");
        ((Map)map).put("austrian", "de-AT");
        ((Map)map).put("naustrian", "de-AT");
        ((Map)map).put("german", "de-DE");
        ((Map)map).put("ngerman", "de-DE");
        ((Map)map).put("nswissgerman", "de-CH");
        ((Map)map).put("swissgerman", "de-CH");
        ((Map)map).put("greek", "el-GR");
        ((Map)map).put("british", "en-GB");
        ((Map)map).put("UKenglish", "en-GB");
        ((Map)map).put("american", "en-US");
        ((Map)map).put("english", "en-US");
        ((Map)map).put("USenglish", "en-US");
        ((Map)map).put("esperanto", "eo");
        ((Map)map).put("estonian", "es");
        ((Map)map).put("farsi", "fa");
        ((Map)map).put("french", "fr");
        ((Map)map).put("irish", "ga-IE");
        ((Map)map).put("galician", "gl-ES");
        ((Map)map).put("italian", "it");
        ((Map)map).put("japanese", "ja-JP");
        ((Map)map).put("khmer", "km-KH");
        ((Map)map).put("dutch", "nl");
        ((Map)map).put("polish", "pl-PL");
        ((Map)map).put("portuges", "pt-PT");
        ((Map)map).put("portuguese", "pt-PT");
        ((Map)map).put("romanian", "ro-RO");
        ((Map)map).put("russian", "ru-RU");
        ((Map)map).put("slovak", "sk-SK");
        ((Map)map).put("slovene", "sl-SI");
        ((Map)map).put("swedish", "sv");
        ((Map)map).put("tamil", "ta-IN");
        ((Map)map).put("ukrainian", "uk-UA");
        ((Map)map).put("chinese", "zh-CN");
        BABEL_LANGUAGE_MAP = map;
        USE_PACKAGE_COMMAND_SIGNATURE = new LatexCommandSignature("\\usepackage[]{}", null, null, false, 14, null);
        USE_PACKAGE_COMMAND_SIGNATURE_MATCHER = new LatexCommandSignatureMatcher(CollectionsKt.listOf((Object)USE_PACKAGE_COMMAND_SIGNATURE), false, 2, null);
        BABEL_SWITCH_COMMAND_SIGNATURE = new LatexCommandSignature("\\selectlanguage{}", null, null, false, 14, null);
        BABEL_SWITCH_COMMAND_SIGNATURE_MATCHER = new LatexCommandSignatureMatcher(CollectionsKt.listOf((Object)BABEL_SWITCH_COMMAND_SIGNATURE), false, 2, null);
        Companion $this$BABEL_INLINE_COMMAND_SIGNATURE_MAP_u24lambda_u241 = Companion;
        boolean bl2 = false;
        map = new HashMap();
        ((Map)map).put(new LatexCommandSignature("\\foreignlanguage{}{}", null, null, false, 14, null), "");
        ((Map)map).put(new LatexCommandSignature("\\foreignlanguage[]{}{}", null, null, false, 14, null), "");
        for (Map.Entry<String, String> entry : BABEL_LANGUAGE_MAP.entrySet()) {
            String key = entry.getKey();
            value = entry.getValue();
            String languageTag = $this$BABEL_INLINE_COMMAND_SIGNATURE_MAP_u24lambda_u241.convertBabelLanguageToLanguageTag(key);
            ((Map)map).put(new LatexCommandSignature("\\text" + languageTag + "{}", null, null, false, 14, null), value);
        }
        BABEL_INLINE_COMMAND_SIGNATURE_MAP = map;
        Set<LatexCommandSignature> set = BABEL_INLINE_COMMAND_SIGNATURE_MAP.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"BABEL_INLINE_COMMAND_SIGNATURE_MAP.keys");
        BABEL_INLINE_COMMAND_SIGNATURE_MATCHER = new LatexCommandSignatureMatcher(CollectionsKt.toList((Iterable)set), false, 2, null);
        Companion $this$BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MAP_u24lambda_u242 = Companion;
        boolean bl3 = false;
        map = new HashMap();
        ((Map)map).put(new LatexCommandSignature("\\begin{otherlanguage}{}", null, null, false, 14, null), "");
        ((Map)map).put(new LatexCommandSignature("\\begin{otherlanguage*}{}", null, null, false, 14, null), "");
        ((Map)map).put(new LatexCommandSignature("\\begin{otherlanguage*}[]{}", null, null, false, 14, null), "");
        ((Map)map).put(new LatexCommandSignature("\\end{otherlanguage}", null, null, false, 14, null), "");
        ((Map)map).put(new LatexCommandSignature("\\end{otherlanguage*}", null, null, false, 14, null), "");
        for (Map.Entry<String, String> entry : BABEL_LANGUAGE_MAP.entrySet()) {
            String languageTag0 = entry.getKey();
            value = entry.getValue();
            String languageTag1 = $this$BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MAP_u24lambda_u242.convertBabelLanguageToLanguageTag(languageTag0);
            for (int i = 0; i < 2; ++i) {
                String languageTag;
                String string = languageTag = i == 0 ? languageTag0 : languageTag1;
                if (i == 1 && languageTag0.length() == languageTag1.length()) continue;
                ((Map)map).put(new LatexCommandSignature("\\begin{" + languageTag + "}", null, null, false, 14, null), value);
                ((Map)map).put(new LatexCommandSignature("\\begin{" + languageTag + "}[]", null, null, false, 14, null), value);
                ((Map)map).put(new LatexCommandSignature("\\end{" + languageTag + "}", null, null, false, 14, null), value);
            }
        }
        BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MAP = (Map)var3_3;
        BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MATCHER = new LatexCommandSignatureMatcher(CollectionsKt.toList((Iterable)BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MAP.keySet()), false, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\nj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexFragmentizer$Companion;", "", "()V", "BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MAP", "", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;", "", "BABEL_ENVIRONMENT_COMMAND_SIGNATURE_MATCHER", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignatureMatcher;", "BABEL_INLINE_COMMAND_SIGNATURE_MAP", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "BABEL_INLINE_COMMAND_SIGNATURE_MATCHER", "BABEL_LANGUAGE_MAP", "getBABEL_LANGUAGE_MAP", "()Ljava/util/Map;", "BABEL_SWITCH_COMMAND_SIGNATURE", "BABEL_SWITCH_COMMAND_SIGNATURE_MATCHER", "COMMENT_REGEX", "Lkotlin/text/Regex;", "EXTRA_COMMAND_SIGNATURE_MATCHER", "LANGUAGE_TAG_REPLACEMENT_REGEX", "USE_PACKAGE_COMMAND_SIGNATURE", "USE_PACKAGE_COMMAND_SIGNATURE_MATCHER", "convertBabelLanguageToLanguageTag", "language", "getIgnoreCommandPrototypes", "", "settings", "Lorg/bsplines/ltexls/settings/Settings;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getBABEL_LANGUAGE_MAP() {
            return BABEL_LANGUAGE_MAP;
        }

        private final Set<String> getIgnoreCommandPrototypes(Settings settings) {
            HashSet<String> ignoreCommandPrototypes = new HashSet<String>();
            for (Map.Entry<String, String> entry : settings.getLatexCommands().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!Intrinsics.areEqual((Object)value, (Object)"ignore")) continue;
                ignoreCommandPrototypes.add(key);
            }
            return ignoreCommandPrototypes;
        }

        @NotNull
        public final String convertBabelLanguageToLanguageTag(@NotNull String language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            CharSequence charSequence = language;
            Regex regex = LANGUAGE_TAG_REPLACEMENT_REGEX;
            String string = "";
            return regex.replace(charSequence, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

