/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.markdown;

import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.parsing.markdown.LtexMarkdownInlineMath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/bsplines/ltexls/parsing/markdown/LtexMarkdownInlineMathParser;", "Lcom/vladsch/flexmark/parser/InlineParserExtension;", "inlineParser", "Lcom/vladsch/flexmark/parser/LightInlineParser;", "(Lcom/vladsch/flexmark/parser/LightInlineParser;)V", "finalizeBlock", "", "Lcom/vladsch/flexmark/parser/InlineParser;", "finalizeDocument", "parse", "", "Companion", "Factory", "ltexls"})
public final class LtexMarkdownInlineMathParser
implements InlineParserExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final LightInlineParser inlineParser;
    private static final Pattern MATH_PATTERN = Pattern.compile("\\$([^ ]|[^ ](?:.|\n)*?[^ ])(?<!\\\\)(?:\\${2,}|\\$(?![0-9]))");

    public LtexMarkdownInlineMathParser(@Nullable LightInlineParser inlineParser) {
        this.inlineParser = inlineParser;
    }

    public void finalizeDocument(@NotNull InlineParser inlineParser) {
        Intrinsics.checkNotNullParameter((Object)inlineParser, (String)"inlineParser");
    }

    public void finalizeBlock(@NotNull InlineParser inlineParser) {
        Intrinsics.checkNotNullParameter((Object)inlineParser, (String)"inlineParser");
    }

    public boolean parse(@NotNull LightInlineParser inlineParser) {
        Intrinsics.checkNotNullParameter((Object)inlineParser, (String)"inlineParser");
        if (inlineParser.peek() == '$' && inlineParser.peek(1) != ' ') {
            BasedSequence basedSequence = inlineParser.getInput();
            Intrinsics.checkNotNullExpressionValue((Object)basedSequence, (String)"inlineParser.input");
            BasedSequence input = basedSequence;
            Matcher matcher = inlineParser.matcher(MATH_PATTERN);
            if (matcher != null) {
                inlineParser.flushTextNode();
                BasedSequence basedSequence2 = input.subSequence(matcher.start(), matcher.start(1));
                Intrinsics.checkNotNullExpressionValue((Object)basedSequence2, (String)"input.subSequence(matche\u2026tart(), matcher.start(1))");
                BasedSequence openingMarker = basedSequence2;
                BasedSequence basedSequence3 = input.subSequence(matcher.end(1), matcher.end());
                Intrinsics.checkNotNullExpressionValue((Object)basedSequence3, (String)"input.subSequence(matcher.end(1), matcher.end())");
                BasedSequence closingMarker = basedSequence3;
                BasedSequence basedSequence4 = openingMarker.baseSubSequence(openingMarker.getEndOffset(), closingMarker.getStartOffset());
                Intrinsics.checkNotNullExpressionValue((Object)basedSequence4, (String)"openingMarker.baseSubSeq\u2026losingMarker.startOffset)");
                LtexMarkdownInlineMath inlineMath = new LtexMarkdownInlineMath(openingMarker, basedSequence4, closingMarker);
                inlineParser.getBlock().appendChild((Node)inlineMath);
                return true;
            }
        }
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/bsplines/ltexls/parsing/markdown/LtexMarkdownInlineMathParser$Companion;", "", "()V", "MATH_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\nH\u0016J\u0014\u0010\f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/bsplines/ltexls/parsing/markdown/LtexMarkdownInlineMathParser$Factory;", "Lcom/vladsch/flexmark/parser/InlineParserExtensionFactory;", "()V", "affectsGlobalScope", "", "apply", "Lcom/vladsch/flexmark/parser/InlineParserExtension;", "lightInlineParser", "Lcom/vladsch/flexmark/parser/LightInlineParser;", "getAfterDependents", "", "Ljava/lang/Class;", "getBeforeDependents", "getCharacters", "", "ltexls"})
    public static final class Factory
    implements InlineParserExtensionFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @NotNull
        public CharSequence getCharacters() {
            return "$";
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @NotNull
        public InlineParserExtension apply(@NotNull LightInlineParser lightInlineParser) {
            Intrinsics.checkNotNullParameter((Object)lightInlineParser, (String)"lightInlineParser");
            return new LtexMarkdownInlineMathParser(lightInlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

