/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.program;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.bsplines.ltexls.parsing.CodeAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.markdown.MarkdownAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.program.ProgramCommentRegexs;
import org.bsplines.ltexls.parsing.restructuredtext.RestructuredtextAnnotatedTextBuilder;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.markup.AnnotatedText;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/bsplines/ltexls/parsing/program/ProgramAnnotatedTextBuilder;", "Lorg/bsplines/ltexls/parsing/CodeAnnotatedTextBuilder;", "codeLanguageId", "", "(Ljava/lang/String;)V", "annotatedTextBuilder", "commentBlockRegex", "Lkotlin/text/Regex;", "commentRegexs", "Lorg/bsplines/ltexls/parsing/program/ProgramCommentRegexs;", "lineCommentPatternString", "addCode", "code", "addComment", "comment", "isLineComment", "", "build", "Lorg/languagetool/markup/AnnotatedText;", "getCommonFirstCharacterInComment", "Companion", "ltexls"})
public final class ProgramAnnotatedTextBuilder
extends CodeAnnotatedTextBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeAnnotatedTextBuilder annotatedTextBuilder;
    @NotNull
    private final ProgramCommentRegexs commentRegexs;
    @NotNull
    private final Regex commentBlockRegex;
    @Nullable
    private final String lineCommentPatternString;
    @NotNull
    private static final Regex LINE_SEPARATOR_REGEX = new Regex("\r?\n");
    @NotNull
    private static final Regex FIRST_CHARACTER_REGEX = new Regex("^[ \t]*(?:([#$%*+\\-/])|(.))");

    public ProgramAnnotatedTextBuilder(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        this.annotatedTextBuilder = Intrinsics.areEqual((Object)codeLanguageId, (Object)"python") ? (CodeAnnotatedTextBuilder)new RestructuredtextAnnotatedTextBuilder("restructuredtext") : (CodeAnnotatedTextBuilder)new MarkdownAnnotatedTextBuilder("markdown");
        this.commentRegexs = ProgramCommentRegexs.Companion.fromCodeLanguageId(codeLanguageId);
        this.commentBlockRegex = this.commentRegexs.getCommentBlockRegex();
        this.lineCommentPatternString = this.commentRegexs.getLineCommentRegexString();
    }

    @Override
    @NotNull
    public CodeAnnotatedTextBuilder addCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        int curPos = 0;
        for (MatchResult matchResult : Regex.findAll$default((Regex)this.commentBlockRegex, (CharSequence)code, (int)0, (int)2, null)) {
            int lastPos = curPos;
            boolean isLineComment = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"lineComment") != null;
            String commentGroupName = isLineComment ? "lineComment" : "blockComment";
            MatchGroup commentGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)commentGroupName);
            if (commentGroup == null) {
                Object[] objectArray = new Object[]{commentGroupName};
                Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("couldNotFindExpectedGroupInRegularExpressionMatch", objectArray));
                continue;
            }
            curPos = commentGroup.getRange().getFirst();
            String string = code.substring(lastPos, curPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.annotatedTextBuilder.addMarkup(string, "\n\n");
            String comment = commentGroup.getValue();
            this.addComment(comment, isLineComment);
            curPos = commentGroup.getRange().getLast() + 1;
        }
        if (curPos < code.length()) {
            String string = code.substring(curPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            this.annotatedTextBuilder.addMarkup(string);
        }
        return this;
    }

    private final CodeAnnotatedTextBuilder addComment(String comment, boolean isLineComment) {
        String commonFirstCharacter = this.getCommonFirstCharacterInComment(comment);
        Regex lineContentsRegex = new Regex("[ \t]*" + (isLineComment && this.lineCommentPatternString != null ? this.lineCommentPatternString : "") + "(?:" + Regex.Companion.escape(commonFirstCharacter) + ")?[ \t]*(.*?)(?:\r?\n|$)");
        int curPos = 0;
        for (MatchResult matchResult : Regex.findAll$default((Regex)lineContentsRegex, (CharSequence)comment, (int)0, (int)2, null)) {
            MatchGroup matchGroup;
            if (matchResult.getGroups().get(1) == null) continue;
            int lastPos = curPos;
            curPos = matchGroup.getRange().getFirst();
            String string = comment.substring(lastPos, curPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.annotatedTextBuilder.addMarkup(string, "\n");
            lastPos = curPos;
            curPos = matchGroup.getRange().getLast() + 1;
            String string2 = comment.substring(lastPos, curPos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.annotatedTextBuilder.addCode(string2);
        }
        if (curPos < comment.length()) {
            String string = comment.substring(curPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            this.annotatedTextBuilder.addMarkup(string);
        }
        return this;
    }

    private final String getCommonFirstCharacterInComment(String comment) {
        String commonFirstCharacter = "";
        CharSequence charSequence = comment;
        Regex regex = LINE_SEPARATOR_REGEX;
        int n = 0;
        for (String line : regex.split(charSequence, n)) {
            MatchResult firstCharacterMatchResult;
            if (Regex.find$default((Regex)FIRST_CHARACTER_REGEX, (CharSequence)line, (int)0, (int)2, null) == null) continue;
            if (firstCharacterMatchResult.getGroups().get(1) == null) {
                return "";
            }
            String firstCharacter = (String)firstCharacterMatchResult.getGroupValues().get(1);
            if (((CharSequence)commonFirstCharacter).length() == 0) {
                commonFirstCharacter = firstCharacter;
                continue;
            }
            if (Intrinsics.areEqual((Object)firstCharacter, (Object)commonFirstCharacter)) continue;
            return "";
        }
        return commonFirstCharacter;
    }

    @NotNull
    public AnnotatedText build() {
        AnnotatedText annotatedText = this.annotatedTextBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)annotatedText, (String)"annotatedTextBuilder.build()");
        return annotatedText;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/bsplines/ltexls/parsing/program/ProgramAnnotatedTextBuilder$Companion;", "", "()V", "FIRST_CHARACTER_REGEX", "Lkotlin/text/Regex;", "LINE_SEPARATOR_REGEX", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

