/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/bsplines/ltexls/server/DelayedDiagnosticsPublisherRunnable;", "Ljava/lang/Runnable;", "languageClient", "Lorg/eclipse/lsp4j/services/LanguageClient;", "document", "Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "(Lorg/eclipse/lsp4j/services/LanguageClient;Lorg/bsplines/ltexls/server/LtexTextDocumentItem;)V", "getDocument", "()Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "getLanguageClient", "()Lorg/eclipse/lsp4j/services/LanguageClient;", "run", "", "Companion", "ltexls"})
public final class DelayedDiagnosticsPublisherRunnable
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageClient languageClient;
    @NotNull
    private final LtexTextDocumentItem document;
    @NotNull
    private static final Duration SHOW_CARET_DIAGNOSTICS_DURATION;
    private static final long SLEEP_DURATION_DELTA_MILLISECONDS = 10L;

    public DelayedDiagnosticsPublisherRunnable(@NotNull LanguageClient languageClient, @NotNull LtexTextDocumentItem document) {
        Intrinsics.checkNotNullParameter((Object)languageClient, (String)"languageClient");
        Intrinsics.checkNotNullParameter((Object)((Object)document), (String)"document");
        this.languageClient = languageClient;
        this.document = document;
    }

    @NotNull
    public final LanguageClient getLanguageClient() {
        return this.languageClient;
    }

    @NotNull
    public final LtexTextDocumentItem getDocument() {
        return this.document;
    }

    @Override
    public void run() {
        List<Diagnostic> diagnostics;
        Duration duration = SHOW_CARET_DIAGNOSTICS_DURATION.minus(Duration.between(this.document.getLastCaretChangeInstant(), Instant.now()));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"SHOW_CARET_DIAGNOSTICS_D\u2026nt, Instant.now()),\n    )");
        Duration sleepDuration = duration;
        if (sleepDuration.isNegative()) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            sleepDuration = duration2;
        }
        Duration duration3 = sleepDuration.plusMillis(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"sleepDuration.plusMillis\u2026ATION_DELTA_MILLISECONDS)");
        sleepDuration = duration3;
        try {
            Thread.sleep(sleepDuration.toMillis());
        }
        catch (InterruptedException e) {
            return;
        }
        if (Duration.between(this.document.getLastCaretChangeInstant(), Instant.now()).compareTo(SHOW_CARET_DIAGNOSTICS_DURATION) > 0 && (diagnostics = this.document.getDiagnosticsCache()) != null) {
            this.languageClient.publishDiagnostics(new PublishDiagnosticsParams(this.document.getUri(), diagnostics));
        }
    }

    static {
        Duration duration = Duration.ofSeconds(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(2)");
        SHOW_CARET_DIAGNOSTICS_DURATION = duration;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/bsplines/ltexls/server/DelayedDiagnosticsPublisherRunnable$Companion;", "", "()V", "SHOW_CARET_DIAGNOSTICS_DURATION", "Ljava/time/Duration;", "SLEEP_DURATION_DELTA_MILLISECONDS", "", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

