/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.client.LtexLanguageClient;
import org.bsplines.ltexls.languagetool.LanguageToolRuleMatch;
import org.bsplines.ltexls.parsing.AnnotatedTextFragment;
import org.bsplines.ltexls.server.DelayedDiagnosticsPublisherRunnable;
import org.bsplines.ltexls.server.LtexLanguageServer;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.bsplines.ltexls.tools.Tools;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0014\u00106\u001a\u0002032\f\u00107\u001a\b\u0012\u0004\u0012\u0002050\u001bJ\u0006\u00108\u001a\u000203J2\u00109\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001b0\u001a2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u000eH\u0002J \u0010=\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u000eH\u0002J\u001a\u0010>\u001a\u00020\u000e2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u000eH\u0002J\u0012\u0010?\u001a\u00020\u000e2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;J\u0012\u0010@\u001a\u00020\u000e2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;J*\u0010A\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001b0\u001a2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;J*\u0010B\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001b0\u001a2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;J\u000e\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\nJ\u000e\u0010C\u001a\u00020\n2\u0006\u0010E\u001a\u00020\u0014J\u0013\u0010F\u001a\u00020\u000e2\b\u0010G\u001a\u0004\u0018\u00010HH\u0096\u0002J\u0010\u0010I\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001bH\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010\u00142\u0006\u0010K\u001a\u00020\u0007H\u0002J*\u0010L\u001a\u0004\u0018\u00010\u00142\u0006\u0010M\u001a\u00020;2\u0006\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020\nH\u0002J\b\u0010Q\u001a\u00020\nH\u0016J\u0006\u0010R\u001a\u000203J\u0010\u0010S\u001a\u0002032\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010T\u001a\u0002032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006U"}, d2={"Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "Lorg/eclipse/lsp4j/TextDocumentItem;", "languageServer", "Lorg/bsplines/ltexls/server/LtexLanguageServer;", "document", "(Lorg/bsplines/ltexls/server/LtexLanguageServer;Lorg/eclipse/lsp4j/TextDocumentItem;)V", "uri", "", "codeLanguageId", "version", "", "text", "(Lorg/bsplines/ltexls/server/LtexLanguageServer;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "<set-?>", "", "beingChecked", "getBeingChecked", "()Z", "cancellationCounter", "caretPosition", "Lorg/eclipse/lsp4j/Position;", "getCaretPosition", "()Lorg/eclipse/lsp4j/Position;", "setCaretPosition", "(Lorg/eclipse/lsp4j/Position;)V", "checkingResult", "Lkotlin/Pair;", "", "Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "Lorg/eclipse/lsp4j/Diagnostic;", "diagnosticsCache", "getDiagnosticsCache", "()Ljava/util/List;", "getLanguageServer", "()Lorg/bsplines/ltexls/server/LtexLanguageServer;", "lastCaretChangeInstant", "Ljava/time/Instant;", "getLastCaretChangeInstant", "()Ljava/time/Instant;", "setLastCaretChangeInstant", "(Ljava/time/Instant;)V", "lineStartPosList", "", "lspCancelChecker", "Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "getLspCancelChecker", "()Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;", "setLspCancelChecker", "(Lorg/eclipse/lsp4j/jsonrpc/CancelChecker;)V", "applyTextChangeEvent", "", "textChangeEvent", "Lorg/eclipse/lsp4j/TextDocumentContentChangeEvent;", "applyTextChangeEvents", "textChangeEvents", "cancelCheck", "check", "range", "Lorg/eclipse/lsp4j/Range;", "useCache", "checkAndGetDiagnostics", "checkAndPublishDiagnostics", "checkAndPublishDiagnosticsWithCache", "checkAndPublishDiagnosticsWithoutCache", "checkWithCache", "checkWithoutCache", "convertPosition", "pos", "position", "equals", "other", "", "extractDiagnosticsNotAtCaret", "guessCaretPositionInFullUpdate", "oldText", "guessCaretPositionInIncrementalUpdate", "changeRange", "changeText", "fromPos", "toPos", "hashCode", "raiseExceptionIfCanceled", "reinitializeLineStartPosList", "setText", "ltexls"})
public final class LtexTextDocumentItem
extends TextDocumentItem {
    @NotNull
    private final LtexLanguageServer languageServer;
    @Nullable
    private Position caretPosition;
    @NotNull
    private Instant lastCaretChangeInstant;
    @Nullable
    private List<? extends Diagnostic> diagnosticsCache;
    private boolean beingChecked;
    @Nullable
    private CancelChecker lspCancelChecker;
    @NotNull
    private final List<Integer> lineStartPosList;
    @Nullable
    private Pair<? extends List<LanguageToolRuleMatch>, ? extends List<AnnotatedTextFragment>> checkingResult;
    private int cancellationCounter;

    public LtexTextDocumentItem(@NotNull LtexLanguageServer languageServer, @NotNull String uri, @NotNull String codeLanguageId, int version, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(uri, codeLanguageId, version, text);
        this.languageServer = languageServer;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.lastCaretChangeInstant = instant;
        this.lineStartPosList = new ArrayList();
        this.reinitializeLineStartPosList(text);
    }

    @NotNull
    public final LtexLanguageServer getLanguageServer() {
        return this.languageServer;
    }

    @Nullable
    public final Position getCaretPosition() {
        return this.caretPosition;
    }

    public final void setCaretPosition(@Nullable Position position) {
        this.caretPosition = position;
    }

    @NotNull
    public final Instant getLastCaretChangeInstant() {
        return this.lastCaretChangeInstant;
    }

    public final void setLastCaretChangeInstant(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.lastCaretChangeInstant = instant;
    }

    @Nullable
    public final List<Diagnostic> getDiagnosticsCache() {
        return this.diagnosticsCache;
    }

    public final boolean getBeingChecked() {
        return this.beingChecked;
    }

    @Nullable
    public final CancelChecker getLspCancelChecker() {
        return this.lspCancelChecker;
    }

    public final void setLspCancelChecker(@Nullable CancelChecker cancelChecker) {
        this.lspCancelChecker = cancelChecker;
    }

    public LtexTextDocumentItem(@NotNull LtexLanguageServer languageServer, @NotNull TextDocumentItem document) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String string = document.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.uri");
        String string2 = document.getLanguageId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.languageId");
        int n = document.getVersion();
        String string3 = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"document.text");
        this(languageServer, string, string2, n, string3);
    }

    private final void reinitializeLineStartPosList(String text) {
        this.lineStartPosList.clear();
        this.lineStartPosList.add(0);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\r') {
                if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                    ++i;
                }
                this.lineStartPosList.add(i + 1);
                continue;
            }
            if (c != '\n') continue;
            this.lineStartPosList.add(i + 1);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LtexTextDocumentItem)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.lineStartPosList, ((LtexTextDocumentItem)((Object)other)).lineStartPosList)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.checkingResult, ((LtexTextDocumentItem)((Object)other)).checkingResult)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.diagnosticsCache, ((LtexTextDocumentItem)((Object)other)).diagnosticsCache)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.caretPosition, (Object)((LtexTextDocumentItem)((Object)other)).caretPosition)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lastCaretChangeInstant, (Object)((LtexTextDocumentItem)((Object)other)).lastCaretChangeInstant);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + super.hashCode();
        hash = 53 * hash + ((Object)this.lineStartPosList).hashCode();
        if (this.checkingResult != null) {
            Pair<? extends List<LanguageToolRuleMatch>, ? extends List<AnnotatedTextFragment>> pair = this.checkingResult;
            hash = 53 * hash + (pair != null ? pair.hashCode() : 0);
        }
        List<? extends Diagnostic> list = this.diagnosticsCache;
        hash = 53 * hash + (list != null ? ((Object)list).hashCode() : 0);
        if (this.caretPosition != null) {
            Position position = this.caretPosition;
            hash = 53 * hash + (position != null ? position.hashCode() : 0);
        }
        hash = 53 * hash + this.lastCaretChangeInstant.hashCode();
        return hash;
    }

    public final int convertPosition(@NotNull Position position) {
        int n;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int line = position.getLine();
        int character = position.getCharacter();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String text = string;
        if (line < 0) {
            n = 0;
        } else if (line >= this.lineStartPosList.size()) {
            n = text.length();
        } else {
            int lineStart = ((Number)this.lineStartPosList.get(line)).intValue();
            int nextLineStart = line < this.lineStartPosList.size() - 1 ? ((Number)this.lineStartPosList.get(line + 1)).intValue() : text.length();
            int lineLength = nextLineStart - lineStart;
            if (character < 0) {
                n = lineStart;
            } else if (character >= lineLength) {
                int pos = lineStart + lineLength;
                if (pos >= 1 && text.charAt(pos - 1) != '\r' && text.charAt(pos - 1) == '\n' && --pos >= 1 && text.charAt(pos - 1) == '\r') {
                    --pos;
                }
                n = --pos;
            } else {
                n = lineStart + character;
            }
        }
        return n;
    }

    @NotNull
    public final Position convertPosition(int pos) {
        int line = CollectionsKt.binarySearch$default(this.lineStartPosList, (Comparable)Integer.valueOf(pos), (int)0, (int)0, (int)6, null);
        if (line < 0) {
            int insertionPoint = -line - 1;
            line = insertionPoint - 1;
        }
        return new Position(line, pos - ((Number)this.lineStartPosList.get(line)).intValue());
    }

    public void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText()");
        String oldText = string;
        super.setText(text);
        this.reinitializeLineStartPosList(text);
        this.checkingResult = null;
        this.diagnosticsCache = null;
        this.caretPosition = this.guessCaretPositionInFullUpdate(oldText);
        if (this.caretPosition != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            this.lastCaretChangeInstant = instant;
        }
    }

    public final void applyTextChangeEvents(@NotNull List<? extends TextDocumentContentChangeEvent> textChangeEvents) {
        Intrinsics.checkNotNullParameter(textChangeEvents, (String)"textChangeEvents");
        Instant oldLastCaretChangeInstant = this.lastCaretChangeInstant;
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : textChangeEvents) {
            this.applyTextChangeEvent(textDocumentContentChangeEvent);
        }
        if (textChangeEvents.size() > 1) {
            this.caretPosition = null;
            this.lastCaretChangeInstant = oldLastCaretChangeInstant;
        }
    }

    public final void applyTextChangeEvent(@NotNull TextDocumentContentChangeEvent textChangeEvent) {
        Intrinsics.checkNotNullParameter((Object)textChangeEvent, (String)"textChangeEvent");
        Range changeRange = textChangeEvent.getRange();
        String string = textChangeEvent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textChangeEvent.text");
        String changeText = string;
        String string2 = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
        String oldText = string2;
        int fromPos = 0;
        int toPos = 0;
        Object newText = null;
        if (changeRange != null) {
            int n;
            Position position = changeRange.getStart();
            Intrinsics.checkNotNullExpressionValue((Object)position, (String)"changeRange.start");
            fromPos = this.convertPosition(position);
            if (!Intrinsics.areEqual((Object)changeRange.getEnd(), (Object)changeRange.getStart())) {
                Position position2 = changeRange.getEnd();
                Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"changeRange.end");
                n = this.convertPosition(position2);
            } else {
                n = fromPos;
            }
            toPos = n;
            String string3 = oldText.substring(0, fromPos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string4 = oldText.substring(toPos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            newText = string3 + changeText + string4;
        } else {
            fromPos = -1;
            toPos = -1;
            newText = changeText;
        }
        super.setText((String)newText);
        this.reinitializeLineStartPosList((String)newText);
        this.checkingResult = null;
        this.diagnosticsCache = null;
        this.caretPosition = changeRange != null ? this.guessCaretPositionInIncrementalUpdate(changeRange, changeText, fromPos, toPos) : this.guessCaretPositionInFullUpdate(oldText);
        if (this.caretPosition != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            this.lastCaretChangeInstant = instant;
        }
    }

    private final Position guessCaretPositionInIncrementalUpdate(Range changeRange, String changeText, int fromPos, int toPos) {
        return fromPos == toPos ? this.convertPosition(toPos + changeText.length()) : (((CharSequence)changeText).length() == 0 ? new Position(changeRange.getStart().getLine(), changeRange.getStart().getCharacter()) : null);
    }

    private final Position guessCaretPositionInFullUpdate(String oldText) {
        int numberOfEqualCharsAtEnd;
        int numberOfEqualCharsAtStart;
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String newText = string;
        for (numberOfEqualCharsAtStart = 0; numberOfEqualCharsAtStart < oldText.length() && numberOfEqualCharsAtStart < newText.length() && oldText.charAt(numberOfEqualCharsAtStart) == newText.charAt(numberOfEqualCharsAtStart); ++numberOfEqualCharsAtStart) {
        }
        for (numberOfEqualCharsAtEnd = 0; numberOfEqualCharsAtEnd < oldText.length() - numberOfEqualCharsAtStart && numberOfEqualCharsAtEnd < newText.length() - numberOfEqualCharsAtStart && oldText.charAt(oldText.length() - numberOfEqualCharsAtEnd - 1) == newText.charAt(newText.length() - numberOfEqualCharsAtEnd - 1); ++numberOfEqualCharsAtEnd) {
        }
        int numberOfEqualChars = numberOfEqualCharsAtStart + numberOfEqualCharsAtEnd;
        if ((double)numberOfEqualChars < (double)oldText.length() / 2.0 || (double)numberOfEqualChars < (double)newText.length() / 2.0) {
            return null;
        }
        return this.convertPosition(newText.length() - numberOfEqualCharsAtEnd);
    }

    public final boolean checkAndPublishDiagnosticsWithCache(@Nullable Range range) {
        return this.checkAndPublishDiagnostics(range, true);
    }

    public static /* synthetic */ boolean checkAndPublishDiagnosticsWithCache$default(LtexTextDocumentItem ltexTextDocumentItem, Range range, int n, Object object) {
        if ((n & 1) != 0) {
            range = null;
        }
        return ltexTextDocumentItem.checkAndPublishDiagnosticsWithCache(range);
    }

    public final boolean checkAndPublishDiagnosticsWithoutCache(@Nullable Range range) {
        return this.checkAndPublishDiagnostics(range, false);
    }

    public static /* synthetic */ boolean checkAndPublishDiagnosticsWithoutCache$default(LtexTextDocumentItem ltexTextDocumentItem, Range range, int n, Object object) {
        if ((n & 1) != 0) {
            range = null;
        }
        return ltexTextDocumentItem.checkAndPublishDiagnosticsWithoutCache(range);
    }

    private final boolean checkAndPublishDiagnostics(Range range, boolean useCache) {
        LtexLanguageClient languageClient = this.languageServer.getLanguageClient();
        this.checkAndGetDiagnostics(range, useCache);
        if (languageClient == null) {
            return false;
        }
        List<Diagnostic> list = this.extractDiagnosticsNotAtCaret();
        if (list == null) {
            return false;
        }
        List<Diagnostic> diagnosticsNotAtCaret = list;
        languageClient.publishDiagnostics(new PublishDiagnosticsParams(this.getUri(), diagnosticsNotAtCaret));
        List<? extends Diagnostic> diagnostics = this.diagnosticsCache;
        if (diagnostics != null && diagnosticsNotAtCaret.size() < diagnostics.size()) {
            Thread thread = new Thread(new DelayedDiagnosticsPublisherRunnable(languageClient, this));
            thread.start();
        }
        return true;
    }

    private final List<Diagnostic> checkAndGetDiagnostics(Range range, boolean useCache) {
        List<? extends Diagnostic> diagnostics;
        if (useCache && (diagnostics = this.diagnosticsCache) != null) {
            return CollectionsKt.toList((Iterable)diagnostics);
        }
        Pair<List<LanguageToolRuleMatch>, List<AnnotatedTextFragment>> checkingResult = this.check(range, useCache);
        List matches2 = (List)checkingResult.getFirst();
        ArrayList<Diagnostic> diagnostics2 = new ArrayList<Diagnostic>();
        for (LanguageToolRuleMatch match : matches2) {
            diagnostics2.add(this.languageServer.getCodeActionProvider().createDiagnostic(match, this));
        }
        this.diagnosticsCache = diagnostics2;
        return diagnostics2;
    }

    private final List<Diagnostic> extractDiagnosticsNotAtCaret() {
        List<? extends Diagnostic> list = this.diagnosticsCache;
        if (list == null) {
            return null;
        }
        List<? extends Diagnostic> diagnosticsCache = list;
        Position position = this.caretPosition;
        if (position == null) {
            return CollectionsKt.toList((Iterable)diagnosticsCache);
        }
        Position caretPosition = position;
        ArrayList<Diagnostic> diagnosticsNotAtCaret = new ArrayList<Diagnostic>();
        int character = caretPosition.getCharacter();
        Position beforeCaretPosition = new Position(caretPosition.getLine(), character >= 1 ? character - 1 : 0);
        Range caretRange = new Range(beforeCaretPosition, this.caretPosition);
        for (Diagnostic diagnostic : diagnosticsCache) {
            Range range = diagnostic.getRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"diagnostic.range");
            if (Tools.INSTANCE.areRangesIntersecting(range, caretRange)) continue;
            diagnosticsNotAtCaret.add(diagnostic);
        }
        return diagnosticsNotAtCaret;
    }

    @NotNull
    public final Pair<List<LanguageToolRuleMatch>, List<AnnotatedTextFragment>> checkWithCache(@Nullable Range range) {
        return this.check(range, true);
    }

    public static /* synthetic */ Pair checkWithCache$default(LtexTextDocumentItem ltexTextDocumentItem, Range range, int n, Object object) {
        if ((n & 1) != 0) {
            range = null;
        }
        return ltexTextDocumentItem.checkWithCache(range);
    }

    @NotNull
    public final Pair<List<LanguageToolRuleMatch>, List<AnnotatedTextFragment>> checkWithoutCache(@Nullable Range range) {
        return this.check(range, false);
    }

    public static /* synthetic */ Pair checkWithoutCache$default(LtexTextDocumentItem ltexTextDocumentItem, Range range, int n, Object object) {
        if ((n & 1) != 0) {
            range = null;
        }
        return ltexTextDocumentItem.checkWithoutCache(range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<List<LanguageToolRuleMatch>, List<AnnotatedTextFragment>> check(Range range, boolean useCache) {
        Pair<List<LanguageToolRuleMatch>, List<AnnotatedTextFragment>> pair;
        block8: {
            Pair<? extends List<LanguageToolRuleMatch>, ? extends List<AnnotatedTextFragment>> checkingResult;
            if (useCache && (checkingResult = this.checkingResult) != null) {
                return new Pair((Object)CollectionsKt.toList((Iterable)((Iterable)checkingResult.getFirst())), (Object)CollectionsKt.toList((Iterable)((Iterable)checkingResult.getSecond())));
            }
            LtexLanguageClient ltexLanguageClient = this.languageServer.getLanguageClient();
            if (ltexLanguageClient == null) {
                return new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
            }
            LtexLanguageClient languageClient = ltexLanguageClient;
            Either progressToken = null;
            try {
                List<Object> list;
                this.raiseExceptionIfCanceled();
                this.beingChecked = true;
                String string = this.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri");
                String uri = string;
                if (this.languageServer.getClientSupportsWorkDoneProgress()) {
                    JsonObject progressJsonToken = new JsonObject();
                    progressJsonToken.addProperty("uri", uri);
                    progressJsonToken.addProperty("operation", "checkDocument");
                    progressJsonToken.addProperty("uuid", Tools.INSTANCE.getRandomUuid());
                    progressToken = Either.forLeft((Object)progressJsonToken.toString());
                    languageClient.createProgress(new WorkDoneProgressCreateParams(progressToken)).get();
                    this.raiseExceptionIfCanceled();
                    WorkDoneProgressBegin workDoneProgressBegin = new WorkDoneProgressBegin();
                    workDoneProgressBegin.setTitle(I18n.INSTANCE.format("checkingDocument", new Object[0]));
                    workDoneProgressBegin.setMessage(uri);
                    workDoneProgressBegin.setCancellable(Boolean.valueOf(false));
                    languageClient.notifyProgress(new ProgressParams(progressToken, Either.forLeft((Object)workDoneProgressBegin)));
                }
                ConfigurationItem configurationItem = new ConfigurationItem();
                configurationItem.setScopeUri(uri);
                configurationItem.setSection("ltex");
                ConfigurationParams configurationParams = new ConfigurationParams(CollectionsKt.listOf((Object)configurationItem));
                this.raiseExceptionIfCanceled();
                Object t = languageClient.configuration(configurationParams).get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"languageClient.configura\u2026onfigurationParams).get()");
                List configurationResult = (List)t;
                this.raiseExceptionIfCanceled();
                if (this.languageServer.getClientSupportsWorkspaceSpecificConfiguration()) {
                    List<Object> list2 = languageClient.ltexWorkspaceSpecificConfiguration(configurationParams).get();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"{\n        languageClient\u2026tionParams).get()\n      }");
                    list = list2;
                } else {
                    list = CollectionsKt.listOf(null);
                }
                List<Object> workspaceSpecificConfigurationResult = list;
                this.raiseExceptionIfCanceled();
                Object e = configurationResult.get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.google.gson.JsonElement");
                JsonElement jsonConfiguration = (JsonElement)e;
                Object workspaceSpecificConfiguration = workspaceSpecificConfigurationResult.get(0);
                JsonElement jsonWorkspaceSpecificConfiguration = (JsonElement)workspaceSpecificConfiguration;
                this.raiseExceptionIfCanceled();
                this.languageServer.getSettingsManager().setSettings(Settings.Companion.fromJson(jsonConfiguration, jsonWorkspaceSpecificConfiguration));
                this.raiseExceptionIfCanceled();
                Pair<List<LanguageToolRuleMatch>, List<AnnotatedTextFragment>> checkingResult2 = this.languageServer.getDocumentChecker().check(this, range);
                this.checkingResult = checkingResult2;
                pair = checkingResult2;
                if (progressToken == null) break block8;
            }
            catch (Throwable throwable) {
                if (progressToken != null) {
                    languageClient.notifyProgress(new ProgressParams(progressToken, Either.forLeft((Object)new WorkDoneProgressEnd())));
                }
                this.beingChecked = false;
                throw throwable;
            }
            languageClient.notifyProgress(new ProgressParams(progressToken, Either.forLeft((Object)new WorkDoneProgressEnd())));
        }
        this.beingChecked = false;
        return pair;
    }

    public final void raiseExceptionIfCanceled() {
        CancelChecker lspCancelChecker = this.lspCancelChecker;
        if (lspCancelChecker != null && lspCancelChecker.isCanceled()) {
            this.lspCancelChecker = null;
            Logging.INSTANCE.getLOGGER().fine(I18n.INSTANCE.format("cancelingCheckDueToLspCancelNotification", new Object[0]));
        } else if (this.cancellationCounter > 0) {
            int n = this.cancellationCounter;
            this.cancellationCounter = n + -1;
            Logging.INSTANCE.getLOGGER().fine(I18n.INSTANCE.format("cancelingCheckDueToIncomingCheckRequest", new Object[0]));
        } else {
            return;
        }
        this.beingChecked = false;
        throw new CancellationException();
    }

    public final void cancelCheck() {
        int n = this.cancellationCounter;
        this.cancellationCounter = n + 1;
    }
}

