/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.server.LtexLanguageServer;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.bsplines.ltexls.server.LtexWorkspaceService;
import org.bsplines.ltexls.tools.FileIo;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.bsplines.ltexls.tools.Tools;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/bsplines/ltexls/server/LtexWorkspaceService;", "Lorg/eclipse/lsp4j/services/WorkspaceService;", "languageServer", "Lorg/bsplines/ltexls/server/LtexLanguageServer;", "(Lorg/bsplines/ltexls/server/LtexLanguageServer;)V", "getLanguageServer", "()Lorg/bsplines/ltexls/server/LtexLanguageServer;", "didChangeConfiguration", "", "params", "Lorg/eclipse/lsp4j/DidChangeConfigurationParams;", "didChangeWatchedFiles", "Lorg/eclipse/lsp4j/DidChangeWatchedFilesParams;", "executeCheckDocumentCommand", "Ljava/util/concurrent/CompletableFuture;", "", "arguments", "Lcom/google/gson/JsonObject;", "executeCommand", "Lorg/eclipse/lsp4j/ExecuteCommandParams;", "executeGetServerStatusCommand", "Companion", "ltexls"})
public final class LtexWorkspaceService
implements WorkspaceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LtexLanguageServer languageServer;
    @NotNull
    private static final String CHECK_DOCUMENT_COMMAND_NAME = "_ltex.checkDocument";
    @NotNull
    private static final String GET_SERVER_STATUS_COMMAND_NAME = "_ltex.getServerStatus";
    private static final long CHECK_CHECKING_STATUS_MILLISECONDS = 10L;
    private static final double MILLISECONDS_PER_SECOND = 1000.0;
    private static final double NANOSECONDS_PER_SECOND = 1.0E9;

    public LtexWorkspaceService(@NotNull LtexLanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        this.languageServer = languageServer;
    }

    @NotNull
    public final LtexLanguageServer getLanguageServer() {
        return this.languageServer;
    }

    public void didChangeConfiguration(@NotNull DidChangeConfigurationParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.languageServer.getLtexTextDocumentService().executeFunctionForEachDocument((Function1<? super LtexTextDocumentItem, Unit>)((Function1)new Function1<LtexTextDocumentItem, Unit>(this){
            final /* synthetic */ LtexWorkspaceService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull LtexTextDocumentItem document) {
                Intrinsics.checkNotNullParameter((Object)((Object)document), (String)"document");
                if (document.getBeingChecked()) {
                    document.cancelCheck();
                }
                this.this$0.getLanguageServer().getSingleThreadExecutorService().execute(() -> didChangeConfiguration.1.invoke$lambda$0(document));
            }

            private static final void invoke$lambda$0(LtexTextDocumentItem $document) {
                Intrinsics.checkNotNullParameter((Object)((Object)$document), (String)"$document");
                Exception exception = null;
                try {
                    LtexTextDocumentItem.checkAndPublishDiagnosticsWithoutCache$default($document, null, 1, null);
                    $document.raiseExceptionIfCanceled();
                }
                catch (ExecutionException e) {
                    exception = e;
                }
                catch (InterruptedException e) {
                    exception = e;
                }
                if (exception != null) {
                    Tools.INSTANCE.rethrowCancellationException(exception);
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format(exception));
                }
            }
        }));
    }

    public void didChangeWatchedFiles(@NotNull DidChangeWatchedFilesParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    @NotNull
    public CompletableFuture<Object> executeCommand(@NotNull ExecuteCommandParams params) {
        CompletableFuture completableFuture;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = params.getCommand();
        if (Intrinsics.areEqual((Object)string, (Object)CHECK_DOCUMENT_COMMAND_NAME)) {
            Object e = params.getArguments().get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
            completableFuture = this.executeCheckDocumentCommand((JsonObject)e);
        } else if (Intrinsics.areEqual((Object)string, (Object)GET_SERVER_STATUS_COMMAND_NAME)) {
            completableFuture = this.executeGetServerStatusCommand();
        } else {
            Object[] objectArray = new Object[]{params.getCommand()};
            completableFuture = LtexWorkspaceService.Companion.failCommand(I18n.INSTANCE.format("unknownCommand", objectArray));
        }
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<Object> executeCheckDocumentCommand(@NotNull JsonObject arguments) {
        Range range;
        Range range2;
        String text;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String string = arguments.get("uri").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arguments.get(\"uri\").asString");
        String uriStr = string;
        JsonElement jsonElement = arguments.get("codeLanguageId");
        String codeLanguageId = jsonElement != null ? jsonElement.getAsString() : null;
        JsonElement jsonElement2 = arguments.get("text");
        String string2 = text = jsonElement2 != null ? jsonElement2.getAsString() : null;
        if (codeLanguageId == null || text == null) {
            String string3;
            Object[] objectArray;
            try {
                Object[] objectArray2 = Paths.get(new URI(uriStr));
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"{\n        Paths.get(URI(uriStr))\n      }");
                objectArray = objectArray2;
            }
            catch (IllegalArgumentException e) {
                return LtexWorkspaceService.Companion.failCommand(I18n.INSTANCE.format("couldNotParseDocumentUri", e, new Object[0]));
            }
            catch (URISyntaxException e) {
                return LtexWorkspaceService.Companion.failCommand(I18n.INSTANCE.format("couldNotParseDocumentUri", e, new Object[0]));
            }
            Object[] path = objectArray;
            if (text == null && (text = FileIo.INSTANCE.readFile((Path)path)) == null) {
                objectArray = new Object[]{path.toString()};
                return LtexWorkspaceService.Companion.failCommand(I18n.INSTANCE.format("couldNotReadFile", objectArray));
            }
            String string4 = codeLanguageId;
            if (string4 == null) {
                string4 = FileIo.INSTANCE.getCodeLanguageIdFromPath((Path)path);
            }
            if ((string3 = (codeLanguageId = string4)) == null) {
                string3 = "plaintext";
            }
            codeLanguageId = string3;
        }
        LtexTextDocumentItem document = new LtexTextDocumentItem(this.languageServer, uriStr, codeLanguageId, 1, text);
        if (arguments.has("range")) {
            JsonObject jsonObject = arguments.getAsJsonObject("range");
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"arguments.getAsJsonObject(\"range\")");
            JsonObject jsonRange = jsonObject;
            JsonObject jsonObject2 = jsonRange.getAsJsonObject("start");
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"jsonRange.getAsJsonObject(\"start\")");
            JsonObject jsonStart = jsonObject2;
            JsonObject jsonObject3 = jsonRange.getAsJsonObject("end");
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"jsonRange.getAsJsonObject(\"end\")");
            JsonObject jsonEnd = jsonObject3;
            range2 = new Range(new Position(jsonStart.get("line").getAsInt(), jsonStart.get("character").getAsInt()), new Position(jsonEnd.get("line").getAsInt(), jsonEnd.get("character").getAsInt()));
        } else {
            range2 = range = null;
        }
        if (document.getBeingChecked()) {
            document.cancelCheck();
        }
        CompletableFuture completableFuture = CompletableFutures.computeAsync((Executor)this.languageServer.getSingleThreadExecutorService(), arg_0 -> LtexWorkspaceService.executeCheckDocumentCommand$lambda$0(document, range, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"computeAsync(this.langua\u2026List<Any>()\n      }\n    }");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<Object> executeGetServerStatusCommand() {
        String string;
        boolean bl;
        long processId = ProcessHandle.current().pid();
        double wallClockDuration = (double)Duration.between(this.languageServer.getStartupInstant(), Instant.now()).toMillis() / 1000.0;
        Double cpuDuration = null;
        Double cpuUsage = null;
        double totalMemory = Runtime.getRuntime().totalMemory();
        double usedMemory = totalMemory - (double)Runtime.getRuntime().freeMemory();
        if (ManagementFactory.getOperatingSystemMXBean() instanceof com.sun.management.OperatingSystemMXBean) {
            long cpuDurationLong;
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            Intrinsics.checkNotNull((Object)operatingSystemMXBean, (String)"null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
            com.sun.management.OperatingSystemMXBean operatingSystemMxBean = (com.sun.management.OperatingSystemMXBean)operatingSystemMXBean;
            cpuUsage = operatingSystemMxBean.getProcessCpuLoad();
            if (Intrinsics.areEqual((Double)cpuUsage, (double)-1.0)) {
                cpuUsage = null;
            }
            cpuDuration = (cpuDurationLong = operatingSystemMxBean.getProcessCpuTime()) != -1L ? Double.valueOf((double)cpuDurationLong / 1.0E9) : null;
        } else {
            cpuDuration = null;
            cpuUsage = null;
        }
        Future<Boolean> future = this.languageServer.getSingleThreadExecutorService().submit(LtexWorkspaceService::executeGetServerStatusCommand$lambda$1);
        Intrinsics.checkNotNullExpressionValue(future, (String)"this.languageServer.sing\u2026submit(Callable { true })");
        Future<Boolean> singleThreadTestFuture = future;
        try {
            bl = singleThreadTestFuture.get(10L, TimeUnit.MILLISECONDS) == false;
        }
        catch (ExecutionException e) {
            bl = true;
        }
        catch (InterruptedException e) {
            bl = true;
        }
        catch (TimeoutException e) {
            bl = true;
        }
        boolean isChecking = bl;
        if (isChecking) {
            LtexTextDocumentItem ltexTextDocumentItem = this.languageServer.getDocumentChecker().getLastCheckedDocument();
            string = ltexTextDocumentItem != null ? ltexTextDocumentItem.getUri() : null;
        } else {
            string = null;
        }
        String documentUriBeingChecked = string;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("success", Boolean.valueOf(true));
        jsonObject.addProperty("processId", (Number)processId);
        jsonObject.addProperty("wallClockDuration", (Number)wallClockDuration);
        if (cpuUsage != null) {
            jsonObject.addProperty("cpuUsage", (Number)cpuUsage);
        }
        if (cpuDuration != null) {
            jsonObject.addProperty("cpuDuration", (Number)cpuDuration);
        }
        jsonObject.addProperty("usedMemory", (Number)usedMemory);
        jsonObject.addProperty("totalMemory", (Number)totalMemory);
        jsonObject.addProperty("isChecking", Boolean.valueOf(isChecking));
        if (documentUriBeingChecked != null) {
            jsonObject.addProperty("documentUriBeingChecked", documentUriBeingChecked);
        }
        CompletableFuture<JsonObject> completableFuture = CompletableFuture.completedFuture(jsonObject);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(jsonObject)");
        return completableFuture;
    }

    private static final Object executeCheckDocumentCommand$lambda$0(LtexTextDocumentItem $document, Range $range, CancelChecker lspCancelChecker) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)$document), (String)"$document");
        Intrinsics.checkNotNullParameter((Object)lspCancelChecker, (String)"lspCancelChecker");
        $document.setLspCancelChecker(lspCancelChecker);
        try {
            boolean success = $document.checkAndPublishDiagnosticsWithoutCache($range);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("success", Boolean.valueOf(success));
            $document.raiseExceptionIfCanceled();
            list = jsonObject;
        }
        catch (ExecutionException e) {
            Tools.INSTANCE.rethrowCancellationException(e);
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format(e));
            list = CollectionsKt.emptyList();
        }
        catch (InterruptedException e) {
            Tools.INSTANCE.rethrowCancellationException(e);
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format(e));
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Boolean executeGetServerStatusCommand$lambda$1() {
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/bsplines/ltexls/server/LtexWorkspaceService$Companion;", "", "()V", "CHECK_CHECKING_STATUS_MILLISECONDS", "", "CHECK_DOCUMENT_COMMAND_NAME", "", "GET_SERVER_STATUS_COMMAND_NAME", "MILLISECONDS_PER_SECOND", "", "NANOSECONDS_PER_SECOND", "failCommand", "Ljava/util/concurrent/CompletableFuture;", "errorMessage", "getCommandNames", "", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        private final CompletableFuture<Object> failCommand(String errorMessage) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("success", Boolean.valueOf(false));
            jsonObject.addProperty("errorMessage", errorMessage);
            CompletableFuture<JsonObject> completableFuture = CompletableFuture.completedFuture(jsonObject);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(jsonObject)");
            return completableFuture;
        }

        @NotNull
        public final List<String> getCommandNames() {
            Object[] objectArray = new String[]{LtexWorkspaceService.CHECK_DOCUMENT_COMMAND_NAME, LtexWorkspaceService.GET_SERVER_STATUS_COMMAND_NAME};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

