/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.languagetool.LanguageToolRuleMatch;
import org.bsplines.ltexls.server.CodeActionProvider;
import org.bsplines.ltexls.server.DocumentChecker;
import org.bsplines.ltexls.server.LtexLanguageServer;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.FileIo;
import org.eclipse.lsp4j.Position;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.languagetool.rules.RuleMatch;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/bsplines/ltexls/server/NonServerChecker;", "", "()V", "languageServer", "Lorg/bsplines/ltexls/server/LtexLanguageServer;", "getLanguageServer", "()Lorg/bsplines/ltexls/server/LtexLanguageServer;", "check", "", "path", "Ljava/nio/file/Path;", "paths", "", "checkDirectory", "loadSettings", "", "settingsFilePath", "Companion", "ltexls"})
public final class NonServerChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LtexLanguageServer languageServer = new LtexLanguageServer();
    @NotNull
    private static final Regex TRAILING_WHITESPACE_REGEX = new Regex("[ \t\r\n]+$");
    private static final int MAX_NUMBER_OF_SUGGESTIONS = 5;
    private static final int STANDARD_INPUT_BUFFER_SIZE = 1024;
    private static final int TAB_SIZE = 8;

    public NonServerChecker() {
        this.languageServer.getSettingsManager().setSettings(Settings.copy$default(this.languageServer.getSettingsManager().getSettings(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Level.WARNING, null, null, null, null, null, 0x3EFFFF, null));
    }

    @NotNull
    public final LtexLanguageServer getLanguageServer() {
        return this.languageServer;
    }

    public final void loadSettings(@NotNull Path settingsFilePath) {
        Intrinsics.checkNotNullParameter((Object)settingsFilePath, (String)"settingsFilePath");
        String settingsJson = FileIo.INSTANCE.readFileWithException(settingsFilePath);
        JsonObject jsonObject = JsonParser.parseString((String)settingsJson).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"parseString(settingsJson).asJsonObject");
        JsonObject jsonSettings = jsonObject;
        if (!jsonSettings.has("ltex-ls")) {
            jsonSettings.add("ltex-ls", (JsonElement)new JsonObject());
        }
        JsonObject jsonObject2 = jsonSettings.getAsJsonObject("ltex-ls");
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"jsonSettings.getAsJsonObject(\"ltex-ls\")");
        JsonObject ltexLsJsonSettings = jsonObject2;
        if (!ltexLsJsonSettings.has("logLevel")) {
            ltexLsJsonSettings.addProperty("logLevel", "warning");
        }
        this.languageServer.getSettingsManager().setSettings(Settings.Companion.fromJson$default(Settings.Companion, (JsonElement)jsonSettings, null, 2, null));
    }

    public final int check(@NotNull List<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        int numberOfMatches = 0;
        for (Path path : paths) {
            numberOfMatches += this.check(path);
        }
        return numberOfMatches;
    }

    public final int check(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String text = null;
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
        File file2 = file;
        String codeLanguageId = null;
        if (Intrinsics.areEqual((Object)((Object)path).toString(), (Object)"-")) {
            int length;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = System.in.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            String string = outputStream.toString(StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputStream.toString(StandardCharsets.UTF_8)");
            text = string;
            codeLanguageId = "plaintext";
        } else {
            if (file2.isDirectory()) {
                return this.checkDirectory(path);
            }
            Path path2 = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.toPath()");
            text = FileIo.INSTANCE.readFileWithException(path2);
            String string = FileIo.INSTANCE.getCodeLanguageIdFromPath(path);
            if (string == null) {
                string = "plaintext";
            }
            codeLanguageId = string;
        }
        String string = path.toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.toUri().toString()");
        LtexTextDocumentItem document = new LtexTextDocumentItem(this.languageServer, string, codeLanguageId, 1, text);
        Pair checkingResult = DocumentChecker.check$default(this.languageServer.getDocumentChecker(), document, null, 2, null);
        int terminalWidth = AnsiConsole.getTerminalWidth();
        if (terminalWidth <= 1) {
            terminalWidth = Integer.MAX_VALUE;
        }
        for (LanguageToolRuleMatch match : (List)checkingResult.getFirst()) {
            NonServerChecker.Companion.printMatch(path, document, match, terminalWidth);
        }
        return ((List)checkingResult.getFirst()).size();
    }

    private final int checkDirectory(Path path) {
        int numberOfMatches = 0;
        boolean plainTextEnabled = this.languageServer.getSettingsManager().getSettings().getEnabled().contains("plaintext");
        for (Object t : Files.walk(path, new FileVisitOption[0]).collect(Collectors.toList())) {
            String curCodeLanguageId;
            Intrinsics.checkNotNullExpressionValue(t, (String)"Files.walk(path).collect(Collectors.toList())");
            Path childPath = (Path)t;
            if (!childPath.toFile().isFile() || (curCodeLanguageId = FileIo.INSTANCE.getCodeLanguageIdFromPath(childPath)) == null || Intrinsics.areEqual((Object)curCodeLanguageId, (Object)"plaintext") && !plainTextEnabled) continue;
            numberOfMatches += this.check(childPath);
        }
        return numberOfMatches;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/bsplines/ltexls/server/NonServerChecker$Companion;", "", "()V", "MAX_NUMBER_OF_SUGGESTIONS", "", "STANDARD_INPUT_BUFFER_SIZE", "TAB_SIZE", "TRAILING_WHITESPACE_REGEX", "Lkotlin/text/Regex;", "guessIndentationSize", "text", "", "lineStartPos", "fromPos", "terminalWidth", "printMatch", "", "path", "Ljava/nio/file/Path;", "document", "Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "match", "Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        private final void printMatch(Path path, LtexTextDocumentItem document, LanguageToolRuleMatch match, int terminalWidth) {
            String suggestedReplacement;
            String string;
            String typeString;
            Ansi.Color color;
            String string2 = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
            String text = string2;
            int fromPos = match.getFromPos();
            int toPos = match.getToPos();
            Position fromPosition = document.convertPosition(fromPos);
            CharSequence charSequence = match.getMessage();
            Regex regex = CodeActionProvider.Companion.getSUGGESTION_REGEX();
            String string3 = "'$1'";
            String message = regex.replace(charSequence, string3);
            switch (WhenMappings.$EnumSwitchMapping$0[match.getType().ordinal()]) {
                case 1: {
                    color = Ansi.Color.RED;
                    break;
                }
                case 2: {
                    color = Ansi.Color.BLUE;
                    break;
                }
                case 3: {
                    color = Ansi.Color.YELLOW;
                    break;
                }
                default: {
                    color = Ansi.Color.BLUE;
                }
            }
            Ansi.Color color2 = color;
            switch (WhenMappings.$EnumSwitchMapping$0[match.getType().ordinal()]) {
                case 1: {
                    String string4 = "spelling";
                    break;
                }
                case 2: {
                    String string4 = "style";
                    break;
                }
                case 3: {
                    String string4 = "grammar";
                    break;
                }
                default: {
                    String string4 = typeString = "style";
                }
            }
            if (match.isUnknownWordRule()) {
                color2 = Ansi.Color.RED;
                typeString = "spelling";
            }
            if ((string = match.getRuleId()) == null) {
                string = "";
            }
            String ruleId = string;
            Ansi ansi = Ansi.ansi().bold().a(((Object)path).toString()).a(":").a(fromPosition.getLine() + 1).a(":").a(fromPosition.getCharacter() + 1).a(": ").fg(color2).a(typeString).a(":").reset().bold().a(" ").a(message).a(" [").a(ruleId).a("]").reset();
            System.out.println(ansi);
            int lineStartPos = document.convertPosition(new Position(fromPosition.getLine(), 0));
            int lineEndPos = document.convertPosition(new Position(fromPosition.getLine() + 1, 0));
            String string5 = text.substring(lineStartPos, lineEndPos);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String line = string5;
            Ansi ansi2 = Ansi.ansi();
            String string6 = line.substring(0, fromPos - lineStartPos);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Ansi ansi3 = ansi2.a(string6).bold().fg(color2);
            String string7 = line.substring(fromPos - lineStartPos, toPos - lineStartPos);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Ansi ansi4 = ansi3.a(string7).reset();
            String string8 = line.substring(toPos - lineStartPos);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String).substring(startIndex)");
            CharSequence charSequence2 = string8;
            Regex regex2 = TRAILING_WHITESPACE_REGEX;
            String string9 = "";
            charSequence2 = ansi4.a(regex2.replaceFirst(charSequence2, string9));
            System.out.println(charSequence2);
            int indentationSize = this.guessIndentationSize(text, lineStartPos, fromPos, terminalWidth);
            ArrayList<String> suggestedReplacements = new ArrayList<String>();
            int n = Integer.min(match.getSuggestedReplacements().size(), 5);
            for (int i = 0; i < n; ++i) {
                suggestedReplacement = match.getSuggestedReplacements().get(i);
                if (indentationSize + suggestedReplacement.length() > terminalWidth) {
                    indentationSize = 0;
                }
                suggestedReplacements.add(suggestedReplacement);
            }
            String indentation = StringsKt.repeat((CharSequence)" ", (int)indentationSize);
            for (Object e : suggestedReplacements) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"suggestedReplacements");
                suggestedReplacement = (String)e;
                System.out.println(Ansi.ansi().a(indentation).fg(Ansi.Color.GREEN).a(suggestedReplacement).reset());
            }
        }

        private final int guessIndentationSize(String text, int lineStartPos, int fromPos, int terminalWidth) {
            int indentationSize = 0;
            for (int pos = lineStartPos; pos < fromPos; ++pos) {
                indentationSize = text.charAt(pos) == '\t' ? (int)(Math.ceil(((double)indentationSize + 1.0) / (double)8) * (double)8) : ++indentationSize;
                if (indentationSize < terminalWidth) continue;
                indentationSize = 0;
            }
            return indentationSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RuleMatch.Type.values().length];
                try {
                    nArray[RuleMatch.Type.UnknownWord.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RuleMatch.Type.Hint.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RuleMatch.Type.Other.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

