/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.settings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.languagetool.LanguageToolHttpInterface;
import org.bsplines.ltexls.languagetool.LanguageToolInterface;
import org.bsplines.ltexls.languagetool.LanguageToolJavaInterface;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.settings.SettingsDifference;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0005R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/bsplines/ltexls/settings/SettingsManager;", "", "()V", "settings", "Lorg/bsplines/ltexls/settings/Settings;", "(Lorg/bsplines/ltexls/settings/Settings;)V", "<set-?>", "Lorg/bsplines/ltexls/languagetool/LanguageToolInterface;", "languageToolInterface", "getLanguageToolInterface", "()Lorg/bsplines/ltexls/languagetool/LanguageToolInterface;", "languageToolInterfaceMap", "", "", "value", "getSettings", "()Lorg/bsplines/ltexls/settings/Settings;", "setSettings", "settingsMap", "initialize", "", "reinitializeLanguageToolInterface", "Companion", "ltexls"})
public final class SettingsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Settings> settingsMap;
    @NotNull
    private final Map<String, LanguageToolInterface> languageToolInterfaceMap;
    @Nullable
    private LanguageToolInterface languageToolInterface;
    @NotNull
    private Settings settings;

    @Nullable
    public final LanguageToolInterface getLanguageToolInterface() {
        return this.languageToolInterface;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    public final void setSettings(@NotNull Settings value) {
        LanguageToolInterface languageToolInterface;
        LanguageToolInterface languageToolInterface2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String newLanguage = value.getLanguageShortCode();
        Settings oldSettings = this.settingsMap.get(newLanguage);
        this.settings = value;
        this.settingsMap.put(newLanguage, value);
        Logging.INSTANCE.setLogLevel(value.getLogLevel());
        Set<SettingsDifference> settingsDifferencesRelevantForLanguageTool = value.getDifferencesRelevantForLanguageTool(oldSettings);
        if (settingsDifferencesRelevantForLanguageTool.isEmpty()) {
            languageToolInterface2 = this.languageToolInterfaceMap.get(newLanguage);
        } else {
            if (Logging.INSTANCE.getLOGGER().isLoggable(Level.FINE)) {
                Companion.logDifferentSettings(newLanguage, settingsDifferencesRelevantForLanguageTool);
            }
            this.reinitializeLanguageToolInterface();
            languageToolInterface2 = this.languageToolInterface;
        }
        LanguageToolInterface languageToolInterface3 = languageToolInterface = languageToolInterface2;
        if (languageToolInterface3 != null) {
            languageToolInterface3.setDictionary(value.getDictionary());
        }
        LanguageToolInterface languageToolInterface4 = languageToolInterface;
        if (languageToolInterface4 != null) {
            languageToolInterface4.setDisabledRules(value.getDisabledRules());
        }
        LanguageToolInterface languageToolInterface5 = languageToolInterface;
        if (languageToolInterface5 != null) {
            languageToolInterface5.setLanguageToolOrgUsername(value.getLanguageToolOrgUsername());
        }
        LanguageToolInterface languageToolInterface6 = languageToolInterface;
        if (languageToolInterface6 != null) {
            languageToolInterface6.setLanguageToolOrgApiKey(value.getLanguageToolOrgApiKey());
        }
        this.languageToolInterface = languageToolInterface;
        this.languageToolInterfaceMap.put(newLanguage, languageToolInterface);
    }

    public SettingsManager() {
        this.settingsMap = new HashMap();
        this.languageToolInterfaceMap = new HashMap();
        this.settings = new Settings(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFF, null);
        this.initialize();
    }

    public SettingsManager(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settingsMap = new HashMap();
        this.languageToolInterfaceMap = new HashMap();
        this.settings = new Settings(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFF, null);
        this.setSettings(settings);
        this.initialize();
    }

    private final void initialize() {
        this.reinitializeLanguageToolInterface();
        String language = this.settings.getLanguageShortCode();
        this.settingsMap.put(language, this.settings);
        this.languageToolInterfaceMap.put(language, this.languageToolInterface);
        Logging.INSTANCE.setLogLevel(this.settings.getLogLevel());
    }

    private final void reinitializeLanguageToolInterface() {
        LanguageToolInterface languageToolInterface;
        LanguageToolInterface languageToolInterface2 = languageToolInterface = ((CharSequence)this.settings.getLanguageToolHttpServerUri()).length() == 0 ? (LanguageToolInterface)new LanguageToolJavaInterface(this.settings.getLanguageShortCode(), this.settings.getMotherTongueShortCode(), this.settings.getSentenceCacheSize(), this.settings.getDictionary()) : (LanguageToolInterface)new LanguageToolHttpInterface(this.settings.getLanguageToolHttpServerUri(), this.settings.getLanguageShortCode(), this.settings.getMotherTongueShortCode());
        if (!languageToolInterface.isInitialized()) {
            this.languageToolInterface = null;
            return;
        }
        if (((CharSequence)this.settings.getLanguageModelRulesDirectory()).length() > 0) {
            languageToolInterface.activateLanguageModelRules(this.settings.getLanguageModelRulesDirectory());
        } else if (((CharSequence)this.settings.getMotherTongueShortCode()).length() > 0) {
            languageToolInterface.activateDefaultFalseFriendRules();
        }
        languageToolInterface.enableRules(this.settings.getEnabledRules());
        this.languageToolInterface = languageToolInterface;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lorg/bsplines/ltexls/settings/SettingsManager$Companion;", "", "()V", "logDifferentSettings", "", "newLanguage", "", "settingsDifferencesRelevantForLanguageTool", "", "Lorg/bsplines/ltexls/settings/SettingsDifference;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public final void logDifferentSettings(@NotNull String newLanguage, @NotNull Set<SettingsDifference> settingsDifferencesRelevantForLanguageTool) {
            Intrinsics.checkNotNullParameter((Object)newLanguage, (String)"newLanguage");
            Intrinsics.checkNotNullParameter(settingsDifferencesRelevantForLanguageTool, (String)"settingsDifferencesRelevantForLanguageTool");
            HashSet differences = new HashSet(settingsDifferencesRelevantForLanguageTool);
            StringBuilder builder = new StringBuilder();
            for (Object e : differences) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"differences");
                SettingsDifference difference = (SettingsDifference)e;
                if (((CharSequence)builder).length() > 0) {
                    builder.append("; ");
                }
                builder.append("setting '");
                builder.append(difference.getName());
                builder.append("', old '");
                builder.append(difference.getOtherValue());
                builder.append("', new '");
                builder.append(difference.getThisValue());
                builder.append("'");
            }
            Object[] objectArray = new Object[]{newLanguage, builder.toString()};
            Logging.INSTANCE.getLOGGER().fine(I18n.INSTANCE.format("reinitializingLanguageToolDueToDifferentSettings", objectArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

