/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.de.LongSentenceRule;

public class SimpleGerman
extends GermanyGerman {
    public boolean isVariant() {
        return true;
    }

    public String getName() {
        return "Simple German";
    }

    public String getShortCode() {
        return "de-DE-x-simple-language";
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Annika Nietzio")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        LongSentenceRule lengthRule = new LongSentenceRule(messages, userConfig, 12);
        rules.add((Rule)lengthRule);
        return rules;
    }

    public LanguageModel getLanguageModel(File indexDir) throws IOException {
        return null;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Collections.emptyList();
    }

    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel languageModel, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Collections.emptyList();
    }

    protected int getPriorityForId(String id) {
        if (id.equals("TOO_LONG_SENTENCE")) {
            return 10;
        }
        if (id.equals("LANGES_WORT")) {
            return -1;
        }
        return super.getPriorityForId(id);
    }

    public List<String> getRuleFileNames() {
        ArrayList<String> ruleFileNames = new ArrayList<String>();
        String dirBase = JLanguageTool.getDataBroker().getRulesDir() + "/" + this.getShortCode() + "/";
        ruleFileNames.add(dirBase + "grammar.xml");
        return ruleFileNames;
    }
}

