/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.dictionary;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.java.sen.dictionary.Dictionary;
import net.java.sen.dictionary.DictionaryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Morpheme {
    private Dictionary dictionary;
    private int partOfSpeechIndex;
    private LoadState loaded;
    private String conjugationalType = null;
    private String conjugationalForm = null;
    private String basicForm = null;
    private List<String> readings = null;
    private List<String> pronunciations = null;
    private String partOfSpeech = null;
    private String additionalInformation = null;

    private void load(LoadState requested) {
        int length;
        if (this.loaded.compareTo(requested) >= 0) {
            return;
        }
        ByteBuffer buffer = this.dictionary.getPartOfSpeechInfoBuffer();
        buffer.position(this.partOfSpeechIndex);
        char[] temp = new char[512];
        if (this.loaded == LoadState.NONE) {
            this.partOfSpeech = this.dictionary.posIndex[DictionaryUtil.readVInt(buffer)];
            this.conjugationalType = this.dictionary.conjTypeIndex[DictionaryUtil.readVInt(buffer)];
            this.conjugationalForm = this.dictionary.conjFormIndex[DictionaryUtil.readVInt(buffer)];
            length = DictionaryUtil.readVInt(buffer);
            if (length == 0) {
                this.basicForm = "*";
            } else {
                DictionaryUtil.readString(buffer, temp, 0, length);
                this.basicForm = new String(temp, 0, length);
            }
        } else {
            DictionaryUtil.readVInt(buffer);
            DictionaryUtil.readVInt(buffer);
            DictionaryUtil.readVInt(buffer);
            length = DictionaryUtil.readVInt(buffer);
            if (length != 0) {
                DictionaryUtil.readString(buffer, temp, 0, length);
            }
        }
        this.loaded = LoadState.BASIC;
        if (requested == LoadState.FULL) {
            int readingData = DictionaryUtil.readVInt(buffer);
            int numReadings = readingData >>> 1;
            this.readings = new ArrayList<String>(numReadings);
            this.pronunciations = new ArrayList<String>(numReadings);
            for (int i = 0; i < numReadings; ++i) {
                length = DictionaryUtil.readVInt(buffer);
                int readingLength = length >>> 1;
                if ((readingData & 1) == 0) {
                    DictionaryUtil.readKatakana(buffer, temp, 0, readingLength);
                } else {
                    DictionaryUtil.readString(buffer, temp, 0, readingLength);
                }
                String reading = new String(temp, 0, readingLength);
                this.readings.add(reading);
                if ((length & 1) != 0) {
                    int pronunciationLength = DictionaryUtil.readVInt(buffer);
                    if ((readingData & 1) == 0) {
                        DictionaryUtil.readKatakana(buffer, temp, 0, pronunciationLength);
                    } else {
                        DictionaryUtil.readString(buffer, temp, 0, pronunciationLength);
                    }
                    this.pronunciations.add(new String(temp, 0, pronunciationLength));
                    continue;
                }
                this.pronunciations.add(reading);
            }
            this.loaded = LoadState.FULL;
        }
    }

    public String getConjugationalType() {
        this.load(LoadState.BASIC);
        return this.conjugationalType;
    }

    public String getConjugationalForm() {
        this.load(LoadState.BASIC);
        return this.conjugationalForm;
    }

    public String getBasicForm() {
        this.load(LoadState.BASIC);
        return this.basicForm;
    }

    public List<String> getReadings() {
        this.load(LoadState.FULL);
        return this.readings;
    }

    public List<String> getPronunciations() {
        this.load(LoadState.FULL);
        return this.pronunciations;
    }

    public String getPartOfSpeech() {
        this.load(LoadState.BASIC);
        return this.partOfSpeech;
    }

    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    private boolean stringListsEqual(List<String> list1, List<String> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof Morpheme) {
            Morpheme morpheme = (Morpheme)object;
            String partOfSpeech = this.getPartOfSpeech();
            String conjugationalType = this.getConjugationalType();
            String conjugationalForm = this.getConjugationalForm();
            String basicForm = this.getBasicForm();
            List<String> pronunciations = this.getPronunciations();
            List<String> readings = this.getReadings();
            String additionalInformation = this.getAdditionalInformation();
            String otherPartOfSpeech = morpheme.getPartOfSpeech();
            String otherConjugationalType = morpheme.getConjugationalType();
            String otherConjugationalForm = morpheme.getConjugationalForm();
            String otherBasicForm = morpheme.getBasicForm();
            List<String> otherPronunciations = morpheme.getPronunciations();
            List<String> otherReadings = morpheme.getReadings();
            String otherAdditionalInformation = morpheme.getAdditionalInformation();
            if ((basicForm == otherBasicForm || basicForm != null && basicForm.equals(otherBasicForm)) && (conjugationalType == otherConjugationalType || conjugationalType != null && conjugationalType.equals(otherConjugationalType)) && (conjugationalForm == otherConjugationalForm || conjugationalForm != null && conjugationalForm.equals(otherConjugationalForm)) && (partOfSpeech == otherPartOfSpeech || partOfSpeech != null && partOfSpeech.equals(otherPartOfSpeech)) && this.stringListsEqual(pronunciations, otherPronunciations) && this.stringListsEqual(readings, otherReadings) && (additionalInformation == otherAdditionalInformation || additionalInformation != null && additionalInformation.equals(otherAdditionalInformation))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        this.load(LoadState.FULL);
        StringBuilder partOfSpeechData = new StringBuilder();
        String[] parts = this.partOfSpeech.split("-");
        for (int i = 0; i < 4; ++i) {
            if (i < parts.length) {
                partOfSpeechData.append(parts[i]);
            } else {
                partOfSpeechData.append("*");
            }
            partOfSpeechData.append(",");
        }
        partOfSpeechData.append(this.conjugationalType);
        partOfSpeechData.append(",");
        partOfSpeechData.append(this.conjugationalForm);
        partOfSpeechData.append(",");
        partOfSpeechData.append(this.basicForm);
        partOfSpeechData.append(",");
        partOfSpeechData.append(this.readings.size() > 0 ? this.readings.get(0) : "null");
        partOfSpeechData.append(",");
        partOfSpeechData.append(this.pronunciations.size() > 0 ? this.pronunciations.get(0) : "null");
        return partOfSpeechData.toString();
    }

    public Morpheme(Dictionary dictionary, int partOfSpeechIndex) {
        this.dictionary = dictionary;
        this.partOfSpeechIndex = partOfSpeechIndex;
        this.loaded = LoadState.NONE;
    }

    public Morpheme(String partOfSpeech, String conjugationalType, String conjugationalForm, String basicForm, String[] readings, String[] pronunciations, String additionalInformation) {
        this.basicForm = basicForm;
        this.conjugationalType = conjugationalType;
        this.conjugationalForm = conjugationalForm;
        this.readings = new ArrayList<String>(Arrays.asList(readings));
        this.pronunciations = new ArrayList<String>(Arrays.asList(pronunciations));
        this.partOfSpeech = partOfSpeech;
        this.additionalInformation = additionalInformation;
        this.loaded = LoadState.FULL;
    }

    public Morpheme() {
        this.readings = Collections.emptyList();
        this.pronunciations = Collections.emptyList();
        this.loaded = LoadState.FULL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoadState {
        NONE,
        BASIC,
        FULL;

    }
}

