/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveArrayIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.AbstractDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericDataModel
extends AbstractDataModel {
    private static final Logger log = LoggerFactory.getLogger(GenericDataModel.class);
    private final long[] userIDs;
    private final FastByIDMap<PreferenceArray> preferenceFromUsers;
    private final long[] itemIDs;
    private final FastByIDMap<PreferenceArray> preferenceForItems;
    private final FastByIDMap<FastByIDMap<Long>> timestamps;

    public GenericDataModel(FastByIDMap<PreferenceArray> userData) {
        this(userData, null);
    }

    public GenericDataModel(FastByIDMap<PreferenceArray> userData, FastByIDMap<FastByIDMap<Long>> timestamps) {
        Preconditions.checkArgument((userData != null ? 1 : 0) != 0, (Object)"userData is null");
        this.preferenceFromUsers = userData;
        FastByIDMap<Collection<Preference>> prefsForItems = new FastByIDMap<Collection<Preference>>();
        FastIDSet itemIDSet = new FastIDSet();
        int currentCount = 0;
        float maxPrefValue = Float.NEGATIVE_INFINITY;
        float minPrefValue = Float.POSITIVE_INFINITY;
        for (Map.Entry<Long, PreferenceArray> entry : this.preferenceFromUsers.entrySet()) {
            PreferenceArray prefs = entry.getValue();
            prefs.sortByItem();
            for (Preference preference : prefs) {
                long itemID = preference.getItemID();
                itemIDSet.add(itemID);
                ArrayList prefsForItem = prefsForItems.get(itemID);
                if (prefsForItem == null) {
                    prefsForItem = Lists.newArrayListWithCapacity((int)2);
                    prefsForItems.put(itemID, prefsForItem);
                }
                prefsForItem.add(preference);
                float value = preference.getValue();
                if (value > maxPrefValue) {
                    maxPrefValue = value;
                }
                if (!(value < minPrefValue)) continue;
                minPrefValue = value;
            }
            if (++currentCount % 10000 != 0) continue;
            log.info("Processed {} users", (Object)currentCount);
        }
        log.info("Processed {} users", (Object)currentCount);
        this.setMinPreference(minPrefValue);
        this.setMaxPreference(maxPrefValue);
        this.itemIDs = itemIDSet.toArray();
        itemIDSet = null;
        Arrays.sort(this.itemIDs);
        this.preferenceForItems = GenericDataModel.toDataMap(prefsForItems, false);
        for (Map.Entry<Long, PreferenceArray> entry : this.preferenceForItems.entrySet()) {
            entry.getValue().sortByUser();
        }
        this.userIDs = new long[userData.size()];
        int i = 0;
        LongPrimitiveIterator it = userData.keySetIterator();
        while (it.hasNext()) {
            this.userIDs[i++] = (Long)it.next();
        }
        Arrays.sort(this.userIDs);
        this.timestamps = timestamps;
    }

    @Deprecated
    public GenericDataModel(DataModel dataModel) throws TasteException {
        this(GenericDataModel.toDataMap(dataModel));
    }

    public static FastByIDMap<PreferenceArray> toDataMap(FastByIDMap<Collection<Preference>> data, boolean byUser) {
        for (Map.Entry<Long, Collection<Preference>> entry : data.entrySet()) {
            List prefList = (List)entry.getValue();
            entry.setValue((Collection<Preference>)((Object)(byUser ? new GenericUserPreferenceArray(prefList) : new GenericItemPreferenceArray(prefList))));
        }
        return data;
    }

    public static FastByIDMap<PreferenceArray> toDataMap(DataModel dataModel) throws TasteException {
        FastByIDMap<PreferenceArray> data = new FastByIDMap<PreferenceArray>(dataModel.getNumUsers());
        LongPrimitiveIterator it = dataModel.getUserIDs();
        while (it.hasNext()) {
            long userID = it.nextLong();
            data.put(userID, dataModel.getPreferencesFromUser(userID));
        }
        return data;
    }

    public FastByIDMap<PreferenceArray> getRawUserData() {
        return this.preferenceFromUsers;
    }

    public FastByIDMap<PreferenceArray> getRawItemData() {
        return this.preferenceForItems;
    }

    @Override
    public LongPrimitiveArrayIterator getUserIDs() {
        return new LongPrimitiveArrayIterator(this.userIDs);
    }

    @Override
    public PreferenceArray getPreferencesFromUser(long userID) throws NoSuchUserException {
        PreferenceArray prefs = this.preferenceFromUsers.get(userID);
        if (prefs == null) {
            throw new NoSuchUserException(userID);
        }
        return prefs;
    }

    @Override
    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        PreferenceArray prefs = this.getPreferencesFromUser(userID);
        int size = prefs.length();
        FastIDSet result = new FastIDSet(size);
        for (int i = 0; i < size; ++i) {
            result.add(prefs.getItemID(i));
        }
        return result;
    }

    @Override
    public LongPrimitiveArrayIterator getItemIDs() {
        return new LongPrimitiveArrayIterator(this.itemIDs);
    }

    @Override
    public PreferenceArray getPreferencesForItem(long itemID) throws NoSuchItemException {
        PreferenceArray prefs = this.preferenceForItems.get(itemID);
        if (prefs == null) {
            throw new NoSuchItemException(itemID);
        }
        return prefs;
    }

    @Override
    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        PreferenceArray prefs = this.getPreferencesFromUser(userID);
        int size = prefs.length();
        for (int i = 0; i < size; ++i) {
            if (prefs.getItemID(i) != itemID) continue;
            return Float.valueOf(prefs.getValue(i));
        }
        return null;
    }

    @Override
    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        if (this.timestamps == null) {
            return null;
        }
        FastByIDMap<Long> itemTimestamps = this.timestamps.get(userID);
        if (itemTimestamps == null) {
            throw new NoSuchUserException(userID);
        }
        return itemTimestamps.get(itemID);
    }

    @Override
    public int getNumItems() {
        return this.itemIDs.length;
    }

    @Override
    public int getNumUsers() {
        return this.userIDs.length;
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID) {
        PreferenceArray prefs1 = this.preferenceForItems.get(itemID);
        return prefs1 == null ? 0 : prefs1.length();
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) {
        PreferenceArray prefs1 = this.preferenceForItems.get(itemID1);
        if (prefs1 == null) {
            return 0;
        }
        PreferenceArray prefs2 = this.preferenceForItems.get(itemID2);
        if (prefs2 == null) {
            return 0;
        }
        int size1 = prefs1.length();
        int size2 = prefs2.length();
        int count = 0;
        int i = 0;
        int j = 0;
        long userID1 = prefs1.getUserID(0);
        long userID2 = prefs2.getUserID(0);
        while (true) {
            if (userID1 < userID2) {
                if (++i == size1) break;
                userID1 = prefs1.getUserID(i);
                continue;
            }
            if (userID1 > userID2) {
                if (++j == size2) break;
                userID2 = prefs2.getUserID(j);
                continue;
            }
            ++count;
            if (++i == size1 || ++j == size2) break;
            userID1 = prefs1.getUserID(i);
            userID2 = prefs2.getUserID(j);
        }
        return count;
    }

    @Override
    public void removePreference(long userID, long itemID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreference(long userID, long itemID, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    @Override
    public boolean hasPreferenceValues() {
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("GenericDataModel[users:");
        for (int i = 0; i < Math.min(3, this.userIDs.length); ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.userIDs[i]);
        }
        if (this.userIDs.length > 3) {
            result.append("...");
        }
        result.append(']');
        return result.toString();
    }
}

