/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.svd;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorization;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorizer;
import org.apache.mahout.cf.taste.model.DataModel;

public abstract class AbstractFactorizer
implements Factorizer {
    private final DataModel dataModel;
    private FastByIDMap<Integer> userIDMapping;
    private FastByIDMap<Integer> itemIDMapping;
    private final RefreshHelper refreshHelper;

    protected AbstractFactorizer(DataModel dataModel) throws TasteException {
        this.dataModel = dataModel;
        this.buildMappings();
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                AbstractFactorizer.this.buildMappings();
                return null;
            }
        });
        this.refreshHelper.addDependency(dataModel);
    }

    private void buildMappings() throws TasteException {
        this.userIDMapping = AbstractFactorizer.createIDMapping(this.dataModel.getNumUsers(), this.dataModel.getUserIDs());
        this.itemIDMapping = AbstractFactorizer.createIDMapping(this.dataModel.getNumItems(), this.dataModel.getItemIDs());
    }

    protected Factorization createFactorization(double[][] userFeatures, double[][] itemFeatures) {
        return new Factorization(this.userIDMapping, this.itemIDMapping, userFeatures, itemFeatures);
    }

    protected Integer userIndex(long userID) {
        Integer userIndex = this.userIDMapping.get(userID);
        if (userIndex == null) {
            userIndex = this.userIDMapping.size();
            this.userIDMapping.put(userID, userIndex);
        }
        return userIndex;
    }

    protected Integer itemIndex(long itemID) {
        Integer itemIndex = this.itemIDMapping.get(itemID);
        if (itemIndex == null) {
            itemIndex = this.itemIDMapping.size();
            this.itemIDMapping.put(itemID, itemIndex);
        }
        return itemIndex;
    }

    private static FastByIDMap<Integer> createIDMapping(int size, LongPrimitiveIterator idIterator) {
        FastByIDMap<Integer> mapping = new FastByIDMap<Integer>(size);
        int index = 0;
        while (idIterator.hasNext()) {
            mapping.put(idIterator.nextLong(), index++);
        }
        return mapping;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }
}

