/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.vectorizer.common.PartialVectorMerger;
import org.apache.mahout.vectorizer.pruner.PrunedPartialVectorMergeReducer;
import org.apache.mahout.vectorizer.pruner.WordsPrunerReducer;

public final class HighDFWordsPruner {
    public static final String STD_CALC_DIR = "stdcalc";
    public static final String MAX_DF = "max.df";
    public static final String MIN_DF = "min.df";

    private HighDFWordsPruner() {
    }

    public static void pruneVectors(Path tfDir, Path prunedTFDir, Path prunedPartialTFDir, long maxDF, long minDF, Configuration baseConf, Pair<Long[], List<Path>> docFrequenciesFeatures, float normPower, boolean logNormalize, int numReducers) throws IOException, InterruptedException, ClassNotFoundException {
        int partialVectorIndex = 0;
        ArrayList partialVectorPaths = Lists.newArrayList();
        for (Path path : docFrequenciesFeatures.getSecond()) {
            Path partialVectorOutputPath = new Path(prunedPartialTFDir, "partial-" + partialVectorIndex++);
            partialVectorPaths.add(partialVectorOutputPath);
            HighDFWordsPruner.pruneVectorsPartial(tfDir, partialVectorOutputPath, path, maxDF, minDF, baseConf);
        }
        HighDFWordsPruner.mergePartialVectors(partialVectorPaths, prunedTFDir, baseConf, normPower, logNormalize, numReducers);
        HadoopUtil.delete(new Configuration(baseConf), prunedPartialTFDir);
    }

    private static void pruneVectorsPartial(Path input, Path output, Path dictionaryFilePath, long maxDF, long minDF, Configuration baseConf) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration(baseConf);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setLong(MAX_DF, maxDF);
        conf.setLong(MIN_DF, minDF);
        DistributedCache.setCacheFiles((URI[])new URI[]{dictionaryFilePath.toUri()}, (Configuration)conf);
        Job job = HadoopUtil.prepareJob(input, output, SequenceFileInputFormat.class, Mapper.class, null, null, WordsPrunerReducer.class, Text.class, VectorWritable.class, SequenceFileOutputFormat.class, conf);
        job.setJobName(": Prune Vectors: input-folder: " + input + ", dictionary-file: " + dictionaryFilePath.toString());
        HadoopUtil.delete(conf, output);
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
    }

    public static void mergePartialVectors(Iterable<Path> partialVectorPaths, Path output, Configuration baseConf, float normPower, boolean logNormalize, int numReducers) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration(baseConf);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setFloat("normalization.power", normPower);
        conf.setBoolean("vector.lognormalize", logNormalize);
        Job job = new Job(conf);
        job.setJobName("PrunerPartialVectorMerger::MergePartialVectors");
        job.setJarByClass(PartialVectorMerger.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(VectorWritable.class);
        FileInputFormat.setInputPaths((Job)job, (String)HighDFWordsPruner.getCommaSeparatedPaths(partialVectorPaths));
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(Mapper.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setReducerClass(PrunedPartialVectorMergeReducer.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setNumReduceTasks(numReducers);
        HadoopUtil.delete(conf, output);
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
    }

    private static String getCommaSeparatedPaths(Iterable<Path> paths) {
        StringBuilder commaSeparatedPaths = new StringBuilder(100);
        String sep = "";
        for (Path path : paths) {
            commaSeparatedPaths.append(sep).append(path.toString());
            sep = ",";
        }
        return commaSeparatedPaths.toString();
    }
}

