/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.mahout.math.MurmurHash;
import org.apache.mahout.math.Vector;

public abstract class FeatureVectorEncoder {
    protected static final int CONTINUOUS_VALUE_HASH_SEED = 1;
    protected static final int WORD_LIKE_VALUE_HASH_SEED = 100;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final String name;
    private int probes;
    private Map<String, Set<Integer>> traceDictionary;

    protected FeatureVectorEncoder(String name) {
        this(name, 1);
    }

    protected FeatureVectorEncoder(String name, int probes) {
        this.name = name;
        this.probes = probes;
    }

    public void addToVector(String originalForm, Vector data) {
        this.addToVector(originalForm, 1.0, data);
    }

    public void addToVector(byte[] originalForm, Vector data) {
        this.addToVector(originalForm, 1.0, data);
    }

    public void addToVector(String originalForm, double weight, Vector data) {
        this.addToVector(FeatureVectorEncoder.bytesForString(originalForm), weight, data);
    }

    public abstract void addToVector(byte[] var1, double var2, Vector var4);

    protected abstract int hashForProbe(byte[] var1, int var2, String var3, int var4);

    protected Iterable<Integer> hashesForProbe(byte[] originalForm, int dataSize, String name, int probe) {
        return Collections.singletonList(this.hashForProbe(originalForm, dataSize, name, probe));
    }

    protected double getWeight(byte[] originalForm, double w) {
        return 1.0;
    }

    protected int hash(String term, int probe, int numFeatures) {
        long r = MurmurHash.hash64A((byte[])FeatureVectorEncoder.bytesForString(term), (int)probe) % (long)numFeatures;
        if (r < 0L) {
            r += (long)numFeatures;
        }
        return (int)r;
    }

    protected static int hash(byte[] term, int probe, int numFeatures) {
        long r = MurmurHash.hash64A((byte[])term, (int)probe) % (long)numFeatures;
        if (r < 0L) {
            r += (long)numFeatures;
        }
        return (int)r;
    }

    protected static int hash(String term1, String term2, int probe, int numFeatures) {
        long r = MurmurHash.hash64A((byte[])FeatureVectorEncoder.bytesForString(term1), (int)probe);
        r = MurmurHash.hash64A((byte[])FeatureVectorEncoder.bytesForString(term2), (int)((int)r)) % (long)numFeatures;
        if (r < 0L) {
            r += (long)numFeatures;
        }
        return (int)r;
    }

    protected int hash(byte[] term1, byte[] term2, int probe, int numFeatures) {
        long r = MurmurHash.hash64A((byte[])term1, (int)probe);
        if ((r = MurmurHash.hash64A((byte[])term2, (int)((int)r)) % (long)numFeatures) < 0L) {
            r += (long)numFeatures;
        }
        return (int)r;
    }

    protected int hash(String term1, String term2, String term3, String term4, int probe, int numFeatures) {
        long r = MurmurHash.hash64A((byte[])FeatureVectorEncoder.bytesForString(term1), (int)probe);
        r = MurmurHash.hash64A((byte[])FeatureVectorEncoder.bytesForString(term2), (int)((int)r)) % (long)numFeatures;
        r = MurmurHash.hash64A((byte[])FeatureVectorEncoder.bytesForString(term3), (int)((int)r)) % (long)numFeatures;
        r = MurmurHash.hash64A((byte[])FeatureVectorEncoder.bytesForString(term4), (int)((int)r)) % (long)numFeatures;
        if (r < 0L) {
            r += (long)numFeatures;
        }
        return (int)r;
    }

    public abstract String asString(String var1);

    public int getProbes() {
        return this.probes;
    }

    public void setProbes(int probes) {
        this.probes = probes;
    }

    public String getName() {
        return this.name;
    }

    protected boolean isTraceEnabled() {
        return this.traceDictionary != null;
    }

    protected void trace(String subName, int n) {
        if (this.traceDictionary != null) {
            HashSet trace;
            String key = this.name;
            if (subName != null) {
                key = this.name + '=' + subName;
            }
            if ((trace = this.traceDictionary.get(key)) == null) {
                trace = Sets.newHashSet((Object[])new Integer[]{n});
                this.traceDictionary.put(key, trace);
            } else {
                trace.add(n);
            }
        }
    }

    protected void trace(byte[] subName, int n) {
        this.trace(new String(subName, Charsets.UTF_8), n);
    }

    public void setTraceDictionary(Map<String, Set<Integer>> traceDictionary) {
        this.traceDictionary = traceDictionary;
    }

    protected static byte[] bytesForString(String x) {
        return x == null ? EMPTY_ARRAY : x.getBytes(Charsets.UTF_8);
    }
}

