/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.bookcrossing;

import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.neighborhood.NearestNUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.GenericUserBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.CachingUserSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.EuclideanDistanceSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class BookCrossingRecommender
implements Recommender {
    private final Recommender recommender;

    public BookCrossingRecommender(DataModel bcModel) throws TasteException {
        CachingUserSimilarity similarity = new CachingUserSimilarity((UserSimilarity)new EuclideanDistanceSimilarity(bcModel), bcModel);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(10, 0.2, (UserSimilarity)similarity, bcModel, 0.2);
        this.recommender = new GenericUserBasedRecommender(bcModel, (UserNeighborhood)neighborhood, (UserSimilarity)similarity);
    }

    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommender.recommend(userID, howMany);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        return this.recommender.recommend(userID, howMany, rescorer);
    }

    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.recommender.estimatePreference(userID, itemID);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.recommender.setPreference(userID, itemID, value);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.recommender.removePreference(userID, itemID);
    }

    public DataModel getDataModel() {
        return this.recommender.getDataModel();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.recommender.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "BookCrossingRecommender[recommender:" + this.recommender + ']';
    }
}

