/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.mahout.text.LuceneIndexHelper;
import org.apache.mahout.text.LuceneSeqFileHelper;
import org.apache.mahout.text.LuceneStorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFilesFromLuceneStorage {
    private static final Logger log = LoggerFactory.getLogger(SequenceFilesFromLuceneStorage.class);

    public void run(LuceneStorageConfiguration lucene2seqConf) throws IOException {
        List<Path> indexPaths = lucene2seqConf.getIndexPaths();
        int processedDocs = 0;
        for (Path indexPath : indexPaths) {
            FSDirectory directory = FSDirectory.open((File)new File(indexPath.toUri().getPath()));
            DirectoryReader reader = DirectoryReader.open((Directory)directory);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            LuceneIndexHelper.fieldShouldExistInIndex(searcher, lucene2seqConf.getIdField());
            for (String field : lucene2seqConf.getFields()) {
                LuceneIndexHelper.fieldShouldExistInIndex(searcher, field);
            }
            Configuration configuration = lucene2seqConf.getConfiguration();
            FileSystem fileSystem = FileSystem.get((Configuration)configuration);
            Path sequenceFilePath = new Path(lucene2seqConf.getSequenceFilesOutputPath(), indexPath.getName());
            SequenceFile.Writer sequenceFileWriter = new SequenceFile.Writer(fileSystem, configuration, sequenceFilePath, Text.class, Text.class);
            SeqFileWriterCollector writerCollector = new SeqFileWriterCollector(lucene2seqConf, sequenceFileWriter, processedDocs);
            searcher.search(lucene2seqConf.getQuery(), (Collector)writerCollector);
            log.info("Wrote " + writerCollector.processedDocs + " documents in " + sequenceFilePath.toUri());
            processedDocs = writerCollector.processedDocs;
            Closeables.close((Closeable)sequenceFileWriter, (boolean)false);
            directory.close();
            reader.close();
        }
    }

    private static class SeqFileWriterCollector
    extends Collector {
        private final LuceneStorageConfiguration lucene2seqConf;
        private final SequenceFile.Writer sequenceFileWriter;
        public int processedDocs;
        AtomicReaderContext arc;

        SeqFileWriterCollector(LuceneStorageConfiguration lucene2seqConf, SequenceFile.Writer sequenceFileWriter, int processedDocs) {
            this.lucene2seqConf = lucene2seqConf;
            this.sequenceFileWriter = sequenceFileWriter;
            this.processedDocs = processedDocs;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int docNum) throws IOException {
            if (this.processedDocs < this.lucene2seqConf.getMaxHits()) {
                DocumentStoredFieldVisitor storedFieldVisitor = this.lucene2seqConf.getStoredFieldVisitor();
                this.arc.reader().document(docNum, (StoredFieldVisitor)storedFieldVisitor);
                Document doc = storedFieldVisitor.getDocument();
                List<String> fields = this.lucene2seqConf.getFields();
                Text theKey = new Text(Strings.nullToEmpty((String)doc.get(this.lucene2seqConf.getIdField())));
                Text theValue = new Text();
                LuceneSeqFileHelper.populateValues(doc, theValue, fields);
                if (StringUtils.isBlank((String)theKey.toString()) && StringUtils.isBlank((String)theValue.toString())) {
                    return;
                }
                this.sequenceFileWriter.append((Writable)theKey, (Writable)theValue);
                ++this.processedDocs;
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.arc = context;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

