/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSInodeInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;

@InterfaceAudience.Private
public class BlockPlacementPolicyDefault
extends BlockPlacementPolicy {
    protected boolean considerLoad;
    protected NetworkTopology clusterMap;
    private FSClusterStats stats;
    private long staleInterval;

    BlockPlacementPolicyDefault(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        this.initialize(conf, stats, clusterMap);
    }

    BlockPlacementPolicyDefault() {
    }

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        this.considerLoad = conf.getBoolean("dfs.namenode.replication.considerLoad", true);
        this.stats = stats;
        this.clusterMap = clusterMap;
        this.staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
    }

    @Override
    public DatanodeDescriptor[] chooseTarget(String srcPath, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, long blocksize) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, null, blocksize);
    }

    @Override
    public DatanodeDescriptor[] chooseTarget(String srcPath, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, HashMap<Node, Node> excludedNodes, long blocksize) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, excludedNodes, blocksize);
    }

    @Override
    public DatanodeDescriptor[] chooseTarget(FSInodeInfo srcInode, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, long blocksize) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, null, blocksize);
    }

    DatanodeDescriptor[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, HashMap<Node, Node> excludedNodes, long blocksize) {
        if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
            return new DatanodeDescriptor[0];
        }
        if (excludedNodes == null) {
            excludedNodes = new HashMap();
        }
        int clusterSize = this.clusterMap.getNumOfLeaves();
        int totalNumOfReplicas = chosenNodes.size() + numOfReplicas;
        if (totalNumOfReplicas > clusterSize) {
            numOfReplicas -= totalNumOfReplicas - clusterSize;
            totalNumOfReplicas = clusterSize;
        }
        int maxNodesPerRack = (totalNumOfReplicas - 1) / this.clusterMap.getNumOfRacks() + 2;
        ArrayList<DatanodeDescriptor> results = new ArrayList<DatanodeDescriptor>(chosenNodes);
        for (DatanodeDescriptor node : chosenNodes) {
            this.addToExcludedNodes(node, excludedNodes);
            this.adjustExcludedNodes(excludedNodes, node);
        }
        if (!this.clusterMap.contains(writer)) {
            writer = null;
        }
        boolean avoidStaleNodes = this.stats != null && this.stats.shouldAvoidStaleDataNodesForWrite();
        DatanodeDescriptor localNode = this.chooseTarget(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        results.removeAll(chosenNodes);
        return this.getPipeline(writer == null ? localNode : writer, results.toArray(new DatanodeDescriptor[results.size()]));
    }

    private DatanodeDescriptor chooseTarget(int numOfReplicas, DatanodeDescriptor writer, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) {
        block15: {
            boolean newBlock;
            if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
                return writer;
            }
            int totalReplicasExpected = numOfReplicas + results.size();
            int numOfResults = results.size();
            boolean bl = newBlock = numOfResults == 0;
            if (writer == null && !newBlock) {
                writer = results.get(0);
            }
            HashMap<Node, Node> oldExcludedNodes = avoidStaleNodes ? new HashMap<Node, Node>(excludedNodes) : null;
            try {
                if (numOfResults == 0) {
                    writer = this.chooseLocalNode(writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                if (numOfResults <= 1) {
                    this.chooseRemoteRack(1, results.get(0), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                if (numOfResults <= 2) {
                    if (this.clusterMap.isOnSameRack(results.get(0), results.get(1))) {
                        this.chooseRemoteRack(1, results.get(0), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                    } else if (newBlock) {
                        this.chooseLocalRack(results.get(1), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                    } else {
                        this.chooseLocalRack(writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                    }
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                this.chooseRandom(numOfReplicas, "", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
            }
            catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
                FSNamesystem.LOG.warn((Object)("Not able to place enough replicas, still in need of " + (totalReplicasExpected - results.size()) + " to reach " + totalReplicasExpected + "\n" + e.getMessage()));
                if (!avoidStaleNodes) break block15;
                for (DatanodeDescriptor node : results) {
                    oldExcludedNodes.put(node, node);
                }
                numOfReplicas = totalReplicasExpected - results.size();
                return this.chooseTarget(numOfReplicas, writer, oldExcludedNodes, blocksize, maxNodesPerRack, results, false);
            }
        }
        return writer;
    }

    protected DatanodeDescriptor chooseLocalNode(DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
        Node oldNode = excludedNodes.put(localMachine, localMachine);
        if (oldNode == null && this.isGoodTarget(localMachine, blocksize, maxNodesPerRack, false, results, avoidStaleNodes)) {
            results.add(localMachine);
            this.addToExcludedNodes(localMachine, excludedNodes);
            return localMachine;
        }
        return this.chooseLocalRack(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
    }

    protected int addToExcludedNodes(DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes) {
        Node node = excludedNodes.put(localMachine, localMachine);
        return node == null ? 1 : 0;
    }

    protected DatanodeDescriptor chooseLocalRack(DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
        try {
            return this.chooseRandom(localMachine.getNetworkLocation(), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeInfo newLocal = null;
            for (DatanodeDescriptor nextNode : results) {
                if (nextNode == localMachine) continue;
                newLocal = nextNode;
                break;
            }
            if (newLocal != null) {
                try {
                    return this.chooseRandom(newLocal.getNetworkLocation(), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
                }
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes);
        }
    }

    protected void chooseRemoteRack(int numOfReplicas, DatanodeDescriptor localMachine, HashMap<Node, Node> excludedNodes, long blocksize, int maxReplicasPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int oldNumOfReplicas = results.size();
        try {
            this.chooseRandom(numOfReplicas, "~" + localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            this.chooseRandom(numOfReplicas - (results.size() - oldNumOfReplicas), localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes);
        }
    }

    protected DatanodeDescriptor chooseRandom(String nodes, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numOfAvailableNodes = this.clusterMap.countNumOfAvailableNodes(nodes, excludedNodes.keySet());
        while (numOfAvailableNodes > 0) {
            DatanodeDescriptor chosenNode = (DatanodeDescriptor)this.clusterMap.chooseRandom(nodes);
            Node oldNode = excludedNodes.put(chosenNode, chosenNode);
            if (oldNode != null) continue;
            --numOfAvailableNodes;
            if (!this.isGoodTarget(chosenNode, blocksize, maxNodesPerRack, results, avoidStaleNodes)) continue;
            results.add(chosenNode);
            this.addToExcludedNodes(chosenNode, excludedNodes);
            this.adjustExcludedNodes(excludedNodes, chosenNode);
            return chosenNode;
        }
        throw new BlockPlacementPolicy.NotEnoughReplicasException("Not able to place enough replicas");
    }

    protected void chooseRandom(int numOfReplicas, String nodes, HashMap<Node, Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeDescriptor> results, boolean avoidStaleNodes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numOfAvailableNodes = this.clusterMap.countNumOfAvailableNodes(nodes, excludedNodes.keySet());
        while (numOfReplicas > 0 && numOfAvailableNodes > 0) {
            DatanodeDescriptor chosenNode = (DatanodeDescriptor)this.clusterMap.chooseRandom(nodes);
            Node oldNode = excludedNodes.put(chosenNode, chosenNode);
            if (oldNode != null) continue;
            --numOfAvailableNodes;
            if (!this.isGoodTarget(chosenNode, blocksize, maxNodesPerRack, results, avoidStaleNodes)) continue;
            --numOfReplicas;
            results.add(chosenNode);
            int newExcludedNodes = this.addToExcludedNodes(chosenNode, excludedNodes);
            numOfAvailableNodes -= newExcludedNodes;
            this.adjustExcludedNodes(excludedNodes, chosenNode);
        }
        if (numOfReplicas > 0) {
            throw new BlockPlacementPolicy.NotEnoughReplicasException("Not able to place enough replicas");
        }
    }

    protected void adjustExcludedNodes(HashMap<Node, Node> excludedNodes, Node chosenNode) {
    }

    private boolean isGoodTarget(DatanodeDescriptor node, long blockSize, int maxTargetPerLoc, List<DatanodeDescriptor> results, boolean avoidStaleNodes) {
        return this.isGoodTarget(node, blockSize, maxTargetPerLoc, this.considerLoad, results, avoidStaleNodes);
    }

    protected boolean isGoodTarget(DatanodeDescriptor node, long blockSize, int maxTargetPerLoc, boolean considerLoad, List<DatanodeDescriptor> results, boolean avoidStaleNodes) {
        Log logr = FSNamesystem.LOG;
        if (node.isDecommissionInProgress() || node.isDecommissioned()) {
            logr.debug((Object)("Node " + NodeBase.getPath(node) + " is not chosen because the node is (being) decommissioned"));
            return false;
        }
        if (avoidStaleNodes && node.isStale(this.staleInterval)) {
            logr.debug((Object)("Node " + NodeBase.getPath(node) + " is not chosen because the node is (being) stale"));
            return false;
        }
        long remaining = node.getRemaining() - (long)node.getBlocksScheduled() * blockSize;
        if (blockSize * 5L > remaining) {
            logr.debug((Object)("Node " + NodeBase.getPath(node) + " is not chosen because the node does not have enough space"));
            return false;
        }
        if (considerLoad) {
            double avgLoad = 0.0;
            int size = this.clusterMap.getNumOfLeaves();
            if (size != 0 && this.stats != null) {
                avgLoad = (double)this.stats.getTotalLoad() / (double)size;
            }
            if ((double)node.getXceiverCount() > 2.0 * avgLoad) {
                logr.debug((Object)("Node " + NodeBase.getPath(node) + " is not chosen because the node is too busy"));
                return false;
            }
        }
        String rackname = node.getNetworkLocation();
        int counter = 1;
        for (Node node2 : results) {
            if (!rackname.equals(node2.getNetworkLocation())) continue;
            ++counter;
        }
        if (counter > maxTargetPerLoc) {
            logr.debug((Object)("Node " + NodeBase.getPath(node) + " is not chosen because the rack has too many chosen nodes"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatanodeDescriptor[] getPipeline(DatanodeDescriptor writer, DatanodeDescriptor[] nodes) {
        if (nodes.length == 0) {
            return nodes;
        }
        NetworkTopology networkTopology = this.clusterMap;
        synchronized (networkTopology) {
            int index = 0;
            if (writer == null || !this.clusterMap.contains(writer)) {
                writer = nodes[0];
            }
            while (index < nodes.length) {
                DatanodeDescriptor shortestNode = nodes[index];
                int shortestDistance = this.clusterMap.getDistance(writer, shortestNode);
                int shortestIndex = index;
                for (int i = index + 1; i < nodes.length; ++i) {
                    DatanodeDescriptor currentNode = nodes[i];
                    int currentDistance = this.clusterMap.getDistance(writer, currentNode);
                    if (shortestDistance <= currentDistance) continue;
                    shortestDistance = currentDistance;
                    shortestNode = currentNode;
                    shortestIndex = i;
                }
                if (index != shortestIndex) {
                    nodes[shortestIndex] = nodes[index];
                    nodes[index] = shortestNode;
                }
                writer = shortestNode;
                ++index;
            }
        }
        return nodes;
    }

    @Override
    public int verifyBlockPlacement(String srcPath, LocatedBlock lBlk, int minRacks) {
        int numRacks;
        DatanodeInfo[] locs = lBlk.getLocations();
        if (locs == null) {
            locs = new DatanodeInfo[]{};
        }
        if ((numRacks = this.clusterMap.getNumOfRacks()) <= 1) {
            return 0;
        }
        minRacks = Math.min(minRacks, numRacks);
        TreeSet<String> racks = new TreeSet<String>();
        for (DatanodeInfo dn : locs) {
            racks.add(dn.getNetworkLocation());
        }
        return minRacks - racks.size();
    }

    @Override
    public DatanodeDescriptor chooseReplicaToDelete(FSInodeInfo inode, Block block, short replicationFactor, Collection<DatanodeDescriptor> first, Collection<DatanodeDescriptor> second) {
        long minSpace = Long.MAX_VALUE;
        DatanodeDescriptor cur = null;
        Iterator<DatanodeDescriptor> iter = this.pickupReplicaSet(first, second);
        while (iter.hasNext()) {
            DatanodeDescriptor node = iter.next();
            long free = node.getRemaining();
            if (minSpace <= free) continue;
            minSpace = free;
            cur = node;
        }
        return cur;
    }

    protected Iterator<DatanodeDescriptor> pickupReplicaSet(Collection<DatanodeDescriptor> first, Collection<DatanodeDescriptor> second) {
        Iterator<DatanodeDescriptor> iter = first.isEmpty() ? second.iterator() : first.iterator();
        return iter;
    }
}

