/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class DrillDownStream
extends TokenStream {
    private final FacetIndexingParams indexingParams;
    private final Iterator<CategoryPath> categories;
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private CategoryPath current;
    private boolean isParent;

    public DrillDownStream(Iterable<CategoryPath> categories, FacetIndexingParams indexingParams) {
        this.categories = categories.iterator();
        this.indexingParams = indexingParams;
    }

    protected void addAdditionalAttributes(CategoryPath category, boolean isParent) {
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.current.length == 0) {
            if (!this.categories.hasNext()) {
                return false;
            }
            this.current = this.categories.next();
            this.termAttribute.resizeBuffer(this.current.fullPathLength());
            this.isParent = false;
        }
        int nChars = this.indexingParams.drillDownTermText(this.current, this.termAttribute.buffer());
        this.termAttribute.setLength(nChars);
        this.addAdditionalAttributes(this.current, this.isParent);
        this.current = this.current.subpath(this.current.length - 1);
        this.isParent = true;
        return true;
    }

    @Override
    public void reset() throws IOException {
        this.current = this.categories.next();
        this.termAttribute.resizeBuffer(this.current.fullPathLength());
        this.isParent = false;
    }
}

