/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.OrdinalValueResolver;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.PriorityQueue;

public class DepthOneFacetResultsHandler
extends FacetResultsHandler {
    public DepthOneFacetResultsHandler(TaxonomyReader taxonomyReader, FacetRequest facetRequest, FacetArrays facetArrays, OrdinalValueResolver resolver) {
        super(taxonomyReader, facetRequest, resolver, facetArrays);
        assert (facetRequest.getDepth() == 1) : "this handler only computes the top-K facets at depth 1";
        assert (facetRequest.numResults == facetRequest.getNumLabel()) : "this handler always labels all top-K results";
        assert (facetRequest.getSortOrder() == FacetRequest.SortOrder.DESCENDING) : "this handler always sorts results in descending order";
    }

    @Override
    public final FacetResult compute() throws IOException {
        ParallelTaxonomyArrays arrays = this.taxonomyReader.getParallelTaxonomyArrays();
        int[] children = arrays.children();
        int[] siblings = arrays.siblings();
        int rootOrd = this.taxonomyReader.getOrdinal(this.facetRequest.categoryPath);
        FacetResultNode root = new FacetResultNode(rootOrd, this.resolver.valueOf(rootOrd));
        root.label = this.facetRequest.categoryPath;
        if (this.facetRequest.numResults > this.taxonomyReader.getSize()) {
            ArrayList<FacetResultNode> nodes = new ArrayList<FacetResultNode>();
            int ordinal = children[rootOrd];
            while (ordinal != -1) {
                double value = this.resolver.valueOf(ordinal);
                if (value > 0.0) {
                    FacetResultNode node = new FacetResultNode(ordinal, value);
                    node.label = this.taxonomyReader.getPath(ordinal);
                    nodes.add(node);
                }
                ordinal = siblings[ordinal];
            }
            CollectionUtil.introSort(nodes, Collections.reverseOrder(new Comparator<FacetResultNode>(){

                @Override
                public int compare(FacetResultNode o1, FacetResultNode o2) {
                    return o1.compareTo(o2);
                }
            }));
            root.subResults = nodes;
            return new FacetResult(this.facetRequest, root, nodes.size());
        }
        FacetResultNodeQueue pq = new FacetResultNodeQueue(this.facetRequest.numResults, true);
        int ordinal = children[rootOrd];
        FacetResultNode top = (FacetResultNode)pq.top();
        int numSiblings = 0;
        while (ordinal != -1) {
            double value = this.resolver.valueOf(ordinal);
            if (value > 0.0) {
                ++numSiblings;
                if (value > top.value) {
                    top.value = value;
                    top.ordinal = ordinal;
                    top = (FacetResultNode)pq.updateTop();
                }
            }
            ordinal = siblings[ordinal];
        }
        int pqsize = pq.size();
        int size = numSiblings < pqsize ? numSiblings : pqsize;
        for (int i = pqsize - size; i > 0; --i) {
            pq.pop();
        }
        FacetResultNode[] subResults = new FacetResultNode[size];
        for (int i = size - 1; i >= 0; --i) {
            FacetResultNode node = (FacetResultNode)pq.pop();
            node.label = this.taxonomyReader.getPath(node.ordinal);
            subResults[i] = node;
        }
        root.subResults = Arrays.asList(subResults);
        return new FacetResult(this.facetRequest, root, numSiblings);
    }

    private static class FacetResultNodeQueue
    extends PriorityQueue<FacetResultNode> {
        public FacetResultNodeQueue(int maxSize, boolean prepopulate) {
            super(maxSize, prepopulate);
        }

        @Override
        protected FacetResultNode getSentinelObject() {
            return new FacetResultNode(-1, 0.0);
        }

        @Override
        protected boolean lessThan(FacetResultNode a, FacetResultNode b) {
            return a.compareTo(b) < 0;
        }
    }
}

