/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.CountFacetRequest;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public class SortedSetDocValuesAccumulator
extends FacetsAccumulator {
    final SortedSetDocValuesReaderState state;
    final SortedSetDocValues dv;
    final String field;
    final FacetArrays facetArrays;

    public SortedSetDocValuesAccumulator(SortedSetDocValuesReaderState state, FacetSearchParams fsp) throws IOException {
        this(state, fsp, null);
    }

    public SortedSetDocValuesAccumulator(SortedSetDocValuesReaderState state, FacetSearchParams fsp, FacetArrays arrays) throws IOException {
        super(fsp);
        this.state = state;
        this.field = state.getField();
        this.facetArrays = arrays == null ? new FacetArrays(state.getSize()) : arrays;
        this.dv = state.getDocValues();
        for (FacetRequest fr : fsp.facetRequests) {
            if (!(fr instanceof CountFacetRequest)) {
                throw new IllegalArgumentException("this accumulator only supports CountFacetRequest; got " + fr);
            }
            if (fr.categoryPath.length != 1) {
                throw new IllegalArgumentException("this accumulator only supports 1-level CategoryPath; got " + fr.categoryPath);
            }
            if (fr.getDepth() != 1) {
                throw new IllegalArgumentException("this accumulator only supports depth=1; got " + fr.getDepth());
            }
            String dim = fr.categoryPath.components[0];
            SortedSetDocValuesReaderState.OrdRange ordRange = state.getOrdRange(dim);
            if (ordRange != null) continue;
            throw new IllegalArgumentException("dim \"" + dim + "\" does not exist");
        }
    }

    @Override
    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        SortedSetAggregator aggregator = new SortedSetAggregator(this.field, this.state, this.dv);
        for (FacetsCollector.MatchingDocs md : matchingDocs) {
            aggregator.aggregate(md, this.facetArrays);
        }
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        int[] counts = this.facetArrays.getIntArray();
        BytesRef scratch = new BytesRef();
        for (FacetRequest request : this.searchParams.facetRequests) {
            String dim = request.categoryPath.components[0];
            SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
            assert (ordRange != null);
            if (request.numResults >= ordRange.end - ordRange.start + 1) {
                ArrayList<FacetResultNode> nodes = new ArrayList<FacetResultNode>();
                int dimCount = 0;
                for (int ord = ordRange.start; ord <= ordRange.end; ++ord) {
                    if (counts[ord] == 0) continue;
                    dimCount += counts[ord];
                    FacetResultNode node = new FacetResultNode(ord, counts[ord]);
                    this.dv.lookupOrd(ord, scratch);
                    node.label = new CategoryPath(scratch.utf8ToString().split(this.state.separatorRegex, 2));
                    nodes.add(node);
                }
                Collections.sort(nodes, new Comparator<FacetResultNode>(){

                    @Override
                    public int compare(FacetResultNode o1, FacetResultNode o2) {
                        int value = (int)(o2.value - o1.value);
                        if (value == 0) {
                            value = o1.ordinal - o2.ordinal;
                        }
                        return value;
                    }
                });
                CategoryListParams.OrdinalPolicy op = this.searchParams.indexingParams.getCategoryListParams(request.categoryPath).getOrdinalPolicy(dim);
                if (op == CategoryListParams.OrdinalPolicy.ALL_BUT_DIMENSION) {
                    dimCount = 0;
                }
                FacetResultNode rootNode = new FacetResultNode(-1, dimCount);
                rootNode.label = new CategoryPath(dim);
                rootNode.subResults = nodes;
                results.add(new FacetResult(request, rootNode, nodes.size()));
                continue;
            }
            TopCountPQ q = new TopCountPQ(request.numResults);
            int bottomCount = 0;
            int dimCount = 0;
            int childCount = 0;
            FacetResultNode reuse = null;
            for (int ord = ordRange.start; ord <= ordRange.end; ++ord) {
                if (counts[ord] <= 0) continue;
                ++childCount;
                if (counts[ord] <= bottomCount) continue;
                dimCount += counts[ord];
                if (reuse == null) {
                    reuse = new FacetResultNode(ord, counts[ord]);
                } else {
                    reuse.ordinal = ord;
                    reuse.value = counts[ord];
                }
                reuse = q.insertWithOverflow(reuse);
                if (q.size() != request.numResults) continue;
                bottomCount = (int)((FacetResultNode)q.top()).value;
            }
            CategoryListParams.OrdinalPolicy op = this.searchParams.indexingParams.getCategoryListParams(request.categoryPath).getOrdinalPolicy(dim);
            if (op == CategoryListParams.OrdinalPolicy.ALL_BUT_DIMENSION) {
                dimCount = 0;
            }
            FacetResultNode rootNode = new FacetResultNode(-1, dimCount);
            rootNode.label = new CategoryPath(dim);
            FacetResultNode[] childNodes = new FacetResultNode[q.size()];
            for (int i = childNodes.length - 1; i >= 0; --i) {
                childNodes[i] = (FacetResultNode)q.pop();
                this.dv.lookupOrd(childNodes[i].ordinal, scratch);
                childNodes[i].label = new CategoryPath(scratch.utf8ToString().split(this.state.separatorRegex, 2));
            }
            rootNode.subResults = Arrays.asList(childNodes);
            results.add(new FacetResult(request, rootNode, childCount));
        }
        return results;
    }

    @Override
    public boolean requiresDocScores() {
        return false;
    }

    static class SortedSetAggregator {
        private final SortedSetDocValuesReaderState state;
        private final String field;
        private final SortedSetDocValues dv;

        public SortedSetAggregator(String field, SortedSetDocValuesReaderState state, SortedSetDocValues dv) {
            this.field = field;
            this.state = state;
            this.dv = dv;
        }

        public void aggregate(FacetsCollector.MatchingDocs matchingDocs, FacetArrays facetArrays) throws IOException {
            AtomicReader reader = matchingDocs.context.reader();
            if (ReaderUtil.getTopLevelContext(matchingDocs.context).reader() != this.state.origReader) {
                throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
            }
            SortedSetDocValues segValues = reader.getSortedSetDocValues(this.field);
            if (segValues == null) {
                return;
            }
            int[] counts = facetArrays.getIntArray();
            int maxDoc = reader.maxDoc();
            assert (maxDoc == matchingDocs.bits.length());
            if (this.dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                MultiDocValues.OrdinalMap ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping;
                int segOrd = matchingDocs.context.ord;
                int numSegOrds = (int)segValues.getValueCount();
                if (matchingDocs.totalHits < numSegOrds / 10) {
                    for (int doc = 0; doc < maxDoc && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
                        segValues.setDocument(doc);
                        int term = (int)segValues.nextOrd();
                        while ((long)term != -1L) {
                            int n = (int)ordinalMap.getGlobalOrd(segOrd, term);
                            counts[n] = counts[n] + 1;
                            term = (int)segValues.nextOrd();
                        }
                    }
                } else {
                    int[] segCounts = new int[numSegOrds];
                    for (int doc = 0; doc < maxDoc && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
                        segValues.setDocument(doc);
                        int term = (int)segValues.nextOrd();
                        while ((long)term != -1L) {
                            int n = term;
                            segCounts[n] = segCounts[n] + 1;
                            term = (int)segValues.nextOrd();
                        }
                    }
                    for (int ord = 0; ord < numSegOrds; ++ord) {
                        int count = segCounts[ord];
                        if (count == 0) continue;
                        int n = (int)ordinalMap.getGlobalOrd(segOrd, ord);
                        counts[n] = counts[n] + count;
                    }
                }
            } else {
                for (int doc = 0; doc < maxDoc && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
                    segValues.setDocument(doc);
                    int term = (int)segValues.nextOrd();
                    while ((long)term != -1L) {
                        int n = term;
                        counts[n] = counts[n] + 1;
                        term = (int)segValues.nextOrd();
                    }
                }
            }
        }
    }

    static class TopCountPQ
    extends PriorityQueue<FacetResultNode> {
        public TopCountPQ(int topN) {
            super(topN, false);
        }

        @Override
        protected boolean lessThan(FacetResultNode a, FacetResultNode b) {
            if (a.value < b.value) {
                return true;
            }
            if (a.value > b.value) {
                return false;
            }
            return a.ordinal > b.ordinal;
        }
    }
}

