/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.PriorityQueue;
import org.apache.mahout.cf.taste.hadoop.MutableRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public class TopItemsQueue
extends PriorityQueue<MutableRecommendedItem> {
    private static final long SENTINEL_ID = Long.MIN_VALUE;
    private final int maxSize;

    public TopItemsQueue(int maxSize) {
        super(maxSize);
        this.maxSize = maxSize;
    }

    public List<RecommendedItem> getTopItems() {
        ArrayList<RecommendedItem> recommendedItems = Lists.newArrayListWithCapacity(this.maxSize);
        while (this.size() > 0) {
            MutableRecommendedItem topItem = (MutableRecommendedItem)this.pop();
            if (topItem.getItemID() == Long.MIN_VALUE) continue;
            recommendedItems.add(topItem);
        }
        Collections.reverse(recommendedItems);
        return recommendedItems;
    }

    @Override
    protected boolean lessThan(MutableRecommendedItem one, MutableRecommendedItem two) {
        return one.getValue() < two.getValue();
    }

    @Override
    protected MutableRecommendedItem getSentinelObject() {
        return new MutableRecommendedItem(Long.MIN_VALUE, Float.MIN_VALUE);
    }
}

