/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.web;

import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecommenderWrapper
implements Recommender {
    private static final Logger log = LoggerFactory.getLogger(RecommenderWrapper.class);
    private final Recommender delegate = this.buildRecommender();

    protected RecommenderWrapper() throws TasteException, IOException {
    }

    protected abstract Recommender buildRecommender() throws IOException, TasteException;

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.delegate.recommend(userID, howMany);
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        return this.delegate.recommend(userID, howMany, rescorer);
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.delegate.estimatePreference(userID, itemID);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.delegate.setPreference(userID, itemID, value);
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        this.delegate.removePreference(userID, itemID);
    }

    @Override
    public DataModel getDataModel() {
        return this.delegate.getDataModel();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.delegate.refresh(alreadyRefreshed);
    }

    public static File readResourceToTempFile(String resourceName) throws IOException {
        InputSupplier<InputStream> inSupplier;
        String absoluteResource = resourceName.startsWith("/") ? resourceName : '/' + resourceName;
        log.info("Loading resource {}", (Object)absoluteResource);
        try {
            URL resourceURL = Resources.getResource(RecommenderWrapper.class, absoluteResource);
            inSupplier = Resources.newInputStreamSupplier(resourceURL);
        }
        catch (IllegalArgumentException iae) {
            File resourceFile = new File(resourceName);
            log.info("Falling back to load file {}", (Object)resourceFile.getAbsolutePath());
            inSupplier = Files.newInputStreamSupplier(resourceFile);
        }
        File tempFile = File.createTempFile("taste", null);
        tempFile.deleteOnExit();
        Files.copy(inSupplier, tempFile);
        return tempFile;
    }
}

