/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import org.apache.mahout.classifier.naivebayes.AbstractNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;

public class StandardNaiveBayesClassifier
extends AbstractNaiveBayesClassifier {
    public StandardNaiveBayesClassifier(NaiveBayesModel model) {
        super(model);
    }

    @Override
    public double getScoreForLabelFeature(int label, int feature) {
        NaiveBayesModel model = this.getModel();
        return StandardNaiveBayesClassifier.computeWeight(model.weight(label, feature), model.labelWeight(label), model.alphaI(), model.numFeatures());
    }

    public static double computeWeight(double featureLabelWeight, double labelWeight, double alphaI, double numFeatures) {
        double numerator = featureLabelWeight + alphaI;
        double denominator = labelWeight + alphaI * numFeatures;
        return Math.log(numerator / denominator);
    }
}

