/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Map;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

public class SparseMatrix
extends AbstractMatrix {
    private OpenIntObjectHashMap<Vector> rowVectors = new OpenIntObjectHashMap();

    public SparseMatrix(int rows, int columns, Map<Integer, RandomAccessSparseVector> rowVectors) {
        super(rows, columns);
        for (Map.Entry<Integer, RandomAccessSparseVector> entry : rowVectors.entrySet()) {
            this.rowVectors.put(entry.getKey(), entry.getValue().clone());
        }
    }

    public SparseMatrix(int rows, int columns) {
        super(rows, columns);
    }

    @Override
    public Matrix clone() {
        SparseMatrix clone = (SparseMatrix)super.clone();
        clone.rowVectors = this.rowVectors.clone();
        for (int i = 0; i < this.numRows(); ++i) {
            clone.rowVectors.put(i, this.rowVectors.get(i).clone());
        }
        return clone;
    }

    @Override
    public Iterator<MatrixSlice> iterator() {
        final IntArrayList keys = new IntArrayList(this.rowVectors.size());
        this.rowVectors.keys(keys);
        return new AbstractIterator<MatrixSlice>(){
            private int slice;

            @Override
            protected MatrixSlice computeNext() {
                if (this.slice >= SparseMatrix.this.rowVectors.size()) {
                    return (MatrixSlice)this.endOfData();
                }
                int i = keys.get(this.slice);
                Vector row = (Vector)SparseMatrix.this.rowVectors.get(i);
                ++this.slice;
                return new MatrixSlice(row, i);
            }
        };
    }

    @Override
    public double getQuick(int row, int column) {
        Vector r = this.rowVectors.get(row);
        return r == null ? 0.0 : r.getQuick(column);
    }

    @Override
    public Matrix like() {
        return new SparseMatrix(this.rowSize(), this.columnSize());
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new SparseMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        Vector r = this.rowVectors.get(row);
        if (r == null) {
            r = new RandomAccessSparseVector(this.columnSize());
            this.rowVectors.put(row, r);
        }
        r.setQuick(column, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        int[] result = new int[2];
        result[0] = this.rowVectors.size();
        for (Vector vectorEntry : this.rowVectors.values()) {
            result[1] = Math.max(result[1], vectorEntry.getNumNondefaultElements());
        }
        return result;
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        if (offset[0] < 0) {
            throw new IndexException(offset[0], this.rowSize());
        }
        if (offset[0] + size[0] > this.rowSize()) {
            throw new IndexException(offset[0] + size[0], this.rowSize());
        }
        if (offset[1] < 0) {
            throw new IndexException(offset[1], this.columnSize());
        }
        if (offset[1] + size[1] > this.columnSize()) {
            throw new IndexException(offset[1] + size[1], this.columnSize());
        }
        return new MatrixView(this, offset, size);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (this.rowSize() != other.size()) {
            throw new CardinalityException(this.rowSize(), other.size());
        }
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        for (int row = 0; row < this.rowSize(); ++row) {
            double val = other.getQuick(row);
            if (val == 0.0) continue;
            Vector r = this.rowVectors.get(row);
            if (r == null) {
                r = new RandomAccessSparseVector(this.columnSize());
                this.rowVectors.put(row, r);
            }
            r.setQuick(column, val);
        }
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        if (this.columnSize() != other.size()) {
            throw new CardinalityException(this.columnSize(), other.size());
        }
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        this.rowVectors.put(row, other);
        return this;
    }

    @Override
    public Vector viewRow(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        Vector res = this.rowVectors.get(row);
        if (res == null) {
            res = new RandomAccessSparseVector(this.columnSize());
            this.rowVectors.put(row, res);
        }
        return res;
    }
}

