/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.ssvd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.mahout.math.CholeskyDecomposition;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.RandomTrinaryMatrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class SequentialOutOfCoreSvd {
    private final CholeskyDecomposition l2;
    private final SingularValueDecomposition svd;
    private final CholeskyDecomposition r2;
    private final int columnsPerSlice;
    private final int seed;
    private final int dim;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequentialOutOfCoreSvd(Iterable<File> partsOfA, File tmpDir, int internalDimension, int columnsPerSlice) throws IOException {
        DataInputStream in;
        this.columnsPerSlice = columnsPerSlice;
        this.dim = internalDimension;
        this.seed = 1;
        Matrix y2 = null;
        for (File file : partsOfA) {
            MatrixWritable m = new MatrixWritable();
            DataInputStream in2 = new DataInputStream(new FileInputStream(file));
            try {
                m.readFields(in2);
            }
            finally {
                in2.close();
            }
            Matrix aI = m.get();
            RandomTrinaryMatrix omega = new RandomTrinaryMatrix(this.seed, aI.columnSize(), internalDimension, false);
            Matrix y = aI.times(omega);
            if (y2 == null) {
                y2 = y.transpose().times(y);
                continue;
            }
            y2.assign(y.transpose().times(y), Functions.PLUS);
        }
        this.r2 = new CholeskyDecomposition(y2);
        int ncols = 0;
        for (File file : partsOfA) {
            MatrixWritable m = new MatrixWritable();
            in = new DataInputStream(new FileInputStream(file));
            try {
                m.readFields(in);
            }
            finally {
                in.close();
            }
            Matrix aI = m.get();
            ncols = Math.max(ncols, aI.columnSize());
            RandomTrinaryMatrix omega = new RandomTrinaryMatrix(this.seed, aI.numCols(), internalDimension, false);
            for (int j = 0; j < aI.numCols(); j += columnsPerSlice) {
                Matrix yI = aI.times(omega);
                Matrix aIJ = aI.viewPart(0, aI.rowSize(), j, Math.min(columnsPerSlice, aI.columnSize() - j));
                Matrix bIJ = this.r2.solveRight(yI).transpose().times(aIJ);
                SequentialOutOfCoreSvd.addToSavedCopy(SequentialOutOfCoreSvd.bFile(tmpDir, j), bIJ);
            }
        }
        DenseMatrix b2 = new DenseMatrix(internalDimension, internalDimension);
        MatrixWritable bTmp = new MatrixWritable();
        for (int j = 0; j < ncols; j += columnsPerSlice) {
            if (!SequentialOutOfCoreSvd.bFile(tmpDir, j).exists()) continue;
            in = new DataInputStream(new FileInputStream(SequentialOutOfCoreSvd.bFile(tmpDir, j)));
            try {
                bTmp.readFields(in);
            }
            finally {
                in.close();
            }
            b2.assign(bTmp.get().times(bTmp.get().transpose()), Functions.PLUS);
        }
        this.l2 = new CholeskyDecomposition(b2);
        this.svd = new SingularValueDecomposition(this.l2.getL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeV(File tmpDir, int ncols) throws IOException {
        for (int j = 0; j < ncols; j += this.columnsPerSlice) {
            File bPath = SequentialOutOfCoreSvd.bFile(tmpDir, j);
            if (!bPath.exists()) continue;
            MatrixWritable m = new MatrixWritable();
            DataInputStream in = new DataInputStream(new FileInputStream(bPath));
            try {
                m.readFields(in);
            }
            finally {
                in.close();
            }
            m.set(this.l2.solveRight(m.get().transpose()).times(this.svd.getV()));
            DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(tmpDir, String.format("V-%s", bPath.getName().replaceAll(".*-", "")))));
            try {
                m.write(out);
                continue;
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeU(Iterable<File> partsOfA, File tmpDir) throws IOException {
        for (File file : partsOfA) {
            MatrixWritable m = new MatrixWritable();
            m.readFields(new DataInputStream(new FileInputStream(file)));
            Matrix aI = m.get();
            Matrix y = aI.times(new RandomTrinaryMatrix(this.seed, aI.numCols(), this.dim, false));
            Matrix uI = this.r2.solveRight(y).times(this.svd.getU());
            m.set(uI);
            DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(tmpDir, String.format("U-%s", file.getName().replaceAll(".*-", "")))));
            try {
                m.write(out);
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToSavedCopy(File file, Matrix matrix) throws IOException {
        MatrixWritable mw = new MatrixWritable();
        if (file.exists()) {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            try {
                mw.readFields(in);
            }
            finally {
                in.close();
            }
            mw.get().assign(matrix, Functions.PLUS);
        } else {
            mw.set(matrix);
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
        try {
            mw.write(out);
        }
        finally {
            out.close();
        }
    }

    private static File bFile(File tmpDir, int j) {
        return new File(tmpDir, String.format("B-%09d", j));
    }

    public Vector getSingularValues() {
        return new DenseVector(this.svd.getSingularValues());
    }
}

