/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.arff.ARFFModel;

final class ARFFIterator
extends AbstractIterator<Vector> {
    private static final Pattern WORDS_WITHOUT_SPARSE = Pattern.compile("([\\w[^{]])*");
    private static final Pattern DATA_PATTERN = Pattern.compile("^\\{(.*)\\}$");
    private final BufferedReader reader;
    private final ARFFModel model;

    ARFFIterator(BufferedReader reader, ARFFModel model) {
        this.reader = reader;
        this.model = model;
    }

    @Override
    protected Vector computeNext() {
        AbstractVector result;
        String line;
        try {
            while ((line = this.reader.readLine()) != null && ((line = line.trim()).isEmpty() || line.startsWith("%"))) {
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        if (line == null) {
            try {
                Closeables.close(this.reader, true);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return (Vector)this.endOfData();
        }
        Matcher contents = DATA_PATTERN.matcher(line);
        if (contents.find()) {
            line = contents.group(1);
            String[] splits = ARFFIterator.splitCSV(line);
            result = new RandomAccessSparseVector(this.model.getLabelSize());
            for (String split : splits) {
                int idIndex = split.indexOf(32);
                int idx = Integer.parseInt(split.substring(0, idIndex).trim());
                String data = split.substring(idIndex).trim();
                if ("?".equals(data)) continue;
                result.setQuick(idx, this.model.getValue(data, idx));
            }
        } else {
            result = new DenseVector(this.model.getLabelSize());
            String[] splits = ARFFIterator.splitCSV(line);
            for (int i = 0; i < splits.length; ++i) {
                String split = splits[i];
                if (!WORDS_WITHOUT_SPARSE.matcher(split = split.trim()).matches() || "?".equals(split)) continue;
                result.setQuick(i, this.model.getValue(split, i));
            }
        }
        return result;
    }

    public static String[] splitCSV(String line) {
        StringBuilder sb = new StringBuilder(128);
        ArrayList<String> tokens = Lists.newArrayList();
        char escapeChar = '\u0000';
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                sb.append(line.charAt(++i));
                continue;
            }
            if (c == '\"' || c == '\'') {
                if (c == escapeChar) {
                    escapeChar = '\u0000';
                } else if (escapeChar == '\u0000') {
                    escapeChar = c;
                }
                sb.append(c);
                continue;
            }
            if (c == ',') {
                if (escapeChar == '\u0000') {
                    tokens.add(sb.toString().trim());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            tokens.add(sb.toString().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

