/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import org.apache.mahout.common.RandomUtils;

class TermInfoClusterInOut
implements Comparable<TermInfoClusterInOut> {
    private final String term;
    private final int inClusterDF;
    private final int outClusterDF;
    private final double logLikelihoodRatio;

    TermInfoClusterInOut(String term, int inClusterDF, int outClusterDF, double logLikelihoodRatio) {
        this.term = term;
        this.inClusterDF = inClusterDF;
        this.outClusterDF = outClusterDF;
        this.logLikelihoodRatio = logLikelihoodRatio;
    }

    public int hashCode() {
        return this.term.hashCode() ^ this.inClusterDF ^ this.outClusterDF ^ RandomUtils.hashDouble(this.logLikelihoodRatio);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermInfoClusterInOut)) {
            return false;
        }
        TermInfoClusterInOut other = (TermInfoClusterInOut)o;
        return this.term.equals(other.getTerm()) && this.inClusterDF == other.getInClusterDF() && this.outClusterDF == other.getOutClusterDF() && this.logLikelihoodRatio == other.getLogLikelihoodRatio();
    }

    @Override
    public int compareTo(TermInfoClusterInOut that) {
        int res = Double.compare(that.logLikelihoodRatio, this.logLikelihoodRatio);
        if (res == 0) {
            res = this.term.compareTo(that.term);
        }
        return res;
    }

    public int getInClusterDiff() {
        return this.inClusterDF - this.outClusterDF;
    }

    String getTerm() {
        return this.term;
    }

    int getInClusterDF() {
        return this.inClusterDF;
    }

    int getOutClusterDF() {
        return this.outClusterDF;
    }

    double getLogLikelihoodRatio() {
        return this.logLikelihoodRatio;
    }
}

