/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.lucene.util.PriorityQueue;
import org.apache.mahout.cf.taste.hadoop.item.VectorOrPrefWritable;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserVectorSplitterMapper
extends Mapper<VarLongWritable, VectorWritable, VarIntWritable, VectorOrPrefWritable> {
    private static final Logger log = LoggerFactory.getLogger(UserVectorSplitterMapper.class);
    static final String USERS_FILE = "usersFile";
    static final String MAX_PREFS_PER_USER_CONSIDERED = "maxPrefsPerUserConsidered";
    static final int DEFAULT_MAX_PREFS_PER_USER_CONSIDERED = 10;
    private int maxPrefsPerUserConsidered;
    private FastIDSet usersToRecommendFor;
    private final VarIntWritable itemIndexWritable = new VarIntWritable();
    private final VectorOrPrefWritable vectorOrPref = new VectorOrPrefWritable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup(Mapper.Context context) throws IOException {
        Configuration jobConf = context.getConfiguration();
        this.maxPrefsPerUserConsidered = jobConf.getInt(MAX_PREFS_PER_USER_CONSIDERED, 10);
        String usersFilePathString = jobConf.get(USERS_FILE);
        if (usersFilePathString != null) {
            FSDataInputStream in = null;
            try {
                Path unqualifiedUsersFilePath = new Path(usersFilePathString);
                FileSystem fs = FileSystem.get((URI)unqualifiedUsersFilePath.toUri(), (Configuration)jobConf);
                this.usersToRecommendFor = new FastIDSet();
                Path usersFilePath = unqualifiedUsersFilePath.makeQualified(fs);
                in = fs.open(usersFilePath);
                for (String line : new FileLineIterable((InputStream)in)) {
                    try {
                        this.usersToRecommendFor.add(Long.parseLong(line));
                    }
                    catch (NumberFormatException nfe) {
                        log.warn("usersFile line ignored: {}", (Object)line);
                    }
                }
            }
            catch (Throwable throwable) {
                Closeables.close(in, true);
                throw throwable;
            }
            Closeables.close((Closeable)in, true);
        }
    }

    protected void map(VarLongWritable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        long userID = key.get();
        if (this.usersToRecommendFor != null && !this.usersToRecommendFor.contains(userID)) {
            return;
        }
        Vector userVector = this.maybePruneUserVector(value.get());
        for (Vector.Element e : userVector.nonZeroes()) {
            this.itemIndexWritable.set(e.index());
            this.vectorOrPref.set(userID, (float)e.get());
            context.write((Object)this.itemIndexWritable, (Object)this.vectorOrPref);
        }
    }

    private Vector maybePruneUserVector(Vector userVector) {
        if (userVector.getNumNondefaultElements() <= this.maxPrefsPerUserConsidered) {
            return userVector;
        }
        float smallestLargeValue = this.findSmallestLargeValue(userVector);
        for (Vector.Element e : userVector.nonZeroes()) {
            float absValue = Math.abs((float)e.get());
            if (!(absValue < smallestLargeValue)) continue;
            e.set(Double.NaN);
        }
        return userVector;
    }

    private float findSmallestLargeValue(Vector userVector) {
        PriorityQueue<Float> topPrefValues = new PriorityQueue<Float>(this.maxPrefsPerUserConsidered){

            @Override
            protected boolean lessThan(Float f1, Float f2) {
                return f1.floatValue() < f2.floatValue();
            }
        };
        for (Vector.Element e : userVector.nonZeroes()) {
            float absValue = Math.abs((float)e.get());
            topPrefValues.insertWithOverflow(Float.valueOf(absValue));
        }
        return ((Float)topPrefValues.top()).floatValue();
    }
}

