/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator.sequencefile;

import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SequenceFileValueIterator<V extends Writable>
extends AbstractIterator<V>
implements Closeable {
    private final SequenceFile.Reader reader;
    private final Configuration conf;
    private final Class<V> valueClass;
    private final Writable key;
    private V value = null;
    private final boolean reuseKeyValueInstances;
    private static final Logger log = LoggerFactory.getLogger(SequenceFileValueIterator.class);

    public SequenceFileValueIterator(Path path, boolean reuseKeyValueInstances, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        path = path.makeQualified(fs);
        this.reader = new SequenceFile.Reader(fs, path, conf);
        this.conf = conf;
        Class keyClass = this.reader.getKeyClass();
        this.key = (Writable)ReflectionUtils.newInstance((Class)keyClass, (Configuration)conf);
        this.valueClass = this.reader.getValueClass();
        this.reuseKeyValueInstances = reuseKeyValueInstances;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    public void close() throws IOException {
        this.value = null;
        Closeables.close((Closeable)this.reader, true);
        this.endOfData();
    }

    @Override
    protected V computeNext() {
        if (!this.reuseKeyValueInstances || this.value == null) {
            this.value = (Writable)ReflectionUtils.newInstance(this.valueClass, (Configuration)this.conf);
        }
        try {
            boolean available = this.reader.next(this.key, this.value);
            if (!available) {
                this.close();
                return null;
            }
            return this.value;
        }
        catch (IOException ioe) {
            try {
                this.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
            throw new IllegalStateException(ioe);
        }
    }
}

