/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.net.NodeBase;

public abstract class CombineFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    private long maxSplitSize = 0L;
    private long minSplitSizeNode = 0L;
    private long minSplitSizeRack = 0L;
    private ArrayList<MultiPathFilter> pools = new ArrayList();
    private HashMap<String, Set<String>> rackToNodes = new HashMap();

    protected void setMaxSplitSize(long maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    protected void setMinSplitSizeNode(long minSplitSizeNode) {
        this.minSplitSizeNode = minSplitSizeNode;
    }

    protected void setMinSplitSizeRack(long minSplitSizeRack) {
        this.minSplitSizeRack = minSplitSizeRack;
    }

    protected void createPool(JobConf conf, List<PathFilter> filters) {
        this.pools.add(new MultiPathFilter(filters));
    }

    protected void createPool(JobConf conf, PathFilter ... filters) {
        MultiPathFilter multi = new MultiPathFilter();
        for (PathFilter f : filters) {
            multi.add(f);
        }
        this.pools.add(multi);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        long minSizeNode = 0L;
        long minSizeRack = 0L;
        long maxSize = 0L;
        minSizeNode = this.minSplitSizeNode != 0L ? this.minSplitSizeNode : job.getLong("mapred.min.split.size.per.node", 0L);
        minSizeRack = this.minSplitSizeRack != 0L ? this.minSplitSizeRack : job.getLong("mapred.min.split.size.per.rack", 0L);
        maxSize = this.maxSplitSize != 0L ? this.maxSplitSize : job.getLong("mapred.max.split.size", 0L);
        if (minSizeNode != 0L && maxSize != 0L && minSizeNode > maxSize) {
            throw new IOException("Minimum split size pernode " + minSizeNode + " cannot be larger than maximum split size " + maxSize);
        }
        if (minSizeRack != 0L && maxSize != 0L && minSizeRack > maxSize) {
            throw new IOException("Minimum split size per rack" + minSizeRack + " cannot be larger than maximum split size " + maxSize);
        }
        if (minSizeRack != 0L && minSizeNode > minSizeRack) {
            throw new IOException("Minimum split size per node" + minSizeNode + " cannot be smaller than minimum split size per rack " + minSizeRack);
        }
        Path[] paths = FileUtil.stat2Paths(this.listStatus(job));
        ArrayList<CombineFileSplit> splits = new ArrayList<CombineFileSplit>();
        if (paths.length == 0) {
            return splits.toArray(new CombineFileSplit[splits.size()]);
        }
        for (MultiPathFilter onepool : this.pools) {
            ArrayList<Path> myPaths = new ArrayList<Path>();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) continue;
                FileSystem fs = paths[i].getFileSystem(job);
                Path p = new Path(paths[i].toUri().getPath());
                if (!onepool.accept(p)) continue;
                myPaths.add(paths[i]);
                paths[i] = null;
            }
            this.getMoreSplits(job, myPaths.toArray(new Path[myPaths.size()]), maxSize, minSizeNode, minSizeRack, splits);
        }
        ArrayList<Path> myPaths = new ArrayList<Path>();
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] == null) continue;
            myPaths.add(paths[i]);
        }
        this.getMoreSplits(job, myPaths.toArray(new Path[myPaths.size()]), maxSize, minSizeNode, minSizeRack, splits);
        this.rackToNodes.clear();
        return splits.toArray(new CombineFileSplit[splits.size()]);
    }

    private void getMoreSplits(JobConf job, Path[] paths, long maxSize, long minSizeNode, long minSizeRack, List<CombineFileSplit> splits) throws IOException {
        HashMap<String, List<OneBlockInfo>> rackToBlocks = new HashMap<String, List<OneBlockInfo>>();
        HashMap<OneBlockInfo, String[]> blockToNodes = new HashMap<OneBlockInfo, String[]>();
        HashMap<String, List<OneBlockInfo>> nodeToBlocks = new HashMap<String, List<OneBlockInfo>>();
        OneFileInfo[] files = new OneFileInfo[paths.length];
        if (paths.length == 0) {
            return;
        }
        long totLength = 0L;
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new OneFileInfo(paths[i], job, rackToBlocks, blockToNodes, nodeToBlocks, this.rackToNodes);
            totLength += files[i].getLength();
        }
        ArrayList<OneBlockInfo> validBlocks = new ArrayList<OneBlockInfo>();
        ArrayList<String> nodes = new ArrayList<String>();
        long curSplitSize = 0L;
        for (Map.Entry one : nodeToBlocks.entrySet()) {
            nodes.add((String)one.getKey());
            List blocksInNode = (List)one.getValue();
            for (OneBlockInfo oneblock : blocksInNode) {
                if (!blockToNodes.containsKey(oneblock)) continue;
                validBlocks.add(oneblock);
                blockToNodes.remove(oneblock);
                if (maxSize == 0L || (curSplitSize += oneblock.length) < maxSize) continue;
                this.addCreatedSplit(job, splits, nodes, validBlocks);
                curSplitSize = 0L;
                validBlocks.clear();
            }
            if (minSizeNode != 0L && curSplitSize >= minSizeNode) {
                this.addCreatedSplit(job, splits, nodes, validBlocks);
            } else {
                for (OneBlockInfo oneblock : validBlocks) {
                    blockToNodes.put(oneblock, oneblock.hosts);
                }
            }
            validBlocks.clear();
            nodes.clear();
            curSplitSize = 0L;
        }
        ArrayList<OneBlockInfo> overflowBlocks = new ArrayList<OneBlockInfo>();
        ArrayList<String> racks = new ArrayList<String>();
        while (blockToNodes.size() > 0) {
            for (Map.Entry<String, List<OneBlockInfo>> one : rackToBlocks.entrySet()) {
                racks.add(one.getKey());
                List<OneBlockInfo> blocks = one.getValue();
                boolean createdSplit = false;
                for (OneBlockInfo oneblock : blocks) {
                    if (!blockToNodes.containsKey(oneblock)) continue;
                    validBlocks.add(oneblock);
                    blockToNodes.remove(oneblock);
                    if (maxSize == 0L || (curSplitSize += oneblock.length) < maxSize) continue;
                    this.addCreatedSplit(job, splits, this.getHosts(racks), validBlocks);
                    createdSplit = true;
                    break;
                }
                if (createdSplit) {
                    curSplitSize = 0L;
                    validBlocks.clear();
                    racks.clear();
                    continue;
                }
                if (!validBlocks.isEmpty()) {
                    if (minSizeRack != 0L && curSplitSize >= minSizeRack) {
                        this.addCreatedSplit(job, splits, this.getHosts(racks), validBlocks);
                    } else {
                        overflowBlocks.addAll(validBlocks);
                    }
                }
                curSplitSize = 0L;
                validBlocks.clear();
                racks.clear();
            }
        }
        assert (blockToNodes.isEmpty());
        assert (curSplitSize == 0L);
        assert (validBlocks.isEmpty());
        assert (racks.isEmpty());
        for (OneBlockInfo oneblock : overflowBlocks) {
            validBlocks.add(oneblock);
            curSplitSize += oneblock.length;
            for (int i = 0; i < oneblock.racks.length; ++i) {
                racks.add(oneblock.racks[i]);
            }
            if (maxSize == 0L || curSplitSize < maxSize) continue;
            this.addCreatedSplit(job, splits, this.getHosts(racks), validBlocks);
            curSplitSize = 0L;
            validBlocks.clear();
            racks.clear();
        }
        if (!validBlocks.isEmpty()) {
            this.addCreatedSplit(job, splits, this.getHosts(racks), validBlocks);
        }
    }

    private void addCreatedSplit(JobConf job, List<CombineFileSplit> splitList, List<String> locations, ArrayList<OneBlockInfo> validBlocks) {
        Path[] fl = new Path[validBlocks.size()];
        long[] offset = new long[validBlocks.size()];
        long[] length = new long[validBlocks.size()];
        for (int i = 0; i < validBlocks.size(); ++i) {
            fl[i] = validBlocks.get((int)i).onepath;
            offset[i] = validBlocks.get((int)i).offset;
            length[i] = validBlocks.get((int)i).length;
        }
        CombineFileSplit thissplit = new CombineFileSplit(job, fl, offset, length, locations.toArray(new String[0]));
        splitList.add(thissplit);
    }

    @Override
    public abstract RecordReader<K, V> getRecordReader(InputSplit var1, JobConf var2, Reporter var3) throws IOException;

    private static void addHostToRack(HashMap<String, Set<String>> rackToNodes, String rack, String host) {
        Set<String> hosts = rackToNodes.get(rack);
        if (hosts == null) {
            hosts = new HashSet<String>();
            rackToNodes.put(rack, hosts);
        }
        hosts.add(host);
    }

    private List<String> getHosts(List<String> racks) {
        ArrayList<String> hosts = new ArrayList<String>();
        for (String rack : racks) {
            hosts.addAll((Collection<String>)this.rackToNodes.get(rack));
        }
        return hosts;
    }

    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter() {
            this.filters = new ArrayList<PathFilter>();
        }

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        public void add(PathFilter one) {
            this.filters.add(one);
        }

        @Override
        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (!filter.accept(path)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            for (PathFilter f : this.filters) {
                buf.append(f);
                buf.append(",");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    private static class OneBlockInfo {
        Path onepath;
        long offset;
        long length;
        String[] hosts;
        String[] racks;

        OneBlockInfo(Path path, long offset, long len, String[] hosts, String[] topologyPaths) {
            int i;
            this.onepath = path;
            this.offset = offset;
            this.hosts = hosts;
            this.length = len;
            assert (hosts.length == topologyPaths.length || topologyPaths.length == 0);
            if (topologyPaths.length == 0) {
                topologyPaths = new String[hosts.length];
                for (i = 0; i < topologyPaths.length; ++i) {
                    topologyPaths[i] = new NodeBase(hosts[i], "/default-rack").toString();
                }
            }
            this.racks = new String[topologyPaths.length];
            for (i = 0; i < topologyPaths.length; ++i) {
                this.racks[i] = new NodeBase(topologyPaths[i]).getNetworkLocation();
            }
        }
    }

    private static class OneFileInfo {
        private long fileSize = 0L;
        private OneBlockInfo[] blocks;

        OneFileInfo(Path path, JobConf job, HashMap<String, List<OneBlockInfo>> rackToBlocks, HashMap<OneBlockInfo, String[]> blockToNodes, HashMap<String, List<OneBlockInfo>> nodeToBlocks, HashMap<String, Set<String>> rackToNodes) throws IOException {
            FileSystem fs = path.getFileSystem(job);
            FileStatus stat = fs.getFileStatus(path);
            BlockLocation[] locations = fs.getFileBlockLocations(stat, 0L, stat.getLen());
            if (locations == null) {
                this.blocks = new OneBlockInfo[0];
            } else {
                this.blocks = new OneBlockInfo[locations.length];
                for (int i = 0; i < locations.length; ++i) {
                    List<OneBlockInfo> blklist;
                    int j;
                    OneBlockInfo oneblock;
                    this.fileSize += locations[i].getLength();
                    this.blocks[i] = oneblock = new OneBlockInfo(path, locations[i].getOffset(), locations[i].getLength(), locations[i].getHosts(), locations[i].getTopologyPaths());
                    blockToNodes.put(oneblock, oneblock.hosts);
                    for (j = 0; j < oneblock.racks.length; ++j) {
                        String rack = oneblock.racks[j];
                        blklist = rackToBlocks.get(rack);
                        if (blklist == null) {
                            blklist = new ArrayList<OneBlockInfo>();
                            rackToBlocks.put(rack, blklist);
                        }
                        blklist.add(oneblock);
                        CombineFileInputFormat.addHostToRack(rackToNodes, oneblock.racks[j], oneblock.hosts[j]);
                    }
                    for (j = 0; j < oneblock.hosts.length; ++j) {
                        String node = oneblock.hosts[j];
                        blklist = nodeToBlocks.get(node);
                        if (blklist == null) {
                            blklist = new ArrayList<OneBlockInfo>();
                            nodeToBlocks.put(node, blklist);
                        }
                        blklist.add(oneblock);
                    }
                }
            }
        }

        long getLength() {
            return this.fileSize;
        }

        OneBlockInfo[] getBlocks() {
            return this.blocks;
        }
    }
}

