/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DNS {
    public static final Log LOG = LogFactory.getLog(DNS.class);

    public static String reverseDns(InetAddress hostIp, String ns) throws NamingException {
        String[] parts = hostIp.getHostAddress().split("\\.");
        String reverseIP = parts[3] + "." + parts[2] + "." + parts[1] + "." + parts[0] + ".in-addr.arpa";
        InitialDirContext ictx = new InitialDirContext();
        Attributes attribute = ictx.getAttributes("dns://" + (ns == null ? "" : ns) + "/" + reverseIP, new String[]{"PTR"});
        ictx.close();
        String hostname = attribute.get("PTR").get().toString();
        int hostnameLength = hostname.length();
        if (hostname.charAt(hostnameLength - 1) == '.') {
            hostname = hostname.substring(0, hostnameLength - 1);
        }
        return hostname;
    }

    private static NetworkInterface getSubinterface(String strInterface) throws SocketException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        while (nifs.hasMoreElements()) {
            Enumeration<NetworkInterface> subNifs = nifs.nextElement().getSubInterfaces();
            while (subNifs.hasMoreElements()) {
                NetworkInterface nif = subNifs.nextElement();
                if (!nif.getName().equals(strInterface)) continue;
                return nif;
            }
        }
        return null;
    }

    private static LinkedHashSet<InetAddress> getSubinterfaceInetAddrs(NetworkInterface nif) {
        LinkedHashSet<InetAddress> addrs = new LinkedHashSet<InetAddress>();
        Enumeration<NetworkInterface> subNifs = nif.getSubInterfaces();
        while (subNifs.hasMoreElements()) {
            NetworkInterface subNif = subNifs.nextElement();
            addrs.addAll(Collections.list(subNif.getInetAddresses()));
        }
        return addrs;
    }

    public static String[] getIPs(String strInterface) throws UnknownHostException {
        return DNS.getIPs(strInterface, true);
    }

    public static String[] getIPs(String strInterface, boolean returnSubinterfaces) throws UnknownHostException {
        NetworkInterface netIf;
        if ("default".equals(strInterface)) {
            return new String[]{InetAddress.getLocalHost().getHostAddress()};
        }
        try {
            netIf = NetworkInterface.getByName(strInterface);
            if (netIf == null && (netIf = DNS.getSubinterface(strInterface)) == null) {
                throw new UnknownHostException("Unknown interface " + strInterface);
            }
        }
        catch (SocketException e) {
            LOG.warn((Object)("Unable to get IP for interface " + strInterface), (Throwable)e);
            return new String[]{InetAddress.getLocalHost().getHostAddress()};
        }
        LinkedHashSet<InetAddress> allAddrs = new LinkedHashSet<InetAddress>();
        allAddrs.addAll(Collections.list(netIf.getInetAddresses()));
        if (!returnSubinterfaces) {
            allAddrs.removeAll(DNS.getSubinterfaceInetAddrs(netIf));
        }
        String[] ips = new String[allAddrs.size()];
        int i = 0;
        for (InetAddress addr : allAddrs) {
            ips[i++] = addr.getHostAddress();
        }
        return ips;
    }

    public static String getDefaultIP(String strInterface) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        return ips[0];
    }

    public static String[] getHosts(String strInterface, String nameserver) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        Vector<String> hosts = new Vector<String>();
        for (int ctr = 0; ctr < ips.length; ++ctr) {
            try {
                hosts.add(DNS.reverseDns(InetAddress.getByName(ips[ctr]), nameserver));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (hosts.size() == 0) {
            return new String[]{InetAddress.getLocalHost().getCanonicalHostName()};
        }
        return hosts.toArray(new String[0]);
    }

    public static String[] getHosts(String strInterface) throws UnknownHostException {
        return DNS.getHosts(strInterface, null);
    }

    public static String getDefaultHost(String strInterface, String nameserver) throws UnknownHostException {
        if (strInterface.equals("default")) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        if (nameserver != null && nameserver.equals("default")) {
            return DNS.getDefaultHost(strInterface);
        }
        String[] hosts = DNS.getHosts(strInterface, nameserver);
        return hosts[0];
    }

    public static String getDefaultHost(String strInterface) throws UnknownHostException {
        return DNS.getDefaultHost(strInterface, null);
    }
}

