/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.similarity.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.PriorityQueue;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItem;

public class TopSimilarItemsQueue
extends PriorityQueue<SimilarItem> {
    private static final long SENTINEL_ID = Long.MIN_VALUE;
    private final int maxSize;

    public TopSimilarItemsQueue(int maxSize) {
        super(maxSize);
        this.maxSize = maxSize;
    }

    public List<SimilarItem> getTopItems() {
        ArrayList items = Lists.newArrayListWithCapacity((int)this.maxSize);
        while (this.size() > 0) {
            SimilarItem topItem = (SimilarItem)this.pop();
            if (topItem.getItemID() == Long.MIN_VALUE) continue;
            items.add(topItem);
        }
        Collections.reverse(items);
        return items;
    }

    protected boolean lessThan(SimilarItem one, SimilarItem two) {
        return one.getSimilarity() < two.getSimilarity();
    }

    protected SimilarItem getSentinelObject() {
        return new SimilarItem(Long.MIN_VALUE, Double.MIN_VALUE);
    }
}

