/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.eval.DataModelBuilder;
import org.apache.mahout.cf.taste.eval.RecommenderBuilder;
import org.apache.mahout.cf.taste.eval.RecommenderEvaluator;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.eval.StatsCallable;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDifferenceRecommenderEvaluator
implements RecommenderEvaluator {
    private static final Logger log = LoggerFactory.getLogger(AbstractDifferenceRecommenderEvaluator.class);
    private final Random random = RandomUtils.getRandom();
    private float maxPreference = Float.NaN;
    private float minPreference = Float.NaN;

    protected AbstractDifferenceRecommenderEvaluator() {
    }

    @Override
    public final float getMaxPreference() {
        return this.maxPreference;
    }

    @Override
    public final void setMaxPreference(float maxPreference) {
        this.maxPreference = maxPreference;
    }

    @Override
    public final float getMinPreference() {
        return this.minPreference;
    }

    @Override
    public final void setMinPreference(float minPreference) {
        this.minPreference = minPreference;
    }

    @Override
    public double evaluate(RecommenderBuilder recommenderBuilder, DataModelBuilder dataModelBuilder, DataModel dataModel, double trainingPercentage, double evaluationPercentage) throws TasteException {
        Preconditions.checkNotNull((Object)recommenderBuilder);
        Preconditions.checkNotNull((Object)dataModel);
        Preconditions.checkArgument((trainingPercentage >= 0.0 && trainingPercentage <= 1.0 ? 1 : 0) != 0, (Object)("Invalid trainingPercentage: " + trainingPercentage + ". Must be: 0.0 <= trainingPercentage <= 1.0"));
        Preconditions.checkArgument((evaluationPercentage >= 0.0 && evaluationPercentage <= 1.0 ? 1 : 0) != 0, (Object)("Invalid evaluationPercentage: " + evaluationPercentage + ". Must be: 0.0 <= evaluationPercentage <= 1.0"));
        log.info("Beginning evaluation using {} of {}", (Object)trainingPercentage, (Object)dataModel);
        int numUsers = dataModel.getNumUsers();
        FastByIDMap<PreferenceArray> trainingPrefs = new FastByIDMap<PreferenceArray>(1 + (int)(evaluationPercentage * (double)numUsers));
        FastByIDMap<PreferenceArray> testPrefs = new FastByIDMap<PreferenceArray>(1 + (int)(evaluationPercentage * (double)numUsers));
        LongPrimitiveIterator it = dataModel.getUserIDs();
        while (it.hasNext()) {
            long userID = it.nextLong();
            if (!(this.random.nextDouble() < evaluationPercentage)) continue;
            this.splitOneUsersPrefs(trainingPercentage, trainingPrefs, testPrefs, userID, dataModel);
        }
        DataModel trainingModel = dataModelBuilder == null ? new GenericDataModel(trainingPrefs) : dataModelBuilder.buildDataModel(trainingPrefs);
        Recommender recommender = recommenderBuilder.buildRecommender(trainingModel);
        double result = this.getEvaluation(testPrefs, recommender);
        log.info("Evaluation result: {}", (Object)result);
        return result;
    }

    private void splitOneUsersPrefs(double trainingPercentage, FastByIDMap<PreferenceArray> trainingPrefs, FastByIDMap<PreferenceArray> testPrefs, long userID, DataModel dataModel) throws TasteException {
        ArrayList oneUserTrainingPrefs = null;
        ArrayList oneUserTestPrefs = null;
        PreferenceArray prefs = dataModel.getPreferencesFromUser(userID);
        int size = prefs.length();
        for (int i = 0; i < size; ++i) {
            GenericPreference newPref = new GenericPreference(userID, prefs.getItemID(i), prefs.getValue(i));
            if (this.random.nextDouble() < trainingPercentage) {
                if (oneUserTrainingPrefs == null) {
                    oneUserTrainingPrefs = Lists.newArrayListWithCapacity((int)3);
                }
                oneUserTrainingPrefs.add(newPref);
                continue;
            }
            if (oneUserTestPrefs == null) {
                oneUserTestPrefs = Lists.newArrayListWithCapacity((int)3);
            }
            oneUserTestPrefs.add(newPref);
        }
        if (oneUserTrainingPrefs != null) {
            trainingPrefs.put(userID, new GenericUserPreferenceArray(oneUserTrainingPrefs));
            if (oneUserTestPrefs != null) {
                testPrefs.put(userID, new GenericUserPreferenceArray(oneUserTestPrefs));
            }
        }
    }

    private float capEstimatedPreference(float estimate) {
        if (estimate > this.maxPreference) {
            return this.maxPreference;
        }
        if (estimate < this.minPreference) {
            return this.minPreference;
        }
        return estimate;
    }

    private double getEvaluation(FastByIDMap<PreferenceArray> testPrefs, Recommender recommender) throws TasteException {
        this.reset();
        ArrayList estimateCallables = Lists.newArrayList();
        AtomicInteger noEstimateCounter = new AtomicInteger();
        for (Map.Entry<Long, PreferenceArray> entry : testPrefs.entrySet()) {
            estimateCallables.add(new PreferenceEstimateCallable(recommender, entry.getKey(), entry.getValue(), noEstimateCounter));
        }
        log.info("Beginning evaluation of {} users", (Object)estimateCallables.size());
        FullRunningAverageAndStdDev timing = new FullRunningAverageAndStdDev();
        AbstractDifferenceRecommenderEvaluator.execute(estimateCallables, noEstimateCounter, timing);
        return this.computeFinalEvaluation();
    }

    protected static void execute(Collection<Callable<Void>> callables, AtomicInteger noEstimateCounter, RunningAverageAndStdDev timing) throws TasteException {
        Collection<Callable<Void>> wrappedCallables = AbstractDifferenceRecommenderEvaluator.wrapWithStatsCallables(callables, noEstimateCounter, timing);
        int numProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(numProcessors);
        log.info("Starting timing of {} tasks in {} threads", (Object)wrappedCallables.size(), (Object)numProcessors);
        try {
            List<Future<Void>> futures = executor.invokeAll(wrappedCallables);
            for (Future<Void> future : futures) {
                future.get();
            }
        }
        catch (InterruptedException ie) {
            throw new TasteException(ie);
        }
        catch (ExecutionException ee) {
            throw new TasteException(ee.getCause());
        }
        executor.shutdown();
        try {
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new TasteException(e.getCause());
        }
    }

    private static Collection<Callable<Void>> wrapWithStatsCallables(Iterable<Callable<Void>> callables, AtomicInteger noEstimateCounter, RunningAverageAndStdDev timing) {
        ArrayList wrapped = Lists.newArrayList();
        int count = 0;
        for (Callable<Void> callable : callables) {
            boolean logStats = count++ % 1000 == 0;
            wrapped.add(new StatsCallable(callable, logStats, timing, noEstimateCounter));
        }
        return wrapped;
    }

    protected abstract void reset();

    protected abstract void processOneEstimate(float var1, Preference var2);

    protected abstract double computeFinalEvaluation();

    public final class PreferenceEstimateCallable
    implements Callable<Void> {
        private final Recommender recommender;
        private final long testUserID;
        private final PreferenceArray prefs;
        private final AtomicInteger noEstimateCounter;

        public PreferenceEstimateCallable(Recommender recommender, long testUserID, PreferenceArray prefs, AtomicInteger noEstimateCounter) {
            this.recommender = recommender;
            this.testUserID = testUserID;
            this.prefs = prefs;
            this.noEstimateCounter = noEstimateCounter;
        }

        @Override
        public Void call() throws TasteException {
            for (Preference realPref : this.prefs) {
                float estimatedPreference = Float.NaN;
                try {
                    estimatedPreference = this.recommender.estimatePreference(this.testUserID, realPref.getItemID());
                }
                catch (NoSuchUserException nsue) {
                    log.info("User exists in test data but not training data: {}", (Object)this.testUserID);
                }
                catch (NoSuchItemException nsie) {
                    log.info("Item exists in test data but not training data: {}", (Object)realPref.getItemID());
                }
                if (Float.isNaN(estimatedPreference)) {
                    this.noEstimateCounter.incrementAndGet();
                    continue;
                }
                estimatedPreference = AbstractDifferenceRecommenderEvaluator.this.capEstimatedPreference(estimatedPreference);
                AbstractDifferenceRecommenderEvaluator.this.processOneEstimate(estimatedPreference, realPref);
            }
            return null;
        }
    }
}

