/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import java.util.Random;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmAlgorithms;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmUtils;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;

public final class HmmEvaluator {
    private HmmEvaluator() {
    }

    public static int[] predict(HmmModel model, int steps) {
        return HmmEvaluator.predict(model, steps, (Random)RandomUtils.getRandom());
    }

    public static int[] predict(HmmModel model, int steps, long seed) {
        return HmmEvaluator.predict(model, steps, RandomUtils.getRandom((long)seed));
    }

    private static int[] predict(HmmModel model, int steps, Random rand) {
        Vector cip = HmmUtils.getCumulativeInitialProbabilities(model);
        Matrix ctm = HmmUtils.getCumulativeTransitionMatrix(model);
        Matrix com = HmmUtils.getCumulativeOutputMatrix(model);
        int[] result = new int[steps];
        int hiddenState = 0;
        double randnr = rand.nextDouble();
        while (cip.get(hiddenState) < randnr) {
            ++hiddenState;
        }
        for (int step = 0; step < steps; ++step) {
            randnr = rand.nextDouble();
            int outputState = 0;
            while (com.get(hiddenState, outputState) < randnr) {
                ++outputState;
            }
            result[step] = outputState;
            randnr = rand.nextDouble();
            int nextHiddenState = 0;
            while (ctm.get(hiddenState, nextHiddenState) < randnr) {
                ++nextHiddenState;
            }
            hiddenState = nextHiddenState;
        }
        return result;
    }

    public static double modelLikelihood(HmmModel model, int[] outputSequence, boolean scaled) {
        return HmmEvaluator.modelLikelihood(HmmAlgorithms.forwardAlgorithm(model, outputSequence, scaled), scaled);
    }

    public static double modelLikelihood(Matrix alpha, boolean scaled) {
        double likelihood = 0.0;
        if (scaled) {
            for (int i = 0; i < alpha.numCols(); ++i) {
                likelihood += Math.exp(alpha.getQuick(alpha.numRows() - 1, i));
            }
        } else {
            for (int i = 0; i < alpha.numCols(); ++i) {
                likelihood += alpha.getQuick(alpha.numRows() - 1, i);
            }
        }
        return likelihood;
    }

    public static double modelLikelihood(HmmModel model, int[] outputSequence, Matrix beta, boolean scaled) {
        double likelihood = 0.0;
        Matrix e = model.getEmissionMatrix();
        Vector pi = model.getInitialProbabilities();
        int firstOutput = outputSequence[0];
        if (scaled) {
            for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                likelihood += pi.getQuick(i) * Math.exp(beta.getQuick(0, i)) * e.getQuick(i, firstOutput);
            }
        } else {
            for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                likelihood += pi.getQuick(i) * beta.getQuick(0, i) * e.getQuick(i, firstOutput);
            }
        }
        return likelihood;
    }

    public static int[] decode(HmmModel model, int[] observations, boolean scaled) {
        return HmmAlgorithms.viterbiAlgorithm(model, observations, scaled);
    }
}

