/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.iterator;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansClusterer;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.clustering.iterator.AbstractClusteringPolicy;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.math.Vector;

public class FuzzyKMeansClusteringPolicy
extends AbstractClusteringPolicy {
    private double m = 2.0;
    private double convergenceDelta = 0.05;

    public FuzzyKMeansClusteringPolicy() {
    }

    public FuzzyKMeansClusteringPolicy(double m, double convergenceDelta) {
        this.m = m;
        this.convergenceDelta = convergenceDelta;
    }

    @Override
    public Vector select(Vector probabilities) {
        return probabilities;
    }

    @Override
    public Vector classify(Vector data, ClusterClassifier prior) {
        ArrayList clusters = Lists.newArrayList();
        ArrayList distances = Lists.newArrayList();
        for (Cluster model : prior.getModels()) {
            SoftCluster sc = (SoftCluster)model;
            clusters.add(sc);
            distances.add(sc.getMeasure().distance(data, sc.getCenter()));
        }
        FuzzyKMeansClusterer fuzzyKMeansClusterer = new FuzzyKMeansClusterer();
        fuzzyKMeansClusterer.setM(this.m);
        return fuzzyKMeansClusterer.computePi(clusters, distances);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.m);
        out.writeDouble(this.convergenceDelta);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.m = in.readDouble();
        this.convergenceDelta = in.readDouble();
    }

    @Override
    public void close(ClusterClassifier posterior) {
        for (Cluster cluster : posterior.getModels()) {
            ((Kluster)cluster).calculateConvergence(this.convergenceDelta);
            cluster.computeParameters();
        }
    }
}

