/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KMeansUtil {
    private static final Logger log = LoggerFactory.getLogger(KMeansUtil.class);

    private KMeansUtil() {
    }

    public static void configureWithClusterInfo(Configuration conf, Path clusterPath, Collection<Cluster> clusters) {
        for (Writable value : new SequenceFileDirValueIterable(clusterPath, PathType.LIST, PathFilters.partFilter(), conf)) {
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(ClusterWritable.class)) {
                ClusterWritable clusterWritable = (ClusterWritable)value;
                value = clusterWritable.getValue();
                valueClass = value.getClass();
            }
            log.debug("Read 1 Cluster from {}", (Object)clusterPath);
            if (valueClass.equals(Kluster.class)) {
                clusters.add((Kluster)value);
                continue;
            }
            if (valueClass.equals(Canopy.class)) {
                Canopy canopy = (Canopy)value;
                clusters.add(new Kluster(canopy.getCenter(), canopy.getId(), canopy.getMeasure()));
                continue;
            }
            throw new IllegalStateException("Bad value class: " + valueClass);
        }
    }
}

